/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.rest.ChunkedRestResponseBodyPart;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestActionListener;
import org.elasticsearch.xcontent.ToXContent;

public class RestChunkedToXContentListener<Response extends ChunkedToXContent>
extends RestActionListener<Response> {
    private final ToXContent.Params params;

    public RestChunkedToXContentListener(RestChannel channel) {
        this(channel, channel.request());
    }

    public RestChunkedToXContentListener(RestChannel channel, ToXContent.Params params) {
        super(channel);
        this.params = params;
    }

    @Override
    protected void processResponse(Response response) throws IOException {
        this.channel.sendResponse(RestResponse.chunked(this.getRestStatus(response), ChunkedRestResponseBodyPart.fromXContent(response, this.params, this.channel), this.releasableFromResponse(response)));
    }

    protected Releasable releasableFromResponse(Response response) {
        return null;
    }

    protected RestStatus getRestStatus(Response response) {
        return RestStatus.OK;
    }
}

