/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.spi;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class WhitelistMethod {
    public final String origin;
    public final String augmentedCanonicalClassName;
    public final String methodName;
    public final String returnCanonicalTypeName;
    public final List<String> canonicalTypeNameParameters;
    public final Map<Class<?>, Object> painlessAnnotations;

    public WhitelistMethod(String origin, String augmentedCanonicalClassName, String methodName, String returnCanonicalTypeName, List<String> canonicalTypeNameParameters, List<Object> painlessAnnotations) {
        this.origin = Objects.requireNonNull(origin);
        this.augmentedCanonicalClassName = augmentedCanonicalClassName;
        this.methodName = methodName;
        this.returnCanonicalTypeName = Objects.requireNonNull(returnCanonicalTypeName);
        this.canonicalTypeNameParameters = List.copyOf(canonicalTypeNameParameters);
        this.painlessAnnotations = painlessAnnotations.stream().collect(Collectors.toUnmodifiableMap(Object::getClass, Function.identity()));
    }
}

