/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.process;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.SingleObjectCache;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.monitor.process.ProcessInfo;
import org.elasticsearch.monitor.process.ProcessProbe;
import org.elasticsearch.monitor.process.ProcessStats;
import org.elasticsearch.node.ReportingService;

public final class ProcessService
implements ReportingService<ProcessInfo> {
    private static final Logger logger = LogManager.getLogger(ProcessService.class);
    private final ProcessInfo info;
    private final SingleObjectCache<ProcessStats> processStatsCache;
    public static final Setting<TimeValue> REFRESH_INTERVAL_SETTING = Setting.timeSetting("monitor.process.refresh_interval", TimeValue.timeValueSeconds(1L), TimeValue.timeValueSeconds(1L), Setting.Property.NodeScope);

    public ProcessService(Settings settings) {
        TimeValue refreshInterval = REFRESH_INTERVAL_SETTING.get(settings);
        this.processStatsCache = new ProcessStatsCache(refreshInterval, ProcessProbe.processStats());
        this.info = ProcessProbe.processInfo(refreshInterval.millis());
        logger.debug("using refresh_interval [{}]", (Object)refreshInterval);
    }

    @Override
    public ProcessInfo info() {
        return this.info;
    }

    public ProcessStats stats() {
        return this.processStatsCache.getOrRefresh();
    }

    private static class ProcessStatsCache
    extends SingleObjectCache<ProcessStats> {
        ProcessStatsCache(TimeValue interval, ProcessStats initValue) {
            super(interval, initValue);
        }

        @Override
        protected ProcessStats refresh() {
            return ProcessProbe.processStats();
        }
    }
}

