/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.jvm;

import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.ManagementPermission;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.Constants;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.node.ReportingService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class JvmInfo
implements ReportingService.Info {
    private static final JvmInfo INSTANCE;
    private final long pid;
    private final String version;
    private final String vmName;
    private final String vmVersion;
    private final String vmVendor;
    private final Boolean usingBundledJdk;
    private final long startTime;
    private final long configuredInitialHeapSize;
    private final long configuredMaxHeapSize;
    private final Mem mem;
    private final String[] inputArguments;
    private final String bootClassPath;
    private final String classPath;
    private final Map<String, String> systemProperties;
    private final String[] gcCollectors;
    private final String[] memoryPools;
    private final String onError;
    private final String onOutOfMemoryError;
    private final String useCompressedOops;
    private final String useG1GC;
    private final String useSerialGC;
    private final long g1RegionSize;

    @SuppressForbidden(reason="PathUtils#get")
    private static boolean usingBundledJdk() {
        String javaHome = System.getProperty("java.home");
        String userDir = System.getProperty("user.dir");
        if (Constants.MAC_OS_X) {
            return PathUtils.get(javaHome, new String[0]).equals(PathUtils.get(userDir, new String[0]).resolve("jdk.app/Contents/Home").toAbsolutePath());
        }
        return PathUtils.get(javaHome, new String[0]).equals(PathUtils.get(userDir, new String[0]).resolve("jdk").toAbsolutePath());
    }

    public static JvmInfo jvmInfo() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ManagementPermission("monitor"));
            sm.checkPropertyAccess("*");
        }
        return INSTANCE;
    }

    private JvmInfo(long pid, String version, String vmName, String vmVersion, String vmVendor, Boolean usingBundledJdk, long startTime, long configuredInitialHeapSize, long configuredMaxHeapSize, Mem mem, String[] inputArguments, String bootClassPath, String classPath, Map<String, String> systemProperties, String[] gcCollectors, String[] memoryPools, String onError, String onOutOfMemoryError, String useCompressedOops, String useG1GC, String useSerialGC, long g1RegionSize) {
        this.pid = pid;
        this.version = version;
        this.vmName = vmName;
        this.vmVersion = vmVersion;
        this.vmVendor = vmVendor;
        this.usingBundledJdk = usingBundledJdk;
        this.startTime = startTime;
        this.configuredInitialHeapSize = configuredInitialHeapSize;
        this.configuredMaxHeapSize = configuredMaxHeapSize;
        this.mem = mem;
        this.inputArguments = inputArguments;
        this.bootClassPath = bootClassPath;
        this.classPath = classPath;
        this.systemProperties = systemProperties;
        this.gcCollectors = gcCollectors;
        this.memoryPools = memoryPools;
        this.onError = onError;
        this.onOutOfMemoryError = onOutOfMemoryError;
        this.useCompressedOops = useCompressedOops;
        this.useG1GC = useG1GC;
        this.useSerialGC = useSerialGC;
        this.g1RegionSize = g1RegionSize;
    }

    public JvmInfo(StreamInput in) throws IOException {
        this.pid = in.readLong();
        this.version = in.readString();
        this.vmName = in.readString();
        this.vmVersion = in.readString();
        this.vmVendor = in.readString();
        if (in.getTransportVersion().before(TransportVersions.V_8_3_0)) {
            in.readBoolean();
        }
        this.usingBundledJdk = in.readOptionalBoolean();
        this.startTime = in.readLong();
        this.inputArguments = new String[in.readInt()];
        for (int i = 0; i < this.inputArguments.length; ++i) {
            this.inputArguments[i] = in.readString();
        }
        this.bootClassPath = in.readString();
        this.classPath = in.readString();
        this.systemProperties = in.readMap(StreamInput::readString);
        this.mem = new Mem(in);
        this.gcCollectors = in.readStringArray();
        this.memoryPools = in.readStringArray();
        this.useCompressedOops = in.readString();
        this.configuredMaxHeapSize = -1L;
        this.configuredInitialHeapSize = -1L;
        this.onError = null;
        this.onOutOfMemoryError = null;
        this.useG1GC = "unknown";
        this.useSerialGC = "unknown";
        this.g1RegionSize = -1L;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.pid);
        out.writeString(this.version);
        out.writeString(this.vmName);
        out.writeString(this.vmVersion);
        out.writeString(this.vmVendor);
        if (out.getTransportVersion().before(TransportVersions.V_8_3_0)) {
            out.writeBoolean(true);
        }
        out.writeOptionalBoolean(this.usingBundledJdk);
        out.writeLong(this.startTime);
        out.writeInt(this.inputArguments.length);
        for (String inputArgument : this.inputArguments) {
            out.writeString(inputArgument);
        }
        out.writeString(this.bootClassPath);
        out.writeString(this.classPath);
        out.writeMap(this.systemProperties, StreamOutput::writeString);
        this.mem.writeTo(out);
        out.writeStringArray(this.gcCollectors);
        out.writeStringArray(this.memoryPools);
        out.writeString(this.useCompressedOops);
    }

    public long pid() {
        return this.pid;
    }

    public long getPid() {
        return this.pid;
    }

    public String version() {
        return this.version;
    }

    public String getVersion() {
        return this.version;
    }

    public String getVmName() {
        return this.vmName;
    }

    public String getVmVersion() {
        return this.vmVersion;
    }

    public String getVmVendor() {
        return this.vmVendor;
    }

    public Boolean getUsingBundledJdk() {
        return this.usingBundledJdk;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Mem getMem() {
        return this.mem;
    }

    public String[] getInputArguments() {
        return this.inputArguments;
    }

    public long getConfiguredInitialHeapSize() {
        return this.configuredInitialHeapSize;
    }

    public long getConfiguredMaxHeapSize() {
        return this.configuredMaxHeapSize;
    }

    public String onError() {
        return this.onError;
    }

    public String onOutOfMemoryError() {
        return this.onOutOfMemoryError;
    }

    public String useCompressedOops() {
        return this.useCompressedOops;
    }

    public String useG1GC() {
        return this.useG1GC;
    }

    public String useSerialGC() {
        return this.useSerialGC;
    }

    public long getG1RegionSize() {
        return this.g1RegionSize;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("jvm");
        builder.field("pid", this.pid);
        builder.field("version", this.version);
        builder.field("vm_name", this.vmName);
        builder.field("vm_version", this.vmVersion);
        builder.field("vm_vendor", this.vmVendor);
        builder.field("using_bundled_jdk", this.usingBundledJdk);
        builder.timestampFieldsFromUnixEpochMillis("start_time_in_millis", "start_time", this.startTime);
        builder.startObject("mem");
        builder.humanReadableField("heap_init_in_bytes", "heap_init", ByteSizeValue.ofBytes(this.mem.heapInit));
        builder.humanReadableField("heap_max_in_bytes", "heap_max", ByteSizeValue.ofBytes(this.mem.heapMax));
        builder.humanReadableField("non_heap_init_in_bytes", "non_heap_init", ByteSizeValue.ofBytes(this.mem.nonHeapInit));
        builder.humanReadableField("non_heap_max_in_bytes", "non_heap_max", ByteSizeValue.ofBytes(this.mem.nonHeapMax));
        builder.humanReadableField("direct_max_in_bytes", "direct_max", ByteSizeValue.ofBytes(this.mem.directMemoryMax));
        builder.endObject();
        builder.array("gc_collectors", this.gcCollectors);
        builder.array("memory_pools", this.memoryPools);
        builder.field("using_compressed_ordinary_object_pointers", this.useCompressedOops);
        builder.field("input_arguments", this.inputArguments);
        builder.endObject();
        return builder;
    }

    static {
        String bootClassPath;
        String[] inputArguments;
        long directMemoryMax;
        long nonHeapMax;
        long nonHeapInit;
        long heapMax;
        long heapInit;
        RuntimeMXBean runtimeMXBean;
        block22: {
            runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
            heapInit = memoryMXBean.getHeapMemoryUsage().getInit() < 0L ? 0L : memoryMXBean.getHeapMemoryUsage().getInit();
            heapMax = memoryMXBean.getHeapMemoryUsage().getMax() < 0L ? 0L : memoryMXBean.getHeapMemoryUsage().getMax();
            nonHeapInit = memoryMXBean.getNonHeapMemoryUsage().getInit() < 0L ? 0L : memoryMXBean.getNonHeapMemoryUsage().getInit();
            nonHeapMax = memoryMXBean.getNonHeapMemoryUsage().getMax() < 0L ? 0L : memoryMXBean.getNonHeapMemoryUsage().getMax();
            directMemoryMax = 0L;
            inputArguments = runtimeMXBean.getInputArguments().toArray(new String[runtimeMXBean.getInputArguments().size()]);
            try {
                bootClassPath = runtimeMXBean.getBootClassPath();
            }
            catch (UnsupportedOperationException e) {
                bootClassPath = System.getProperty("sun.boot.class.path");
                if (bootClassPath != null) break block22;
                bootClassPath = "<unknown>";
            }
        }
        String classPath = runtimeMXBean.getClassPath();
        Map<String, String> systemProperties = Collections.unmodifiableMap(runtimeMXBean.getSystemProperties());
        List<GarbageCollectorMXBean> gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        String[] gcCollectors = new String[gcMxBeans.size()];
        for (int i = 0; i < gcMxBeans.size(); ++i) {
            GarbageCollectorMXBean gcMxBean = gcMxBeans.get(i);
            gcCollectors[i] = gcMxBean.getName();
        }
        List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        String[] memoryPools = new String[memoryPoolMXBeans.size()];
        for (int i = 0; i < memoryPoolMXBeans.size(); ++i) {
            MemoryPoolMXBean memoryPoolMXBean = memoryPoolMXBeans.get(i);
            memoryPools[i] = memoryPoolMXBean.getName();
        }
        String onError = null;
        String onOutOfMemoryError = null;
        String useCompressedOops = "unknown";
        String useG1GC = "unknown";
        long g1RegisionSize = -1L;
        String useSerialGC = "unknown";
        long configuredInitialHeapSize = -1L;
        long configuredMaxHeapSize = -1L;
        try {
            Class<?> clazz = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            Class<?> vmOptionClazz = Class.forName("com.sun.management.VMOption");
            Object hotSpotDiagnosticMXBean = ManagementFactory.getPlatformMXBean(clazz);
            Method vmOptionMethod = clazz.getMethod("getVMOption", String.class);
            Method valueMethod = vmOptionClazz.getMethod("getValue", new Class[0]);
            try {
                Object onErrorObject = vmOptionMethod.invoke(hotSpotDiagnosticMXBean, "OnError");
                onError = (String)valueMethod.invoke(onErrorObject, new Object[0]);
            }
            catch (Exception onErrorObject) {
                // empty catch block
            }
            try {
                Object onOutOfMemoryErrorObject = vmOptionMethod.invoke(hotSpotDiagnosticMXBean, "OnOutOfMemoryError");
                onOutOfMemoryError = (String)valueMethod.invoke(onOutOfMemoryErrorObject, new Object[0]);
            }
            catch (Exception onOutOfMemoryErrorObject) {
                // empty catch block
            }
            try {
                Object useCompressedOopsVmOptionObject = vmOptionMethod.invoke(hotSpotDiagnosticMXBean, "UseCompressedOops");
                useCompressedOops = (String)valueMethod.invoke(useCompressedOopsVmOptionObject, new Object[0]);
            }
            catch (Exception useCompressedOopsVmOptionObject) {
                // empty catch block
            }
            try {
                Object useG1GCVmOptionObject = vmOptionMethod.invoke(hotSpotDiagnosticMXBean, "UseG1GC");
                useG1GC = (String)valueMethod.invoke(useG1GCVmOptionObject, new Object[0]);
                Object regionSizeVmOptionObject = vmOptionMethod.invoke(hotSpotDiagnosticMXBean, "G1HeapRegionSize");
                g1RegisionSize = Long.parseLong((String)valueMethod.invoke(regionSizeVmOptionObject, new Object[0]));
            }
            catch (Exception useG1GCVmOptionObject) {
                // empty catch block
            }
            try {
                Object initialHeapSizeVmOptionObject = vmOptionMethod.invoke(hotSpotDiagnosticMXBean, "InitialHeapSize");
                configuredInitialHeapSize = Long.parseLong((String)valueMethod.invoke(initialHeapSizeVmOptionObject, new Object[0]));
            }
            catch (Exception initialHeapSizeVmOptionObject) {
                // empty catch block
            }
            try {
                Object maxHeapSizeVmOptionObject = vmOptionMethod.invoke(hotSpotDiagnosticMXBean, "MaxHeapSize");
                configuredMaxHeapSize = Long.parseLong((String)valueMethod.invoke(maxHeapSizeVmOptionObject, new Object[0]));
            }
            catch (Exception maxHeapSizeVmOptionObject) {
                // empty catch block
            }
            try {
                Object maxDirectMemorySizeVmOptionObject = vmOptionMethod.invoke(hotSpotDiagnosticMXBean, "MaxDirectMemorySize");
                directMemoryMax = Long.parseLong((String)valueMethod.invoke(maxDirectMemorySizeVmOptionObject, new Object[0]));
            }
            catch (Exception maxDirectMemorySizeVmOptionObject) {
                // empty catch block
            }
            try {
                Object useSerialGCVmOptionObject = vmOptionMethod.invoke(hotSpotDiagnosticMXBean, "UseSerialGC");
                useSerialGC = (String)valueMethod.invoke(useSerialGCVmOptionObject, new Object[0]);
            }
            catch (Exception exception) {}
        }
        catch (Exception clazz) {
            // empty catch block
        }
        Mem mem = new Mem(heapInit, heapMax, nonHeapInit, nonHeapMax, directMemoryMax);
        INSTANCE = new JvmInfo(ProcessHandle.current().pid(), System.getProperty("java.version"), runtimeMXBean.getVmName(), runtimeMXBean.getVmVersion(), runtimeMXBean.getVmVendor(), JvmInfo.usingBundledJdk(), runtimeMXBean.getStartTime(), configuredInitialHeapSize, configuredMaxHeapSize, mem, inputArguments, bootClassPath, classPath, systemProperties, gcCollectors, memoryPools, onError, onOutOfMemoryError, useCompressedOops, useG1GC, useSerialGC, g1RegisionSize);
    }

    public static class Mem
    implements Writeable {
        private final long heapInit;
        private final long heapMax;
        private final long nonHeapInit;
        private final long nonHeapMax;
        private final long directMemoryMax;

        public Mem(long heapInit, long heapMax, long nonHeapInit, long nonHeapMax, long directMemoryMax) {
            this.heapInit = heapInit;
            this.heapMax = heapMax;
            this.nonHeapInit = nonHeapInit;
            this.nonHeapMax = nonHeapMax;
            this.directMemoryMax = directMemoryMax;
        }

        public Mem(StreamInput in) throws IOException {
            this.heapInit = in.readVLong();
            this.heapMax = in.readVLong();
            this.nonHeapInit = in.readVLong();
            this.nonHeapMax = in.readVLong();
            this.directMemoryMax = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.heapInit);
            out.writeVLong(this.heapMax);
            out.writeVLong(this.nonHeapInit);
            out.writeVLong(this.nonHeapMax);
            out.writeVLong(this.directMemoryMax);
        }

        public ByteSizeValue getHeapInit() {
            return ByteSizeValue.ofBytes(this.heapInit);
        }

        public ByteSizeValue getHeapMax() {
            return ByteSizeValue.ofBytes(this.heapMax);
        }

        public ByteSizeValue getTotalMax() {
            return ByteSizeValue.ofBytes(this.heapMax + this.nonHeapMax + this.directMemoryMax);
        }
    }

    static final class Fields {
        static final String JVM = "jvm";
        static final String PID = "pid";
        static final String VERSION = "version";
        static final String VM_NAME = "vm_name";
        static final String VM_VERSION = "vm_version";
        static final String VM_VENDOR = "vm_vendor";
        static final String USING_BUNDLED_JDK = "using_bundled_jdk";
        static final String START_TIME = "start_time";
        static final String START_TIME_IN_MILLIS = "start_time_in_millis";
        static final String MEM = "mem";
        static final String HEAP_INIT = "heap_init";
        static final String HEAP_INIT_IN_BYTES = "heap_init_in_bytes";
        static final String HEAP_MAX = "heap_max";
        static final String HEAP_MAX_IN_BYTES = "heap_max_in_bytes";
        static final String NON_HEAP_INIT = "non_heap_init";
        static final String NON_HEAP_INIT_IN_BYTES = "non_heap_init_in_bytes";
        static final String NON_HEAP_MAX = "non_heap_max";
        static final String NON_HEAP_MAX_IN_BYTES = "non_heap_max_in_bytes";
        static final String DIRECT_MAX = "direct_max";
        static final String DIRECT_MAX_IN_BYTES = "direct_max_in_bytes";
        static final String GC_COLLECTORS = "gc_collectors";
        static final String MEMORY_POOLS = "memory_pools";
        static final String USING_COMPRESSED_OOPS = "using_compressed_ordinary_object_pointers";
        static final String INPUT_ARGUMENTS = "input_arguments";

        Fields() {
        }
    }
}

