/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetTrialStatusResponse
extends ActionResponse
implements ToXContentObject {
    private final boolean eligibleToStartTrial;

    GetTrialStatusResponse(StreamInput in) throws IOException {
        super(in);
        this.eligibleToStartTrial = in.readBoolean();
    }

    public GetTrialStatusResponse(boolean eligibleToStartTrial) {
        this.eligibleToStartTrial = eligibleToStartTrial;
    }

    boolean isEligibleToStartTrial() {
        return this.eligibleToStartTrial;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.eligibleToStartTrial);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetTrialStatusResponse that = (GetTrialStatusResponse)o;
        return this.eligibleToStartTrial == that.eligibleToStartTrial;
    }

    public int hashCode() {
        return Objects.hash(this.eligibleToStartTrial);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("eligible_to_start_trial", this.eligibleToStartTrial);
        builder.endObject();
        return builder;
    }
}

