/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.threadpool.ThreadPool;

final class IndexShardOperationPermits
implements Closeable {
    private static final Logger logger = LogManager.getLogger(IndexShardOperationPermits.class);
    private final ShardId shardId;
    private final ThreadPool threadPool;
    static final int TOTAL_PERMITS = Integer.MAX_VALUE;
    final Semaphore semaphore = new Semaphore(Integer.MAX_VALUE, true);
    private final List<ActionListener<Releasable>> delayedOperations = new ArrayList<ActionListener<Releasable>>();
    private volatile boolean closed;
    private int queuedBlockOperations;

    IndexShardOperationPermits(ShardId shardId, ThreadPool threadPool) {
        this.shardId = shardId;
        this.threadPool = threadPool;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public void blockOperations(ActionListener<Releasable> onAcquired, long timeout, TimeUnit timeUnit, Executor executor) {
        this.delayOperations();
        this.waitUntilBlocked(ActionListener.assertOnce(onAcquired), timeout, timeUnit, executor);
    }

    private void waitUntilBlocked(final ActionListener<Releasable> onAcquired, final long timeout, final TimeUnit timeUnit, Executor executor) {
        executor.execute(new AbstractRunnable(){
            final Releasable released = Releasables.releaseOnce(() -> IndexShardOperationPermits.this.releaseDelayedOperations());

            @Override
            public void onFailure(Exception e) {
                try {
                    this.released.close();
                }
                finally {
                    onAcquired.onFailure(e);
                }
            }

            @Override
            protected void doRun() {
                Releasable releasable;
                try {
                    releasable = IndexShardOperationPermits.this.acquireAll(timeout, timeUnit);
                }
                catch (Exception e) {
                    this.onFailure(e);
                    return;
                }
                Releasable combined = Releasables.wrap(releasable, this.released);
                try {
                    onAcquired.onResponse(combined);
                }
                catch (Exception e) {
                    logger.error("onAcquired#onResponse should not throw", (Throwable)e);
                    assert (false) : e;
                    combined.close();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delayOperations() {
        if (this.closed) {
            throw new IndexShardClosedException(this.shardId);
        }
        IndexShardOperationPermits indexShardOperationPermits = this;
        synchronized (indexShardOperationPermits) {
            assert (this.queuedBlockOperations > 0 || this.delayedOperations.isEmpty());
            ++this.queuedBlockOperations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Releasable acquireAll(long timeout, TimeUnit timeUnit) throws InterruptedException {
        if (Assertions.ENABLED) {
            IndexShardOperationPermits indexShardOperationPermits = this;
            synchronized (indexShardOperationPermits) {
                assert (this.queuedBlockOperations > 0);
            }
        }
        if (this.semaphore.tryAcquire(Integer.MAX_VALUE, timeout, timeUnit)) {
            return Releasables.releaseOnce(() -> {
                assert (this.semaphore.availablePermits() == 0);
                this.semaphore.release(Integer.MAX_VALUE);
            });
        }
        throw new ElasticsearchTimeoutException("timeout while blocking operations after [" + String.valueOf(new TimeValue(timeout, timeUnit)) + "]", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseDelayedOperations() {
        List queuedActions;
        IndexShardOperationPermits indexShardOperationPermits = this;
        synchronized (indexShardOperationPermits) {
            assert (this.queuedBlockOperations > 0);
            --this.queuedBlockOperations;
            if (this.queuedBlockOperations == 0) {
                queuedActions = new ArrayList<ActionListener<Releasable>>(this.delayedOperations);
                this.delayedOperations.clear();
            } else {
                queuedActions = Collections.emptyList();
            }
        }
        if (!queuedActions.isEmpty()) {
            this.threadPool.executor("generic").execute(() -> {
                for (ActionListener queuedAction : queuedActions) {
                    this.acquire(queuedAction, null, false);
                }
            });
        }
    }

    public void acquire(ActionListener<Releasable> onAcquired, @Nullable Executor executorOnDelay, boolean forceExecution) {
        this.innerAcquire(ActionListener.assertOnce(onAcquired), executorOnDelay, forceExecution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerAcquire(ActionListener<Releasable> onAcquired, @Nullable Executor executorOnDelay, final boolean forceExecution) {
        Releasable releasable;
        if (this.closed) {
            onAcquired.onFailure(new IndexShardClosedException(this.shardId));
            return;
        }
        try {
            IndexShardOperationPermits indexShardOperationPermits = this;
            synchronized (indexShardOperationPermits) {
                if (this.queuedBlockOperations > 0) {
                    Supplier<ThreadContext.StoredContext> contextSupplier = this.threadPool.getThreadContext().newRestorableContext(false);
                    ActionListener<Releasable> wrappedListener = executorOnDelay != null ? new ContextPreservingActionListener<Releasable>(contextSupplier, onAcquired).delegateFailure((l, r) -> executorOnDelay.execute(new ActionRunnable<Releasable>(l){

                        @Override
                        public boolean isForceExecution() {
                            return forceExecution;
                        }

                        @Override
                        protected void doRun() {
                            this.listener.onResponse(r);
                        }

                        @Override
                        public void onRejection(Exception e) {
                            IOUtils.closeWhileHandlingException((Closeable)r);
                            super.onRejection(e);
                        }
                    })) : new ContextPreservingActionListener<Releasable>(contextSupplier, onAcquired);
                    this.delayedOperations.add(wrappedListener);
                    return;
                }
                releasable = this.acquire();
            }
        }
        catch (InterruptedException e) {
            onAcquired.onFailure(e);
            return;
        }
        onAcquired.onResponse(releasable);
    }

    private Releasable acquire() throws InterruptedException {
        assert (Thread.holdsLock(this));
        if (this.semaphore.tryAcquire(1, 0L, TimeUnit.SECONDS)) {
            return Releasables.releaseOnce(this.semaphore::release);
        }
        throw new IllegalStateException("failed to obtain permit but operations are not delayed");
    }

    int getActiveOperationsCount() {
        int availablePermits = this.semaphore.availablePermits();
        if (availablePermits == 0) {
            return -1;
        }
        return Integer.MAX_VALUE - availablePermits;
    }

    synchronized boolean isBlocked() {
        return this.queuedBlockOperations > 0;
    }
}

