/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.plain.SortedOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.DocValueFetcher;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.LuceneDocument;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.RoutingPathFields;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.TsidExtractingIdFieldMapper;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.field.DelegateDocValuesField;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;

public class TimeSeriesIdFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_tsid";
    public static final String CONTENT_TYPE = "_tsid";
    public static final TimeSeriesIdFieldType FIELD_TYPE = new TimeSeriesIdFieldType();
    public static final TimeSeriesIdFieldMapper INSTANCE = new TimeSeriesIdFieldMapper();
    private static final Base64.Encoder BASE64_ENCODER = Base64.getUrlEncoder().withoutPadding();
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.FixedTypeParser(c -> c.getIndexSettings().getMode().timeSeriesIdFieldMapper());

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder().init(this);
    }

    private TimeSeriesIdFieldMapper() {
        super(FIELD_TYPE);
    }

    @Override
    public void postParse(DocumentParserContext context) throws IOException {
        BytesRef timeSeriesId;
        assert (!this.fieldType().isIndexed());
        RoutingPathFields routingPathFields = (RoutingPathFields)context.getRoutingFields();
        if (this.getIndexVersionCreated(context).before(IndexVersions.TIME_SERIES_ID_HASHING)) {
            long limit = context.indexSettings().getValue(MapperService.INDEX_MAPPING_DIMENSION_FIELDS_LIMIT_SETTING);
            int size = routingPathFields.routingValues().size();
            if ((long)size > limit) {
                throw new MapperException("Too many dimension fields [" + size + "], max [" + limit + "] dimension fields allowed");
            }
            timeSeriesId = TimeSeriesIdFieldMapper.buildLegacyTsid(routingPathFields).toBytesRef();
        } else {
            timeSeriesId = routingPathFields.buildHash().toBytesRef();
        }
        context.doc().add(new SortedDocValuesField(this.fieldType().name(), timeSeriesId));
        BytesRef uidEncoded = TsidExtractingIdFieldMapper.createField(context, this.getIndexVersionCreated(context).before(IndexVersions.TIME_SERIES_ROUTING_HASH_IN_ID) ? routingPathFields.routingBuilder() : null, timeSeriesId);
        for (LuceneDocument doc : context.nonRootDocuments()) {
            assert (doc.getField("_id") == null);
            doc.add(new StringField("_id", uidEncoded, Field.Store.NO));
        }
    }

    private IndexVersion getIndexVersionCreated(DocumentParserContext context) {
        return context.indexSettings().getIndexVersionCreated();
    }

    @Override
    protected String contentType() {
        return "_tsid";
    }

    public static Object encodeTsid(StreamInput in) {
        try {
            return TimeSeriesIdFieldMapper.base64Encode(in.readSlicedBytesReference().toBytesRef());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read tsid");
        }
    }

    public static Object encodeTsid(BytesRef bytesRef) {
        return TimeSeriesIdFieldMapper.base64Encode(bytesRef);
    }

    private static String base64Encode(BytesRef bytesRef) {
        byte[] bytes = new byte[bytesRef.length];
        System.arraycopy(bytesRef.bytes, bytesRef.offset, bytes, 0, bytesRef.length);
        return BASE64_ENCODER.encodeToString(bytes);
    }

    public static BytesReference buildLegacyTsid(RoutingPathFields routingPathFields) throws IOException {
        SortedMap<BytesRef, List<BytesReference>> routingValues = routingPathFields.routingValues();
        if (routingValues.isEmpty()) {
            throw new IllegalArgumentException("Dimension fields are missing.");
        }
        try (BytesStreamOutput out = new BytesStreamOutput();){
            out.writeVInt(routingValues.size());
            for (Map.Entry<BytesRef, List<BytesReference>> entry : routingValues.entrySet()) {
                out.writeBytesRef(entry.getKey());
                List<BytesReference> value = entry.getValue();
                if (value.size() > 1) {
                    throw new IllegalArgumentException("Dimension field [" + entry.getKey().utf8ToString() + "] cannot be a multi-valued field.");
                }
                assert (!value.isEmpty()) : "dimension value is empty";
                value.get(0).writeTo(out);
            }
            BytesReference bytesReference = out.bytes();
            return bytesReference;
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder {
        protected Builder() {
            super("_tsid");
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return FieldMapper.EMPTY_PARAMETERS;
        }

        @Override
        public TimeSeriesIdFieldMapper build() {
            return INSTANCE;
        }
    }

    public static final class TimeSeriesIdFieldType
    extends MappedFieldType {
        private TimeSeriesIdFieldType() {
            super("_tsid", false, false, true, TextSearchInfo.NONE, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return "_tsid";
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return new DocValueFetcher(this.docValueFormat(format, null), (IndexFieldData<?>)context.getForField(this, MappedFieldType.FielddataOperation.SEARCH));
        }

        @Override
        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return DocValueFormat.TIME_SERIES_ID;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            this.failIfNoDocValues();
            return new SortedOrdinalsIndexFieldData.Builder(this.name(), CoreValuesSourceType.KEYWORD, (dv, n) -> new DelegateDocValuesField(new ScriptDocValues.Strings(new ScriptDocValues.StringsSupplier(FieldData.toString(dv))), n));
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new IllegalArgumentException("[_tsid] is not searchable");
        }
    }
}

