/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingParser;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.script.CompositeFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.xcontent.ToXContentFragment;

public interface RuntimeField
extends ToXContentFragment {
    public String name();

    public Stream<MappedFieldType> asMappedFieldTypes();

    public static Map<String, RuntimeField> parseRuntimeFields(Map<String, Object> node, MappingParserContext parserContext, boolean supportsRemoval) {
        return RuntimeField.parseRuntimeFields(node, parserContext, b -> b.createRuntimeField(parserContext), supportsRemoval);
    }

    public static Map<String, RuntimeField> parseRuntimeFields(Map<String, Object> node, MappingParserContext parserContext, Function<Builder, RuntimeField> builder, boolean supportsRemoval) {
        HashMap<String, RuntimeField> runtimeFields = new HashMap<String, RuntimeField>();
        Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String fieldName = entry.getKey();
            if (entry.getValue() == null) {
                if (supportsRemoval) {
                    runtimeFields.put(fieldName, null);
                    continue;
                }
                throw new MapperParsingException("Runtime field [" + fieldName + "] was set to null but its removal is not supported in this context");
            }
            if (entry.getValue() instanceof Map) {
                HashMap<String, Object> propNode = new HashMap<String, Object>((Map)entry.getValue());
                Object typeNode = propNode.get("type");
                if (typeNode == null) {
                    throw new MapperParsingException("No type specified for runtime field [" + fieldName + "]");
                }
                String type = typeNode.toString();
                Parser typeParser = parserContext.runtimeFieldParser(type);
                if (typeParser == null) {
                    throw new MapperParsingException("The mapper type [" + type + "] declared on runtime field [" + fieldName + "] does not exist. It might have been created within a future version or requires a plugin to be installed. Check the documentation.");
                }
                runtimeFields.put(fieldName, builder.apply(typeParser.parse(fieldName, propNode, parserContext)));
                propNode.remove("type");
                MappingParser.checkNoRemainingFields(fieldName, propNode);
                iterator.remove();
                continue;
            }
            throw new MapperParsingException("Expected map for runtime field [" + fieldName + "] definition but got a " + entry.getValue().getClass().getName());
        }
        return Collections.unmodifiableMap(runtimeFields);
    }

    public static Map<String, MappedFieldType> collectFieldTypes(Collection<RuntimeField> runtimeFields) {
        return runtimeFields.stream().flatMap(runtimeField -> {
            List<String> names = runtimeField.asMappedFieldTypes().map(MappedFieldType::name).filter(name -> !name.equals(runtimeField.name()) && (!name.startsWith(runtimeField.name() + ".") || !(name.length() > runtimeField.name().length() + 1))).toList();
            if (!names.isEmpty()) {
                throw new IllegalStateException("Found sub-fields with name not belonging to the parent field they are part of " + String.valueOf(names));
            }
            return runtimeField.asMappedFieldTypes();
        }).collect(Collectors.toUnmodifiableMap(MappedFieldType::name, mappedFieldType -> mappedFieldType, (t, t2) -> {
            throw new IllegalArgumentException("Found two runtime fields with same name [" + t.name() + "]");
        }));
    }

    public static <T> Function<FieldMapper, T> initializerNotSupported() {
        return mapper -> {
            throw new UnsupportedOperationException();
        };
    }

    public static Script parseScript(String name, MappingParserContext parserContext, Object scriptObject) {
        Script script = Script.parse(scriptObject);
        if (script.getType() == ScriptType.STORED) {
            throw new IllegalArgumentException("stored scripts are not supported for runtime field [" + name + "]");
        }
        return script;
    }

    public static final class Parser {
        private final Function<String, Builder> builderFunction;

        public Parser(Function<String, Builder> builderFunction) {
            this.builderFunction = builderFunction;
        }

        Builder parse(String name, Map<String, Object> node, MappingParserContext parserContext) throws MapperParsingException {
            Builder builder = this.builderFunction.apply(name);
            builder.parse(name, parserContext, node);
            return builder;
        }
    }

    public static abstract class Builder {
        final String name;
        final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();

        protected Builder(String name) {
            this.name = name;
        }

        public Map<String, String> meta() {
            return this.meta.getValue();
        }

        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Collections.singletonList(this.meta);
        }

        protected abstract RuntimeField createRuntimeField(MappingParserContext var1);

        protected abstract RuntimeField createChildRuntimeField(MappingParserContext var1, String var2, Function<SearchLookup, CompositeFieldScript.LeafFactory> var3, OnScriptError var4);

        public final void parse(String name, MappingParserContext parserContext, Map<String, Object> fieldNode) {
            HashMap paramsMap = new HashMap();
            for (FieldMapper.Parameter<?> param : this.getParameters()) {
                paramsMap.put(param.name, param);
            }
            String type = (String)fieldNode.remove("type");
            Iterator<Map.Entry<String, Object>> iterator = fieldNode.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                FieldMapper.Parameter parameter = (FieldMapper.Parameter)paramsMap.get(propName);
                if (parameter == null) {
                    throw new MapperParsingException("unknown parameter [" + propName + "] on runtime field [" + name + "] of type [" + type + "]");
                }
                if (propNode == null && !parameter.canAcceptNull()) {
                    throw new MapperParsingException("[" + propName + "] on runtime field [" + name + "] of type [" + type + "] must not have a [null] value");
                }
                parameter.parse(name, parserContext, propNode);
                iterator.remove();
            }
            for (FieldMapper.Parameter<?> parameter : this.getParameters()) {
                parameter.validate();
            }
        }
    }
}

