/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.AbstractList;
import java.util.Comparator;
import java.util.function.UnaryOperator;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.common.geo.BoundingBox;
import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.geo.SpatialPoint;
import org.elasticsearch.geometry.utils.Geohash;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;

public abstract class ScriptDocValues<T>
extends AbstractList<T> {
    protected final Supplier<T> supplier;

    public ScriptDocValues(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public Supplier<T> getSupplier() {
        return this.supplier;
    }

    @Override
    public final void add(int index, T element) {
        throw new UnsupportedOperationException("doc values are unmodifiable");
    }

    @Override
    public final boolean remove(Object o) {
        throw new UnsupportedOperationException("doc values are unmodifiable");
    }

    @Override
    public final void replaceAll(UnaryOperator<T> operator) {
        throw new UnsupportedOperationException("doc values are unmodifiable");
    }

    @Override
    public final T set(int index, T element) {
        throw new UnsupportedOperationException("doc values are unmodifiable");
    }

    @Override
    public final void sort(Comparator<? super T> c) {
        throw new UnsupportedOperationException("doc values are unmodifiable");
    }

    protected void throwIfEmpty() {
        if (this.size() == 0) {
            throw new IllegalStateException("A document doesn't have a value for a field! Use doc[<field>].size()==0 to check if a document is missing a field!");
        }
    }

    protected void throwIfBeyondLength(int i) {
        if (i >= this.size()) {
            throw new IndexOutOfBoundsException("A document doesn't have a value for a field at position [" + i + "]!");
        }
    }

    public static interface Supplier<T> {
        public void setNextDocId(int var1) throws IOException;

        public T getInternal(int var1);

        public int size();
    }

    public static final class BytesRefs
    extends ScriptDocValues<BytesRef> {
        public BytesRefs(Supplier<BytesRef> supplier) {
            super(supplier);
        }

        public BytesRef getValue() {
            this.throwIfEmpty();
            return this.get(0);
        }

        @Override
        public BytesRef get(int index) {
            this.throwIfEmpty();
            this.throwIfBeyondLength(index);
            return (BytesRef)this.supplier.getInternal(index);
        }

        @Override
        public int size() {
            return this.supplier.size();
        }
    }

    public static class Strings
    extends ScriptDocValues<String> {
        public Strings(Supplier<String> supplier) {
            super(supplier);
        }

        public String getValue() {
            return this.get(0);
        }

        @Override
        public String get(int index) {
            this.throwIfEmpty();
            this.throwIfBeyondLength(index);
            return (String)this.supplier.getInternal(index);
        }

        @Override
        public int size() {
            return this.supplier.size();
        }
    }

    public static class StringsSupplier
    implements Supplier<String> {
        private final SortedBinaryDocValues in;
        private BytesRefBuilder[] values = new BytesRefBuilder[0];
        private int count;

        public StringsSupplier(SortedBinaryDocValues in) {
            this.in = in;
        }

        @Override
        public void setNextDocId(int docId) throws IOException {
            if (this.in.advanceExact(docId)) {
                this.resize(this.in.docValueCount());
                for (int i = 0; i < this.count; ++i) {
                    this.values[i].copyBytes(this.in.nextValue());
                }
            } else {
                this.resize(0);
            }
        }

        private void resize(int newSize) {
            this.count = newSize;
            if (newSize > this.values.length) {
                int oldLength = this.values.length;
                this.values = ArrayUtil.grow(this.values, this.count);
                for (int i = oldLength; i < this.values.length; ++i) {
                    this.values[i] = new BytesRefBuilder();
                }
            }
        }

        protected static String bytesToString(BytesRef bytesRef) {
            return bytesRef.utf8ToString();
        }

        @Override
        public String getInternal(int index) {
            return StringsSupplier.bytesToString(this.values[index].toBytesRef());
        }

        @Override
        public int size() {
            return this.count;
        }
    }

    public static class Booleans
    extends ScriptDocValues<Boolean> {
        public Booleans(Supplier<Boolean> supplier) {
            super(supplier);
        }

        public boolean getValue() {
            this.throwIfEmpty();
            return this.get(0);
        }

        @Override
        public Boolean get(int index) {
            this.throwIfEmpty();
            this.throwIfBeyondLength(index);
            return (Boolean)this.supplier.getInternal(index);
        }

        @Override
        public int size() {
            return this.supplier.size();
        }
    }

    public static class GeoPoints
    extends BaseGeometry<GeoPoint, GeoPoint>
    implements Geometry {
        private final GeometrySupplier<GeoPoint, GeoPoint> geometrySupplier;

        public GeoPoints(GeometrySupplier<GeoPoint, GeoPoint> supplier) {
            super(supplier);
            this.geometrySupplier = supplier;
        }

        public GeoPoint getValue() {
            return this.get(0);
        }

        public double getLat() {
            return this.getValue().lat();
        }

        public double[] getLats() {
            double[] lats = new double[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                lats[i] = this.get(i).lat();
            }
            return lats;
        }

        public double[] getLons() {
            double[] lons = new double[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                lons[i] = this.get(i).lon();
            }
            return lons;
        }

        public double getLon() {
            return this.getValue().lon();
        }

        @Override
        public GeoPoint get(int index) {
            this.throwIfEmpty();
            this.throwIfBeyondLength(index);
            GeoPoint point = (GeoPoint)this.supplier.getInternal(index);
            return new GeoPoint(point.lat(), point.lon());
        }

        @Override
        public int size() {
            return this.supplier.size();
        }

        public double arcDistance(double lat, double lon) {
            GeoPoint point = this.getValue();
            return GeoUtils.arcDistance(point.lat(), point.lon(), lat, lon);
        }

        public double arcDistanceWithDefault(double lat, double lon, double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.arcDistance(lat, lon);
        }

        public double planeDistance(double lat, double lon) {
            GeoPoint point = this.getValue();
            return GeoUtils.planeDistance(point.lat(), point.lon(), lat, lon);
        }

        public double planeDistanceWithDefault(double lat, double lon, double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.planeDistance(lat, lon);
        }

        public double geohashDistance(String geohash) {
            GeoPoint point = this.getValue();
            return GeoUtils.arcDistance(point.lat(), point.lon(), Geohash.decodeLatitude(geohash), Geohash.decodeLongitude(geohash));
        }

        public double geohashDistanceWithDefault(String geohash, double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.geohashDistance(geohash);
        }

        @Override
        public int getDimensionalType() {
            return this.size() == 0 ? -1 : 0;
        }

        @Override
        public GeoPoint getCentroid() {
            return this.size() == 0 ? null : this.geometrySupplier.getInternalCentroid();
        }

        @Override
        public double getMercatorWidth() {
            return 0.0;
        }

        @Override
        public double getMercatorHeight() {
            return 0.0;
        }

        @Override
        public GeoBoundingBox getBoundingBox() {
            return this.size() == 0 ? null : (GeoBoundingBox)this.geometrySupplier.getInternalBoundingBox();
        }

        @Override
        public GeoPoint getLabelPosition() {
            return this.size() == 0 ? null : this.geometrySupplier.getInternalLabelPosition();
        }
    }

    public static interface GeometrySupplier<T extends SpatialPoint, V>
    extends Supplier<V> {
        public T getInternalCentroid();

        public BoundingBox<T> getInternalBoundingBox();

        public T getInternalLabelPosition();
    }

    public static interface Geometry {
        public int getDimensionalType();

        public GeoBoundingBox getBoundingBox();

        public GeoPoint getLabelPosition();

        public GeoPoint getCentroid();

        public int size();

        public double getMercatorWidth();

        public double getMercatorHeight();
    }

    public static abstract class BaseGeometry<T extends SpatialPoint, V>
    extends ScriptDocValues<V> {
        public BaseGeometry(Supplier<V> supplier) {
            super(supplier);
        }

        public abstract int getDimensionalType();

        public abstract BoundingBox<T> getBoundingBox();

        public abstract T getLabelPosition();

        public abstract T getCentroid();
    }

    public static class Doubles
    extends ScriptDocValues<Double> {
        public Doubles(Supplier<Double> supplier) {
            super(supplier);
        }

        public double getValue() {
            return this.get(0);
        }

        @Override
        public Double get(int index) {
            this.throwIfEmpty();
            this.throwIfBeyondLength(index);
            return (Double)this.supplier.getInternal(index);
        }

        @Override
        public int size() {
            return this.supplier.size();
        }
    }

    public static class DoublesSupplier
    implements Supplier<Double> {
        private final SortedNumericDoubleValues in;
        private double[] values = new double[0];
        private int count;

        public DoublesSupplier(SortedNumericDoubleValues in) {
            this.in = in;
        }

        @Override
        public void setNextDocId(int docId) throws IOException {
            if (this.in.advanceExact(docId)) {
                this.resize(this.in.docValueCount());
                for (int i = 0; i < this.count; ++i) {
                    this.values[i] = this.in.nextValue();
                }
            } else {
                this.resize(0);
            }
        }

        private void resize(int newSize) {
            this.count = newSize;
            this.values = ArrayUtil.grow(this.values, this.count);
        }

        @Override
        public Double getInternal(int index) {
            return this.values[index];
        }

        @Override
        public int size() {
            return this.count;
        }
    }

    public static class Dates
    extends ScriptDocValues<ZonedDateTime> {
        public Dates(Supplier<ZonedDateTime> supplier) {
            super(supplier);
        }

        public ZonedDateTime getValue() {
            return this.get(0);
        }

        @Override
        public ZonedDateTime get(int index) {
            this.throwIfEmpty();
            if (index >= this.supplier.size()) {
                throw new IndexOutOfBoundsException("attempted to fetch the [" + index + "] date when there are only [" + this.supplier.size() + "] dates.");
            }
            return (ZonedDateTime)this.supplier.getInternal(index);
        }

        @Override
        public int size() {
            return this.supplier.size();
        }
    }

    public static class Longs
    extends ScriptDocValues<Long> {
        public Longs(Supplier<Long> supplier) {
            super(supplier);
        }

        public long getValue() {
            return this.get(0);
        }

        @Override
        public Long get(int index) {
            this.throwIfEmpty();
            this.throwIfBeyondLength(index);
            return (Long)this.supplier.getInternal(index);
        }

        @Override
        public int size() {
            return this.supplier.size();
        }
    }
}

