/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.health.stats;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.elasticsearch.common.metrics.Counters;
import org.elasticsearch.core.Strings;
import org.elasticsearch.health.Diagnosis;
import org.elasticsearch.health.GetHealthAction;
import org.elasticsearch.health.HealthIndicatorResult;
import org.elasticsearch.health.HealthStatus;

public class HealthApiStats {
    private static final String TOTAL_INVOCATIONS = "invocations.total";
    private static final String VERBOSE_TRUE = "invocations.verbose_true";
    private static final String VERBOSE_FALSE = "invocations.verbose_false";
    private final Function<HealthStatus, String> statusLabel = status -> Strings.format("statuses.%s", status.xContentValue());
    private final BiFunction<HealthStatus, String, String> indicatorLabel = (status, indicator) -> Strings.format("indicators.%s.%s", status.xContentValue(), indicator);
    private final BiFunction<HealthStatus, String, String> diagnosisLabel = (status, diagnosis) -> Strings.format("diagnoses.%s.%s", status.xContentValue(), diagnosis);
    private final Counters stats = new Counters("invocations.total");

    public void track(boolean verbose, GetHealthAction.Response response) {
        HealthStatus status;
        this.stats.inc(TOTAL_INVOCATIONS);
        if (verbose) {
            this.stats.inc(VERBOSE_TRUE);
        } else {
            this.stats.inc(VERBOSE_FALSE);
        }
        HealthStatus healthStatus = status = response.getStatus() != null ? response.getStatus() : (HealthStatus)response.getIndicatorResults().stream().map(HealthIndicatorResult::status).findFirst().orElse(null);
        if (status != null) {
            this.stats.inc(this.statusLabel.apply(status));
        }
        if (status != HealthStatus.GREEN) {
            for (HealthIndicatorResult indicator : response.getIndicatorResults()) {
                if (indicator.status() == HealthStatus.GREEN) continue;
                this.stats.inc(this.indicatorLabel.apply(indicator.status(), indicator.name()));
                if (indicator.diagnosisList() == null) continue;
                for (Diagnosis diagnosis : indicator.diagnosisList()) {
                    this.stats.inc(this.diagnosisLabel.apply(indicator.status(), diagnosis.definition().getUniqueId()));
                }
            }
        }
    }

    public boolean hasCounters() {
        return this.stats.hasCounters();
    }

    public Counters getStats() {
        return this.stats;
    }
}

