/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.FilterComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import org.apache.logging.log4j.core.config.builder.impl.DefaultConfigurationBuilder;
import org.apache.logging.log4j.core.config.composite.CompositeConfiguration;
import org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import org.apache.logging.log4j.core.config.properties.PropertiesConfiguration;
import org.apache.logging.log4j.core.config.properties.PropertiesConfigurationBuilder;
import org.apache.logging.log4j.core.config.properties.PropertiesConfigurationFactory;
import org.apache.logging.log4j.status.StatusConsoleListener;
import org.apache.logging.log4j.status.StatusData;
import org.apache.logging.log4j.status.StatusListener;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Unbox;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.logging.JULBridge;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.logging.LoggingOutputStream;
import org.elasticsearch.common.logging.NodeNamePatternConverter;
import org.elasticsearch.common.logging.internal.LoggerFactoryImpl;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.env.Environment;
import org.elasticsearch.logging.internal.spi.LoggerFactory;
import org.elasticsearch.node.Node;

public class LogConfigurator {
    private static final AtomicBoolean error = new AtomicBoolean();
    private static final StatusListener ERROR_LISTENER = new StatusConsoleListener(Level.ERROR){

        public void log(StatusData data) {
            error.set(true);
            super.log(data);
        }
    };
    private static Appender consoleAppender;

    public static void registerErrorListener() {
        error.set(false);
        StatusLogger.getLogger().registerListener(ERROR_LISTENER);
    }

    public static void configureWithoutConfig(Settings settings) {
        Objects.requireNonNull(settings);
        LogConfigurator.configureESLogging();
        LogConfigurator.configureStatusLogger();
        LogConfigurator.configureLoggerLevels(settings);
    }

    public static void configure(Environment environment, boolean useConsole) throws IOException {
        Objects.requireNonNull(environment);
        try {
            LogConfigurator.checkErrorListener();
        }
        finally {
            StatusLogger.getLogger().removeListener(ERROR_LISTENER);
        }
        LogConfigurator.configureESLogging();
        LogConfigurator.configure(environment.settings(), environment.configDir(), environment.logsDir(), useConsole);
        LogConfigurator.initializeStatics();
        LogConfigurator.configureStatusLoggerForwarder();
    }

    private static void configureStatusLoggerForwarder() {
        final Logger logger = LogManager.getLogger((String)"StatusLogger");
        StatusConsoleListener listener = new StatusConsoleListener(Level.WARN){

            public void log(StatusData data) {
                logger.log(data.getLevel(), data.getMessage(), data.getThrowable());
                super.log(data);
            }
        };
        StatusLogger.getLogger().registerListener((StatusListener)listener);
    }

    public static void configureESLogging() {
        LoggerFactory.setInstance((LoggerFactory)new LoggerFactoryImpl());
    }

    public static void loadLog4jPlugins() {
        PluginManager.addPackage((String)LogConfigurator.class.getPackage().getName());
    }

    public static void setNodeName(String nodeName) {
        NodeNamePatternConverter.setNodeName(nodeName);
    }

    private static void initializeStatics() {
        try {
            MethodHandles.publicLookup().ensureInitialized(Unbox.class);
        }
        catch (IllegalAccessException impossible) {
            throw new AssertionError((Object)impossible);
        }
    }

    private static void checkErrorListener() {
        assert (LogConfigurator.errorListenerIsRegistered()) : "expected error listener to be registered";
        if (error.get()) {
            throw new IllegalStateException("status logger logged an error before logging was configured");
        }
    }

    private static boolean errorListenerIsRegistered() {
        return StreamSupport.stream(StatusLogger.getLogger().getListeners().spliterator(), false).anyMatch(l -> l == ERROR_LISTENER);
    }

    private static void configure(Settings settings, Path configsPath, Path logsPath, boolean useConsole) throws IOException {
        Objects.requireNonNull(settings);
        Objects.requireNonNull(configsPath);
        Objects.requireNonNull(logsPath);
        LogConfigurator.loadLog4jPlugins();
        LogConfigurator.setLogConfigurationSystemProperty(logsPath, settings);
        LogConfigurator.configureStatusLogger();
        final LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        final Set locationsWithDeprecatedPatterns = Collections.synchronizedSet(new HashSet());
        final ArrayList<AbstractConfiguration> configurations = new ArrayList<AbstractConfiguration>();
        final PropertiesConfigurationFactory factory = new PropertiesConfigurationFactory(){

            public PropertiesConfiguration getConfiguration(LoggerContext loggerContext, ConfigurationSource source) {
                Properties properties = new Properties();
                try (InputStream configStream = source.getInputStream();){
                    properties.load(configStream);
                }
                catch (IOException ioe) {
                    throw new ConfigurationException("Unable to load " + source.toString(), (Throwable)ioe);
                }
                for (String name : properties.stringPropertyNames()) {
                    String value;
                    if (!name.endsWith(".pattern") || (value = properties.getProperty(name)) == null || value.contains("%test_thread_info") || !value.contains("%marker") || value.contains("%node_name")) continue;
                    locationsWithDeprecatedPatterns.add(source.getLocation());
                    properties.setProperty(name, value.replace("%marker", "[%node_name]%marker "));
                }
                return new PropertiesConfigurationBuilder().setConfigurationSource(source).setRootProperties(properties).setLoggerContext(loggerContext).build();
            }
        };
        EnumSet<FileVisitOption> options = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        Files.walkFileTree(configsPath, options, Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.getFileName().toString().equals("log4j2.properties")) {
                    configurations.add((PropertiesConfiguration)factory.getConfiguration(context, file.toString(), file.toUri()));
                }
                return FileVisitResult.CONTINUE;
            }
        });
        assert (!configurations.isEmpty());
        configurations.add(LogConfigurator.createStaticConfiguration(context));
        context.start((Configuration)new CompositeConfiguration(configurations));
        LogConfigurator.configureLoggerLevels(settings);
        String deprecatedLocationsString = String.join((CharSequence)"\n  ", locationsWithDeprecatedPatterns);
        if (deprecatedLocationsString.length() > 0) {
            LogManager.getLogger(LogConfigurator.class).warn("Some logging configurations have %marker but don't have %node_name. We will automatically add %node_name to the pattern to ease the migration for users who customize log4j2.properties but will stop this behavior in 7.0. You should manually replace `%node_name` with `[%node_name]%marker ` in these locations:\n  {}", (Object)deprecatedLocationsString);
        }
        JULBridge.install();
        System.setOut(new PrintStream((OutputStream)new LoggingOutputStream(LogManager.getLogger((String)"stdout"), Level.INFO), false, StandardCharsets.UTF_8));
        System.setErr(new PrintStream((OutputStream)new LoggingOutputStream(LogManager.getLogger((String)"stderr"), Level.WARN), false, StandardCharsets.UTF_8));
        Logger rootLogger = LogManager.getRootLogger();
        Appender appender = Loggers.findAppender(rootLogger, ConsoleAppender.class);
        if (appender != null) {
            if (useConsole) {
                consoleAppender = appender;
            } else {
                Loggers.removeAppender(rootLogger, appender);
            }
        }
    }

    private static AbstractConfiguration createStaticConfiguration(LoggerContext context) {
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        builder.setConfigurationSource(ConfigurationSource.NULL_SOURCE);
        builder.setLoggerContext(context);
        LogConfigurator.addRegexFilter((DefaultConfigurationBuilder<BuiltConfiguration>)builder, "org.apache.lucene.store.MemorySegmentIndexInputProvider", "Using MemorySegmentIndexInput.*");
        LogConfigurator.addRegexFilter((DefaultConfigurationBuilder<BuiltConfiguration>)builder, "org.apache.lucene.util.VectorUtilProvider", ".* incubator module is not readable.*");
        return builder.build();
    }

    private static void addRegexFilter(DefaultConfigurationBuilder<BuiltConfiguration> builder, String loggerName, String pattern) {
        FilterComponentBuilder filterBuilder = builder.newFilter("RegexFilter", Filter.Result.DENY, Filter.Result.NEUTRAL);
        filterBuilder.addAttribute("regex", pattern);
        LoggerComponentBuilder loggerBuilder = builder.newLogger(loggerName);
        loggerBuilder.add(filterBuilder);
        builder.add(loggerBuilder);
    }

    public static Appender removeConsoleAppender() {
        Appender appender = consoleAppender;
        if (appender != null) {
            Loggers.removeAppender(LogManager.getRootLogger(), appender);
            consoleAppender = null;
        }
        return appender;
    }

    private static void configureStatusLogger() {
        ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        builder.setStatusLevel(Level.ERROR);
        Configurator.initialize((Configuration)((Configuration)builder.build()));
    }

    private static void configureLoggerLevels(Settings settings) {
        if (Loggers.LOG_DEFAULT_LEVEL_SETTING.exists(settings)) {
            Level level = Loggers.LOG_DEFAULT_LEVEL_SETTING.get(settings);
            Loggers.setLevel(LogManager.getRootLogger(), level);
        }
        Loggers.LOG_LEVEL_SETTING.getAllConcreteSettings(settings).filter(s -> !s.getKey().equals(Loggers.LOG_DEFAULT_LEVEL_SETTING.getKey())).forEach(s -> {
            Level level = (Level)s.get(settings);
            Loggers.setLevel(LogManager.getLogger((String)s.getKey().substring("logger.".length())), level);
        });
    }

    @SuppressForbidden(reason="sets system property for logging configuration")
    private static void setLogConfigurationSystemProperty(Path logsPath, Settings settings) {
        System.setProperty("es.logs.base_path", logsPath.toString());
        System.setProperty("es.logs.cluster_name", ClusterName.CLUSTER_NAME_SETTING.get(settings).value());
        System.setProperty("es.logs.node_name", Node.NODE_NAME_SETTING.get(settings));
    }
}

