/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentEOFException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public final class BulkRequestParser {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(BulkRequestParser.class);
    private static final Set<String> SUPPORTED_ACTIONS = Set.of("create", "index", "update", "delete");
    private static final String STRICT_ACTION_PARSING_WARNING_KEY = "bulk_request_strict_action_parsing";
    private static final ParseField INDEX = new ParseField("_index", new String[0]);
    private static final ParseField TYPE = new ParseField("_type", new String[0]);
    private static final ParseField ID = new ParseField("_id", new String[0]);
    private static final ParseField ROUTING = new ParseField("routing", new String[0]);
    private static final ParseField OP_TYPE = new ParseField("op_type", new String[0]);
    private static final ParseField VERSION = new ParseField("version", new String[0]);
    private static final ParseField VERSION_TYPE = new ParseField("version_type", new String[0]);
    private static final ParseField RETRY_ON_CONFLICT = new ParseField("retry_on_conflict", new String[0]);
    private static final ParseField PIPELINE = new ParseField("pipeline", new String[0]);
    private static final ParseField SOURCE = new ParseField("_source", new String[0]);
    private static final ParseField IF_SEQ_NO = new ParseField("if_seq_no", new String[0]);
    private static final ParseField IF_PRIMARY_TERM = new ParseField("if_primary_term", new String[0]);
    private static final ParseField REQUIRE_ALIAS = new ParseField("require_alias", new String[0]);
    private static final ParseField REQUIRE_DATA_STREAM = new ParseField("require_data_stream", new String[0]);
    private static final ParseField LIST_EXECUTED_PIPELINES = new ParseField("list_executed_pipelines", new String[0]);
    private static final ParseField DYNAMIC_TEMPLATES = new ParseField("dynamic_templates", new String[0]);
    private final boolean deprecateOrErrorOnType;
    private final XContentParserConfiguration config;

    public BulkRequestParser(boolean deprecateOrErrorOnType, boolean includeSourceOnError, RestApiVersion restApiVersion) {
        this.deprecateOrErrorOnType = deprecateOrErrorOnType;
        this.config = XContentParserConfiguration.EMPTY.withDeprecationHandler(LoggingDeprecationHandler.INSTANCE).withRestApiVersion(restApiVersion).withIncludeSourceOnError(includeSourceOnError);
    }

    private static int findNextMarker(byte marker, int from, BytesReference data, boolean lastData) {
        int res = data.indexOf(marker, from);
        if (res != -1) {
            assert (res >= 0);
            return res;
        }
        if (from != data.length() && lastData) {
            throw new IllegalArgumentException("The bulk request must be terminated by a newline [\\n]");
        }
        return res;
    }

    private static BytesReference sliceTrimmingCarriageReturn(BytesReference bytesReference, int from, int nextMarker, XContentType xContentType) {
        int length = XContentType.JSON == xContentType && bytesReference.get(nextMarker - 1) == 13 ? nextMarker - from - 1 : nextMarker - from;
        return bytesReference.slice(from, length);
    }

    public void parse(BytesReference data, @Nullable String defaultIndex, @Nullable String defaultRouting, @Nullable FetchSourceContext defaultFetchSourceContext, @Nullable String defaultPipeline, @Nullable Boolean defaultRequireAlias, @Nullable Boolean defaultRequireDataStream, @Nullable Boolean defaultListExecutedPipelines, boolean allowExplicitIndex, XContentType xContentType, BiConsumer<IndexRequest, String> indexRequestConsumer, Consumer<UpdateRequest> updateRequestConsumer, Consumer<DeleteRequest> deleteRequestConsumer) throws IOException {
        IncrementalParser incrementalParser = new IncrementalParser(defaultIndex, defaultRouting, defaultFetchSourceContext, defaultPipeline, defaultRequireAlias, defaultRequireDataStream, defaultListExecutedPipelines, allowExplicitIndex, xContentType, indexRequestConsumer, updateRequestConsumer, deleteRequestConsumer);
        incrementalParser.parse(data, true);
    }

    public IncrementalParser incrementalParser(@Nullable String defaultIndex, @Nullable String defaultRouting, @Nullable FetchSourceContext defaultFetchSourceContext, @Nullable String defaultPipeline, @Nullable Boolean defaultRequireAlias, @Nullable Boolean defaultRequireDataStream, @Nullable Boolean defaultListExecutedPipelines, boolean allowExplicitIndex, XContentType xContentType, BiConsumer<IndexRequest, String> indexRequestConsumer, Consumer<UpdateRequest> updateRequestConsumer, Consumer<DeleteRequest> deleteRequestConsumer) {
        return new IncrementalParser(defaultIndex, defaultRouting, defaultFetchSourceContext, defaultPipeline, defaultRequireAlias, defaultRequireDataStream, defaultListExecutedPipelines, allowExplicitIndex, xContentType, indexRequestConsumer, updateRequestConsumer, deleteRequestConsumer);
    }

    private static void warnBulkActionNotProperlyClosed(String message) {
        deprecationLogger.compatibleCritical(STRICT_ACTION_PARSING_WARNING_KEY, message, new Object[0]);
    }

    private static void checkBulkActionIsProperlyClosed(XContentParser parser) throws IOException {
        XContentParser.Token token;
        try {
            token = parser.nextToken();
        }
        catch (XContentEOFException ignore) {
            BulkRequestParser.warnBulkActionNotProperlyClosed("A bulk action wasn't closed properly with the closing brace. Malformed objects are currently accepted but will be rejected in a future version.");
            return;
        }
        if (token != XContentParser.Token.END_OBJECT) {
            BulkRequestParser.warnBulkActionNotProperlyClosed("A bulk action object contained multiple keys. Additional keys are currently ignored but will be rejected in a future version.");
            return;
        }
        if (parser.nextToken() != null) {
            BulkRequestParser.warnBulkActionNotProperlyClosed("A bulk action contained trailing data after the closing brace. This is currently ignored but will be rejected in a future version.");
        }
    }

    private XContentParser createParser(XContent xContent, BytesReference data) throws IOException {
        if (data.hasArray()) {
            return this.parseBytesArray(xContent, data, 0, data.length());
        }
        return xContent.createParser(this.config, data.streamInput());
    }

    private XContentParser createParser(XContent xContent, BytesReference data, int from, int nextMarker) throws IOException {
        if (data.hasArray()) {
            return this.parseBytesArray(xContent, data, from, nextMarker);
        }
        int length = nextMarker - from;
        BytesReference slice = data.slice(from, length);
        if (slice.hasArray()) {
            return this.parseBytesArray(xContent, slice, 0, length);
        }
        return xContent.createParser(this.config, slice.streamInput());
    }

    private XContentParser parseBytesArray(XContent xContent, BytesReference array, int from, int nextMarker) throws IOException {
        assert (array.hasArray());
        int offset = array.arrayOffset();
        return xContent.createParser(this.config, array.array(), offset + from, nextMarker - from);
    }

    public class IncrementalParser {
        private final Map<String, String> stringDeduplicator = new HashMap<String, String>();
        private final String defaultIndex;
        private final String defaultRouting;
        private final FetchSourceContext defaultFetchSourceContext;
        private final String defaultPipeline;
        private final Boolean defaultRequireAlias;
        private final Boolean defaultRequireDataStream;
        private final Boolean defaultListExecutedPipelines;
        private final boolean allowExplicitIndex;
        private final XContentType xContentType;
        private final byte marker;
        private final BiConsumer<IndexRequest, String> indexRequestConsumer;
        private final Consumer<UpdateRequest> updateRequestConsumer;
        private final Consumer<DeleteRequest> deleteRequestConsumer;
        private Exception failure = null;
        private int incrementalFromOffset = 0;
        private int line = 0;
        boolean typesDeprecationLogged = false;
        private DocWriteRequest<?> currentRequest = null;
        private String currentType = null;
        private String currentPipeline = null;
        private boolean currentListExecutedPipelines = false;
        private FetchSourceContext currentFetchSourceContext = null;

        private IncrementalParser(@Nullable String defaultIndex, @Nullable String defaultRouting, @Nullable FetchSourceContext defaultFetchSourceContext, @Nullable String defaultPipeline, @Nullable Boolean defaultRequireAlias, @Nullable Boolean defaultRequireDataStream, Boolean defaultListExecutedPipelines, boolean allowExplicitIndex, XContentType xContentType, BiConsumer<IndexRequest, String> indexRequestConsumer, Consumer<UpdateRequest> updateRequestConsumer, Consumer<DeleteRequest> deleteRequestConsumer) {
            this.defaultIndex = defaultIndex;
            this.defaultRouting = defaultRouting;
            this.defaultFetchSourceContext = defaultFetchSourceContext;
            this.defaultPipeline = defaultPipeline;
            this.defaultRequireAlias = defaultRequireAlias;
            this.defaultRequireDataStream = defaultRequireDataStream;
            this.defaultListExecutedPipelines = defaultListExecutedPipelines;
            this.allowExplicitIndex = allowExplicitIndex;
            this.xContentType = xContentType;
            this.marker = xContentType.xContent().bulkSeparator();
            this.indexRequestConsumer = indexRequestConsumer;
            this.updateRequestConsumer = updateRequestConsumer;
            this.deleteRequestConsumer = deleteRequestConsumer;
        }

        public int parse(BytesReference data, boolean lastData) throws IOException {
            if (this.failure != null) {
                assert (false) : this.failure.getMessage();
                throw new IllegalStateException("Parser has already encountered exception", this.failure);
            }
            try {
                return this.tryParse(data, lastData);
            }
            catch (Exception e) {
                this.failure = e;
                throw e;
            }
        }

        private int tryParse(BytesReference data, boolean lastData) throws IOException {
            int from = 0;
            int consumed = 0;
            while (true) {
                int nextMarker;
                if ((nextMarker = BulkRequestParser.findNextMarker(this.marker, this.incrementalFromOffset, data, lastData)) == -1) break;
                this.incrementalFromOffset = nextMarker + 1;
                ++this.line;
                if (this.currentRequest == null) {
                    DocWriteRequest<?> docWriteRequest;
                    if (this.parseActionLine(data, from, nextMarker) && (docWriteRequest = this.currentRequest) instanceof DeleteRequest) {
                        DeleteRequest deleteRequest = (DeleteRequest)docWriteRequest;
                        this.deleteRequestConsumer.accept(deleteRequest);
                        this.currentRequest = null;
                    }
                } else {
                    this.parseAndConsumeDocumentLine(data, from, nextMarker);
                    this.currentRequest = null;
                }
                consumed = from = nextMarker + 1;
            }
            this.incrementalFromOffset = data.length() - consumed;
            return lastData ? from : consumed;
        }

        private boolean parseActionLine(BytesReference data, int from, int to) throws IOException {
            assert (this.currentRequest == null);
            this.currentType = null;
            this.currentPipeline = this.defaultPipeline;
            this.currentListExecutedPipelines = this.defaultListExecutedPipelines != null && this.defaultListExecutedPipelines != false;
            this.currentFetchSourceContext = this.defaultFetchSourceContext;
            try (XContentParser parser = BulkRequestParser.this.createParser(this.xContentType.xContent(), data, from, to);){
                XContentParser.Token token = parser.nextToken();
                if (token == null) {
                    boolean bl = false;
                    return bl;
                }
                if (token != XContentParser.Token.START_OBJECT) {
                    throw new IllegalArgumentException("Malformed action/metadata line [" + this.line + "], expected " + String.valueOf((Object)XContentParser.Token.START_OBJECT) + " but found [" + String.valueOf((Object)token) + "]");
                }
                token = parser.nextToken();
                if (token != XContentParser.Token.FIELD_NAME) {
                    throw new IllegalArgumentException("Malformed action/metadata line [" + this.line + "], expected " + String.valueOf((Object)XContentParser.Token.FIELD_NAME) + " but found [" + String.valueOf((Object)token) + "]");
                }
                String action = parser.currentName();
                if (!SUPPORTED_ACTIONS.contains(action)) {
                    throw new IllegalArgumentException("Malformed action/metadata line [" + this.line + "], expected field [create], [delete], [index] or [update] but found [" + action + "]");
                }
                String index = this.defaultIndex;
                String id = null;
                String routing = this.defaultRouting;
                String opType = null;
                long version = -3L;
                VersionType versionType = VersionType.INTERNAL;
                long ifSeqNo = -2L;
                long ifPrimaryTerm = 0L;
                int retryOnConflict = 0;
                boolean requireAlias = this.defaultRequireAlias != null && this.defaultRequireAlias != false;
                boolean requireDataStream = this.defaultRequireDataStream != null && this.defaultRequireDataStream != false;
                Map<Object, Object> dynamicTemplates = Map.of();
                token = parser.nextToken();
                if (token == XContentParser.Token.START_OBJECT) {
                    String currentFieldName = null;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token.isValue()) {
                            if (INDEX.match(currentFieldName, parser.getDeprecationHandler())) {
                                if (!this.allowExplicitIndex) {
                                    throw new IllegalArgumentException("explicit index in bulk is not allowed");
                                }
                                index = this.stringDeduplicator.computeIfAbsent(parser.text(), Function.identity());
                                continue;
                            }
                            if (TYPE.match(currentFieldName, parser.getDeprecationHandler())) {
                                if (parser.getRestApiVersion().matches(RestApiVersion.equalTo(RestApiVersion.V_7))) {
                                    if (BulkRequestParser.this.deprecateOrErrorOnType && !this.typesDeprecationLogged) {
                                        deprecationLogger.compatibleCritical("bulk_with_types", "[types removal] Specifying types in bulk requests is deprecated.", new Object[0]);
                                        this.typesDeprecationLogged = true;
                                    }
                                } else if (parser.getRestApiVersion().matches(RestApiVersion.onOrAfter(RestApiVersion.V_8)) && BulkRequestParser.this.deprecateOrErrorOnType) {
                                    throw new IllegalArgumentException("Action/metadata line [" + this.line + "] contains an unknown parameter [" + currentFieldName + "]");
                                }
                                this.currentType = this.stringDeduplicator.computeIfAbsent(parser.text(), Function.identity());
                                continue;
                            }
                            if (ID.match(currentFieldName, parser.getDeprecationHandler())) {
                                id = parser.text();
                                continue;
                            }
                            if (ROUTING.match(currentFieldName, parser.getDeprecationHandler())) {
                                routing = this.stringDeduplicator.computeIfAbsent(parser.text(), Function.identity());
                                continue;
                            }
                            if (OP_TYPE.match(currentFieldName, parser.getDeprecationHandler())) {
                                opType = parser.text();
                                continue;
                            }
                            if (VERSION.match(currentFieldName, parser.getDeprecationHandler())) {
                                version = parser.longValue();
                                continue;
                            }
                            if (VERSION_TYPE.match(currentFieldName, parser.getDeprecationHandler())) {
                                versionType = VersionType.fromString(parser.text());
                                continue;
                            }
                            if (IF_SEQ_NO.match(currentFieldName, parser.getDeprecationHandler())) {
                                ifSeqNo = parser.longValue();
                                continue;
                            }
                            if (IF_PRIMARY_TERM.match(currentFieldName, parser.getDeprecationHandler())) {
                                ifPrimaryTerm = parser.longValue();
                                continue;
                            }
                            if (RETRY_ON_CONFLICT.match(currentFieldName, parser.getDeprecationHandler())) {
                                retryOnConflict = parser.intValue();
                                continue;
                            }
                            if (PIPELINE.match(currentFieldName, parser.getDeprecationHandler())) {
                                this.currentPipeline = this.stringDeduplicator.computeIfAbsent(parser.text(), Function.identity());
                                continue;
                            }
                            if (SOURCE.match(currentFieldName, parser.getDeprecationHandler())) {
                                this.currentFetchSourceContext = FetchSourceContext.fromXContent(parser);
                                continue;
                            }
                            if (REQUIRE_ALIAS.match(currentFieldName, parser.getDeprecationHandler())) {
                                requireAlias = parser.booleanValue();
                                continue;
                            }
                            if (REQUIRE_DATA_STREAM.match(currentFieldName, parser.getDeprecationHandler())) {
                                requireDataStream = parser.booleanValue();
                                continue;
                            }
                            if (LIST_EXECUTED_PIPELINES.match(currentFieldName, parser.getDeprecationHandler())) {
                                this.currentListExecutedPipelines = parser.booleanValue();
                                continue;
                            }
                            throw new IllegalArgumentException("Action/metadata line [" + this.line + "] contains an unknown parameter [" + currentFieldName + "]");
                        }
                        if (token == XContentParser.Token.START_ARRAY) {
                            throw new IllegalArgumentException("Malformed action/metadata line [" + this.line + "], expected a simple value for field [" + currentFieldName + "] but found [" + String.valueOf((Object)token) + "]");
                        }
                        if (token == XContentParser.Token.START_OBJECT && DYNAMIC_TEMPLATES.match(currentFieldName, parser.getDeprecationHandler())) {
                            dynamicTemplates = parser.mapStrings();
                            continue;
                        }
                        if (token == XContentParser.Token.START_OBJECT && SOURCE.match(currentFieldName, parser.getDeprecationHandler())) {
                            this.currentFetchSourceContext = FetchSourceContext.fromXContent(parser);
                            continue;
                        }
                        if (token == XContentParser.Token.VALUE_NULL) continue;
                        throw new IllegalArgumentException("Malformed action/metadata line [" + this.line + "], expected a simple value for field [" + currentFieldName + "] but found [" + String.valueOf((Object)token) + "]");
                    }
                } else if (token != XContentParser.Token.END_OBJECT) {
                    throw new IllegalArgumentException("Malformed action/metadata line [" + this.line + "], expected " + String.valueOf((Object)XContentParser.Token.START_OBJECT) + " or " + String.valueOf((Object)XContentParser.Token.END_OBJECT) + " but found [" + String.valueOf((Object)token) + "]");
                }
                BulkRequestParser.checkBulkActionIsProperlyClosed(parser);
                if ("delete".equals(action)) {
                    if (!dynamicTemplates.isEmpty()) {
                        throw new IllegalArgumentException("Delete request in line [" + this.line + "] does not accept " + DYNAMIC_TEMPLATES.getPreferredName());
                    }
                    this.currentRequest = new DeleteRequest(index).id(id).routing(routing).version(version).versionType(versionType).setIfSeqNo(ifSeqNo).setIfPrimaryTerm(ifPrimaryTerm);
                } else if ("index".equals(action) || "create".equals(action)) {
                    IndexRequest indexRequest = new IndexRequest(index).id(id).routing(routing).version(version).versionType(versionType).setPipeline(this.currentPipeline).setIfSeqNo(ifSeqNo).setIfPrimaryTerm(ifPrimaryTerm).setDynamicTemplates(dynamicTemplates).setRequireAlias(requireAlias).setRequireDataStream(requireDataStream).setListExecutedPipelines(this.currentListExecutedPipelines).setIncludeSourceOnError(BulkRequestParser.this.config.includeSourceOnError());
                    if ("create".equals(action)) {
                        indexRequest = indexRequest.create(true);
                    } else if (opType != null) {
                        indexRequest = indexRequest.create("create".equals(opType));
                    }
                    this.currentRequest = indexRequest;
                } else if ("update".equals(action)) {
                    UpdateRequest updateRequest;
                    if (version != -3L || versionType != VersionType.INTERNAL) {
                        throw new IllegalArgumentException("Update requests do not support versioning. Please use `if_seq_no` and `if_primary_term` instead");
                    }
                    if (requireDataStream) {
                        throw new IllegalArgumentException("Update requests do not support the `require_data_stream` flag, as data streams do not support update operations");
                    }
                    if (!dynamicTemplates.isEmpty()) {
                        throw new IllegalArgumentException("Update request in line [" + this.line + "] does not accept " + DYNAMIC_TEMPLATES.getPreferredName());
                    }
                    this.currentRequest = updateRequest = ((UpdateRequest)new UpdateRequest().index(index)).id(id).routing(routing).retryOnConflict(retryOnConflict).setIfSeqNo(ifSeqNo).setIfPrimaryTerm(ifPrimaryTerm).setRequireAlias(requireAlias).routing(routing);
                }
            }
            return true;
        }

        private void parseAndConsumeDocumentLine(BytesReference data, int from, int to) throws IOException {
            assert (this.currentRequest != null && !(this.currentRequest instanceof DeleteRequest));
            DocWriteRequest<?> docWriteRequest = this.currentRequest;
            if (docWriteRequest instanceof IndexRequest) {
                IndexRequest indexRequest = (IndexRequest)docWriteRequest;
                indexRequest.source(BulkRequestParser.sliceTrimmingCarriageReturn(data, from, to, this.xContentType), this.xContentType);
                this.indexRequestConsumer.accept(indexRequest, this.currentType);
            } else {
                docWriteRequest = this.currentRequest;
                if (docWriteRequest instanceof UpdateRequest) {
                    IndexRequest upsertRequest;
                    UpdateRequest updateRequest = (UpdateRequest)docWriteRequest;
                    try (XContentParser sliceParser = BulkRequestParser.this.createParser(this.xContentType.xContent(), BulkRequestParser.sliceTrimmingCarriageReturn(data, from, to, this.xContentType));){
                        updateRequest.fromXContent(sliceParser);
                    }
                    if (this.currentFetchSourceContext != null) {
                        updateRequest.fetchSource(this.currentFetchSourceContext);
                    }
                    if ((upsertRequest = updateRequest.upsertRequest()) != null) {
                        upsertRequest.setPipeline(this.currentPipeline).setListExecutedPipelines(this.currentListExecutedPipelines);
                    }
                    this.updateRequestConsumer.accept(updateRequest);
                }
            }
        }
    }
}

