/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.PluginsAndModules;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsNodeResponse;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.index.stats.IndexingPressureStats;
import org.elasticsearch.ingest.IngestStats;
import org.elasticsearch.monitor.fs.FsInfo;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.monitor.os.OsInfo;
import org.elasticsearch.monitor.os.OsStats;
import org.elasticsearch.plugins.PluginRuntimeInfo;
import org.elasticsearch.transport.TransportInfo;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class ClusterStatsNodes
implements ToXContentFragment {
    private final Counts counts;
    private final Set<String> versions = new HashSet<String>();
    private final OsStats os;
    private final ProcessStats process;
    private final JvmStats jvm;
    private final FsInfo.Path fs;
    private final Set<PluginRuntimeInfo> plugins = new HashSet<PluginRuntimeInfo>();
    private final NetworkTypes networkTypes;
    private final DiscoveryTypes discoveryTypes;
    private final PackagingTypes packagingTypes;
    private final IngestStats ingestStats;
    private final IndexPressureStats indexPressureStats;

    ClusterStatsNodes(List<ClusterStatsNodeResponse> nodeResponses) {
        ClusterFsStatsDeduplicator deduplicator = new ClusterFsStatsDeduplicator(nodeResponses.size());
        ArrayList<NodeInfo> nodeInfos = new ArrayList<NodeInfo>(nodeResponses.size());
        ArrayList<NodeStats> nodeStats = new ArrayList<NodeStats>(nodeResponses.size());
        for (ClusterStatsNodeResponse nodeResponse : nodeResponses) {
            nodeInfos.add(nodeResponse.nodeInfo());
            nodeStats.add(nodeResponse.nodeStats());
            this.versions.add(nodeResponse.nodeInfo().getVersion());
            this.plugins.addAll(nodeResponse.nodeInfo().getInfo(PluginsAndModules.class).getPluginInfos());
            TransportAddress publishAddress = nodeResponse.nodeInfo().getInfo(TransportInfo.class).address().publishAddress();
            InetAddress inetAddress = publishAddress.address().getAddress();
            deduplicator.add(inetAddress, nodeResponse.nodeStats().getFs());
        }
        this.fs = deduplicator.getTotal();
        this.counts = new Counts(nodeInfos);
        this.os = new OsStats(nodeInfos, nodeStats);
        this.process = new ProcessStats(nodeStats);
        this.jvm = new JvmStats(nodeInfos, nodeStats);
        this.networkTypes = new NetworkTypes(nodeInfos);
        this.discoveryTypes = new DiscoveryTypes(nodeInfos);
        this.packagingTypes = new PackagingTypes(nodeInfos);
        this.ingestStats = new IngestStats(nodeStats);
        this.indexPressureStats = new IndexPressureStats(nodeStats);
    }

    public Counts getCounts() {
        return this.counts;
    }

    public Set<String> getVersions() {
        return this.versions;
    }

    public OsStats getOs() {
        return this.os;
    }

    public ProcessStats getProcess() {
        return this.process;
    }

    public JvmStats getJvm() {
        return this.jvm;
    }

    public FsInfo.Path getFs() {
        return this.fs;
    }

    public Set<PluginRuntimeInfo> getPlugins() {
        return this.plugins;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("count");
        this.counts.toXContent(builder, params);
        builder.endObject();
        builder.startArray("versions");
        for (String v : this.versions) {
            builder.value(v);
        }
        builder.endArray();
        builder.startObject("os");
        this.os.toXContent(builder, params);
        builder.endObject();
        builder.startObject("process");
        this.process.toXContent(builder, params);
        builder.endObject();
        builder.startObject("jvm");
        this.jvm.toXContent(builder, params);
        builder.endObject();
        builder.field("fs");
        this.fs.toXContent(builder, params);
        builder.startArray("plugins");
        for (PluginRuntimeInfo pluginInfo : this.plugins) {
            pluginInfo.toXContent(builder, params);
        }
        builder.endArray();
        builder.startObject("network_types");
        this.networkTypes.toXContent(builder, params);
        builder.endObject();
        this.discoveryTypes.toXContent(builder, params);
        this.packagingTypes.toXContent(builder, params);
        this.ingestStats.toXContent(builder, params);
        this.indexPressureStats.toXContent(builder, params);
        return builder;
    }

    static class ClusterFsStatsDeduplicator {
        private final Set<DedupEntry> seenAddressesMountsPaths;
        private final FsInfo.Path total = new FsInfo.Path();

        ClusterFsStatsDeduplicator(int expectedSize) {
            this.seenAddressesMountsPaths = Sets.newHashSetWithExpectedSize(2 * expectedSize);
        }

        public void add(InetAddress inetAddress, FsInfo fsInfo) {
            if (fsInfo != null) {
                for (FsInfo.Path p : fsInfo) {
                    boolean seenAddressMountPath;
                    String mount = p.getMount();
                    String path = p.getPath();
                    boolean seenAddressMount = !this.seenAddressesMountsPaths.add(new DedupEntry(inetAddress, mount, null));
                    boolean bl = seenAddressMountPath = !this.seenAddressesMountsPaths.add(new DedupEntry(inetAddress, mount, path));
                    if (seenAddressMount && !seenAddressMountPath) continue;
                    this.total.add(p);
                }
            }
        }

        public FsInfo.Path getTotal() {
            FsInfo.Path result = new FsInfo.Path();
            result.add(this.total);
            return result;
        }

        private record DedupEntry(InetAddress inetAddress, String mount, String path) {
        }
    }

    public static class Counts
    implements ToXContentFragment {
        static final String COORDINATING_ONLY = "coordinating_only";
        private final int total;
        private final Map<String, Integer> roles;

        private Counts(List<NodeInfo> nodeInfos) {
            Map<String, Integer> roles = Maps.newMapWithExpectedSize(DiscoveryNodeRole.roles().size() + 1);
            roles.put(COORDINATING_ONLY, 0);
            for (DiscoveryNodeRole role : DiscoveryNodeRole.roles()) {
                roles.put(role.roleName(), 0);
            }
            int total = 0;
            for (NodeInfo nodeInfo : nodeInfos) {
                ++total;
                if (nodeInfo.getNode().getRoles().isEmpty()) {
                    roles.merge(COORDINATING_ONLY, 1, Integer::sum);
                    continue;
                }
                for (DiscoveryNodeRole role : nodeInfo.getNode().getRoles()) {
                    roles.merge(role.roleName(), 1, Integer::sum);
                }
            }
            this.total = total;
            this.roles = Map.copyOf(roles);
        }

        public int getTotal() {
            return this.total;
        }

        public Map<String, Integer> getRoles() {
            return this.roles;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("total", this.total);
            for (Map.Entry<String, Integer> entry : new TreeMap<String, Integer>(this.roles).entrySet()) {
                builder.field(entry.getKey(), entry.getValue());
            }
            return builder;
        }

        static final class Fields {
            static final String TOTAL = "total";

            Fields() {
            }
        }
    }

    public static class OsStats
    implements ToXContentFragment {
        final int availableProcessors;
        final int allocatedProcessors;
        final Map<String, Integer> names = new HashMap<String, Integer>();
        final Map<String, Integer> prettyNames = new HashMap<String, Integer>();
        final Map<String, Integer> architectures = new HashMap<String, Integer>();
        final OsStats.Mem mem;

        private OsStats(List<NodeInfo> nodeInfos, List<NodeStats> nodeStatsList) {
            int availableProcessors = 0;
            int allocatedProcessors = 0;
            for (NodeInfo nodeInfo : nodeInfos) {
                availableProcessors += nodeInfo.getInfo(OsInfo.class).getAvailableProcessors();
                allocatedProcessors += nodeInfo.getInfo(OsInfo.class).getAllocatedProcessors();
                if (nodeInfo.getInfo(OsInfo.class).getName() != null) {
                    this.names.merge(nodeInfo.getInfo(OsInfo.class).getName(), 1, Integer::sum);
                }
                if (nodeInfo.getInfo(OsInfo.class).getPrettyName() != null) {
                    this.prettyNames.merge(nodeInfo.getInfo(OsInfo.class).getPrettyName(), 1, Integer::sum);
                }
                if (nodeInfo.getInfo(OsInfo.class).getArch() == null) continue;
                this.architectures.merge(nodeInfo.getInfo(OsInfo.class).getArch(), 1, Integer::sum);
            }
            this.availableProcessors = availableProcessors;
            this.allocatedProcessors = allocatedProcessors;
            long totalMemory = 0L;
            long adjustedTotalMemory = 0L;
            long freeMemory = 0L;
            for (NodeStats nodeStats : nodeStatsList) {
                long free;
                long adjustedTotal;
                if (nodeStats.getOs() == null) continue;
                OsStats.Mem mem = nodeStats.getOs().getMem();
                long total = mem.getTotal().getBytes();
                if (total > 0L) {
                    totalMemory += total;
                }
                if ((adjustedTotal = mem.getAdjustedTotal().getBytes()) > 0L) {
                    adjustedTotalMemory += adjustedTotal;
                }
                if ((free = mem.getFree().getBytes()) <= 0L) continue;
                freeMemory += free;
            }
            this.mem = new OsStats.Mem(totalMemory, adjustedTotalMemory, freeMemory);
        }

        public int getAvailableProcessors() {
            return this.availableProcessors;
        }

        public int getAllocatedProcessors() {
            return this.allocatedProcessors;
        }

        public OsStats.Mem getMem() {
            return this.mem;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("available_processors", this.availableProcessors);
            builder.field("allocated_processors", this.allocatedProcessors);
            builder.startArray("names");
            for (Map.Entry<String, Integer> name : this.names.entrySet()) {
                builder.startObject();
                builder.field("name", name.getKey());
                builder.field("count", name.getValue());
                builder.endObject();
            }
            builder.endArray();
            builder.startArray("pretty_names");
            for (Map.Entry<String, Integer> prettyName : this.prettyNames.entrySet()) {
                builder.startObject();
                builder.field("pretty_name", prettyName.getKey());
                builder.field("count", prettyName.getValue());
                builder.endObject();
            }
            builder.endArray();
            builder.startArray("architectures");
            for (Map.Entry<String, Integer> arch : this.architectures.entrySet()) {
                builder.startObject();
                builder.field("arch", arch.getKey());
                builder.field("count", arch.getValue());
                builder.endObject();
            }
            builder.endArray();
            this.mem.toXContent(builder, params);
            return builder;
        }

        static final class Fields {
            static final String AVAILABLE_PROCESSORS = "available_processors";
            static final String ALLOCATED_PROCESSORS = "allocated_processors";
            static final String NAME = "name";
            static final String NAMES = "names";
            static final String PRETTY_NAME = "pretty_name";
            static final String PRETTY_NAMES = "pretty_names";
            static final String ARCH = "arch";
            static final String ARCHITECTURES = "architectures";
            static final String COUNT = "count";

            Fields() {
            }
        }
    }

    public static class ProcessStats
    implements ToXContentFragment {
        final int count;
        final int cpuPercent;
        final long totalOpenFileDescriptors;
        final long minOpenFileDescriptors;
        final long maxOpenFileDescriptors;

        private ProcessStats(List<NodeStats> nodeStatsList) {
            int count = 0;
            int cpuPercent = 0;
            long totalOpenFileDescriptors = 0L;
            long minOpenFileDescriptors = Long.MAX_VALUE;
            long maxOpenFileDescriptors = Long.MIN_VALUE;
            for (NodeStats nodeStats : nodeStatsList) {
                long fd;
                if (nodeStats.getProcess() == null) continue;
                ++count;
                if (nodeStats.getProcess().getCpu() != null) {
                    cpuPercent += nodeStats.getProcess().getCpu().getPercent();
                }
                if ((fd = nodeStats.getProcess().getOpenFileDescriptors()) > 0L) {
                    totalOpenFileDescriptors += fd;
                }
                minOpenFileDescriptors = Math.min(minOpenFileDescriptors, fd);
                maxOpenFileDescriptors = Math.max(maxOpenFileDescriptors, fd);
            }
            this.count = count;
            this.cpuPercent = cpuPercent;
            this.totalOpenFileDescriptors = totalOpenFileDescriptors;
            this.minOpenFileDescriptors = minOpenFileDescriptors;
            this.maxOpenFileDescriptors = maxOpenFileDescriptors;
        }

        public int getCpuPercent() {
            return this.cpuPercent;
        }

        public long getAvgOpenFileDescriptors() {
            if (this.count == 0) {
                return -1L;
            }
            return this.totalOpenFileDescriptors / (long)this.count;
        }

        public long getMaxOpenFileDescriptors() {
            if (this.count == 0) {
                return -1L;
            }
            return this.maxOpenFileDescriptors;
        }

        public long getMinOpenFileDescriptors() {
            if (this.count == 0) {
                return -1L;
            }
            return this.minOpenFileDescriptors;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("cpu").field("percent", this.cpuPercent).endObject();
            if (this.count > 0) {
                builder.startObject("open_file_descriptors");
                builder.field("min", this.getMinOpenFileDescriptors());
                builder.field("max", this.getMaxOpenFileDescriptors());
                builder.field("avg", this.getAvgOpenFileDescriptors());
                builder.endObject();
            }
            return builder;
        }

        static final class Fields {
            static final String CPU = "cpu";
            static final String PERCENT = "percent";
            static final String OPEN_FILE_DESCRIPTORS = "open_file_descriptors";
            static final String MIN = "min";
            static final String MAX = "max";
            static final String AVG = "avg";

            Fields() {
            }
        }
    }

    public static class JvmStats
    implements ToXContentFragment {
        private final Map<JvmVersion, Integer> versions = new HashMap<JvmVersion, Integer>();
        private final long threads;
        private final long maxUptime;
        private final long heapUsed;
        private final long heapMax;

        private JvmStats(List<NodeInfo> nodeInfos, List<NodeStats> nodeStatsList) {
            long threads = 0L;
            long maxUptime = 0L;
            long heapMax = 0L;
            long heapUsed = 0L;
            for (NodeInfo nodeInfo : nodeInfos) {
                this.versions.merge(new JvmVersion(nodeInfo.getInfo(JvmInfo.class)), 1, Integer::sum);
            }
            for (NodeStats nodeStats : nodeStatsList) {
                org.elasticsearch.monitor.jvm.JvmStats js = nodeStats.getJvm();
                if (js == null) continue;
                if (js.getThreads() != null) {
                    threads += (long)js.getThreads().getCount();
                }
                maxUptime = Math.max(maxUptime, js.getUptime().millis());
                if (js.getMem() == null) continue;
                heapUsed += js.getMem().getHeapUsed().getBytes();
                heapMax += js.getMem().getHeapMax().getBytes();
            }
            this.threads = threads;
            this.maxUptime = maxUptime;
            this.heapUsed = heapUsed;
            this.heapMax = heapMax;
        }

        public Map<JvmVersion, Integer> getVersions() {
            return this.versions;
        }

        public long getThreads() {
            return this.threads;
        }

        public TimeValue getMaxUpTime() {
            return new TimeValue(this.maxUptime);
        }

        public ByteSizeValue getHeapUsed() {
            return ByteSizeValue.ofBytes(this.heapUsed);
        }

        public ByteSizeValue getHeapMax() {
            return ByteSizeValue.ofBytes(this.heapMax);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.humanReadableField("max_uptime_in_millis", "max_uptime", new TimeValue(this.maxUptime));
            builder.startArray("versions");
            for (Map.Entry<JvmVersion, Integer> v : this.versions.entrySet()) {
                builder.startObject();
                builder.field("version", v.getKey().version);
                builder.field("vm_name", v.getKey().vmName);
                builder.field("vm_version", v.getKey().vmVersion);
                builder.field("vm_vendor", v.getKey().vmVendor);
                builder.field("bundled_jdk", true);
                builder.field("using_bundled_jdk", v.getKey().usingBundledJdk);
                builder.field("count", v.getValue());
                builder.endObject();
            }
            builder.endArray();
            builder.startObject("mem");
            builder.humanReadableField("heap_used_in_bytes", "heap_used", this.getHeapUsed());
            builder.humanReadableField("heap_max_in_bytes", "heap_max", this.getHeapMax());
            builder.endObject();
            builder.field("threads", this.threads);
            return builder;
        }

        static final class Fields {
            static final String VERSIONS = "versions";
            static final String VERSION = "version";
            static final String VM_NAME = "vm_name";
            static final String VM_VERSION = "vm_version";
            static final String VM_VENDOR = "vm_vendor";
            static final String BUNDLED_JDK = "bundled_jdk";
            static final String USING_BUNDLED_JDK = "using_bundled_jdk";
            static final String COUNT = "count";
            static final String THREADS = "threads";
            static final String MAX_UPTIME = "max_uptime";
            static final String MAX_UPTIME_IN_MILLIS = "max_uptime_in_millis";
            static final String MEM = "mem";
            static final String HEAP_USED = "heap_used";
            static final String HEAP_USED_IN_BYTES = "heap_used_in_bytes";
            static final String HEAP_MAX = "heap_max";
            static final String HEAP_MAX_IN_BYTES = "heap_max_in_bytes";

            Fields() {
            }
        }
    }

    static class NetworkTypes
    implements ToXContentFragment {
        private final Map<String, AtomicInteger> transportTypes;
        private final Map<String, AtomicInteger> httpTypes;

        NetworkTypes(List<NodeInfo> nodeInfos) {
            HashMap<String, AtomicInteger> transportTypes = new HashMap<String, AtomicInteger>();
            HashMap<String, AtomicInteger> httpTypes = new HashMap<String, AtomicInteger>();
            for (NodeInfo nodeInfo : nodeInfos) {
                Settings settings = nodeInfo.getSettings();
                String transportType = settings.get("transport.type", NetworkModule.TRANSPORT_DEFAULT_TYPE_SETTING.get(settings));
                String httpType = settings.get("http.type", NetworkModule.HTTP_DEFAULT_TYPE_SETTING.get(settings));
                if (Strings.hasText(transportType)) {
                    transportTypes.computeIfAbsent(transportType, k -> new AtomicInteger()).incrementAndGet();
                }
                if (!Strings.hasText(httpType)) continue;
                httpTypes.computeIfAbsent(httpType, k -> new AtomicInteger()).incrementAndGet();
            }
            this.transportTypes = Collections.unmodifiableMap(transportTypes);
            this.httpTypes = Collections.unmodifiableMap(httpTypes);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("transport_types");
            for (Map.Entry<String, AtomicInteger> entry : this.transportTypes.entrySet()) {
                builder.field(entry.getKey(), entry.getValue().get());
            }
            builder.endObject();
            builder.startObject("http_types");
            for (Map.Entry<String, AtomicInteger> entry : this.httpTypes.entrySet()) {
                builder.field(entry.getKey(), entry.getValue().get());
            }
            builder.endObject();
            return builder;
        }
    }

    static class DiscoveryTypes
    implements ToXContentFragment {
        private final Map<String, AtomicInteger> discoveryTypes;

        DiscoveryTypes(List<NodeInfo> nodeInfos) {
            HashMap<String, AtomicInteger> discoveryTypes = new HashMap<String, AtomicInteger>();
            for (NodeInfo nodeInfo : nodeInfos) {
                Settings settings = nodeInfo.getSettings();
                String discoveryType = DiscoveryModule.DISCOVERY_TYPE_SETTING.get(settings);
                discoveryTypes.computeIfAbsent(discoveryType, k -> new AtomicInteger()).incrementAndGet();
            }
            this.discoveryTypes = Collections.unmodifiableMap(discoveryTypes);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("discovery_types");
            for (Map.Entry<String, AtomicInteger> entry : this.discoveryTypes.entrySet()) {
                builder.field(entry.getKey(), entry.getValue().get());
            }
            builder.endObject();
            return builder;
        }
    }

    static class PackagingTypes
    implements ToXContentFragment {
        private final Map<String, AtomicInteger> packagingTypes;

        PackagingTypes(List<NodeInfo> nodeInfos) {
            HashMap<String, AtomicInteger> packagingTypes = new HashMap<String, AtomicInteger>();
            for (NodeInfo nodeInfo : nodeInfos) {
                String type = nodeInfo.getBuild().type().displayName();
                packagingTypes.computeIfAbsent(type, k -> new AtomicInteger()).incrementAndGet();
            }
            this.packagingTypes = Collections.unmodifiableMap(packagingTypes);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startArray("packaging_types");
            for (Map.Entry<String, AtomicInteger> entry : this.packagingTypes.entrySet()) {
                builder.startObject();
                builder.field("flavor", "default");
                builder.field("type", entry.getKey());
                builder.field("count", entry.getValue().get());
                builder.endObject();
            }
            builder.endArray();
            return builder;
        }
    }

    static class IngestStats
    implements ToXContentFragment {
        final int pipelineCount;
        final SortedMap<String, long[]> stats;

        IngestStats(List<NodeStats> nodeStats) {
            HashSet<String> pipelineIds = new HashSet<String>();
            TreeMap<String, long[]> stats = new TreeMap<String, long[]>();
            for (NodeStats nodeStat : nodeStats) {
                if (nodeStat.getIngestStats() == null) continue;
                for (Map.Entry<String, List<IngestStats.ProcessorStat>> processorStats : nodeStat.getIngestStats().processorStats().entrySet()) {
                    pipelineIds.add(processorStats.getKey());
                    for (IngestStats.ProcessorStat stat : processorStats.getValue()) {
                        stats.compute(stat.type(), (k, v) -> {
                            IngestStats.Stats nodeIngestStats = stat.stats();
                            if (v == null) {
                                return new long[]{nodeIngestStats.ingestCount(), nodeIngestStats.ingestFailedCount(), nodeIngestStats.ingestCurrent(), nodeIngestStats.ingestTimeInMillis()};
                            }
                            v[0] = v[0] + nodeIngestStats.ingestCount();
                            v[1] = v[1] + nodeIngestStats.ingestFailedCount();
                            v[2] = v[2] + nodeIngestStats.ingestCurrent();
                            v[3] = v[3] + nodeIngestStats.ingestTimeInMillis();
                            return v;
                        });
                    }
                }
            }
            this.pipelineCount = pipelineIds.size();
            this.stats = Collections.unmodifiableSortedMap(stats);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("ingest");
            builder.field("number_of_pipelines", this.pipelineCount);
            builder.startObject("processor_stats");
            for (Map.Entry<String, long[]> stat : this.stats.entrySet()) {
                long[] statValues = stat.getValue();
                builder.startObject(stat.getKey());
                builder.field("count", statValues[0]);
                builder.field("failed", statValues[1]);
                builder.field("current", statValues[2]);
                builder.humanReadableField("time_in_millis", "time", new TimeValue(statValues[3], TimeUnit.MILLISECONDS));
                builder.endObject();
            }
            builder.endObject();
            builder.endObject();
            return builder;
        }
    }

    static class IndexPressureStats
    implements ToXContentFragment {
        private final IndexingPressureStats indexingPressureStats;

        IndexPressureStats(List<NodeStats> nodeStats) {
            long totalCombinedCoordinatingAndPrimaryBytes = 0L;
            long totalCoordinatingBytes = 0L;
            long totalPrimaryBytes = 0L;
            long totalReplicaBytes = 0L;
            long currentCombinedCoordinatingAndPrimaryBytes = 0L;
            long currentCoordinatingBytes = 0L;
            long currentPrimaryBytes = 0L;
            long currentReplicaBytes = 0L;
            long coordinatingRejections = 0L;
            long primaryRejections = 0L;
            long replicaRejections = 0L;
            long primaryDocumentRejections = 0L;
            long memoryLimit = 0L;
            long totalCoordinatingOps = 0L;
            long totalCoordinatingRequests = 0L;
            long totalPrimaryOps = 0L;
            long totalReplicaOps = 0L;
            long currentCoordinatingOps = 0L;
            long currentPrimaryOps = 0L;
            long currentReplicaOps = 0L;
            long lowWaterMarkSplits = 0L;
            long highWaterMarkSplits = 0L;
            for (NodeStats nodeStat : nodeStats) {
                IndexingPressureStats nodeStatIndexingPressureStats = nodeStat.getIndexingPressureStats();
                if (nodeStatIndexingPressureStats == null) continue;
                totalCombinedCoordinatingAndPrimaryBytes += nodeStatIndexingPressureStats.getTotalCombinedCoordinatingAndPrimaryBytes();
                totalCoordinatingBytes += nodeStatIndexingPressureStats.getTotalCoordinatingBytes();
                totalPrimaryBytes += nodeStatIndexingPressureStats.getTotalPrimaryBytes();
                totalReplicaBytes += nodeStatIndexingPressureStats.getTotalReplicaBytes();
                currentCombinedCoordinatingAndPrimaryBytes += nodeStatIndexingPressureStats.getCurrentCombinedCoordinatingAndPrimaryBytes();
                currentCoordinatingBytes += nodeStatIndexingPressureStats.getCurrentCoordinatingBytes();
                currentPrimaryBytes += nodeStatIndexingPressureStats.getCurrentPrimaryBytes();
                currentReplicaBytes += nodeStatIndexingPressureStats.getCurrentReplicaBytes();
                coordinatingRejections += nodeStatIndexingPressureStats.getCoordinatingRejections();
                primaryRejections += nodeStatIndexingPressureStats.getPrimaryRejections();
                replicaRejections += nodeStatIndexingPressureStats.getReplicaRejections();
                memoryLimit += nodeStatIndexingPressureStats.getMemoryLimit();
                totalCoordinatingOps += nodeStatIndexingPressureStats.getTotalCoordinatingOps();
                totalReplicaOps += nodeStatIndexingPressureStats.getTotalReplicaOps();
                currentCoordinatingOps += nodeStatIndexingPressureStats.getCurrentCoordinatingOps();
                currentPrimaryOps += nodeStatIndexingPressureStats.getCurrentPrimaryOps();
                currentReplicaOps += nodeStatIndexingPressureStats.getCurrentReplicaOps();
                primaryDocumentRejections += nodeStatIndexingPressureStats.getPrimaryDocumentRejections();
                totalCoordinatingRequests += nodeStatIndexingPressureStats.getTotalCoordinatingRequests();
                lowWaterMarkSplits += nodeStatIndexingPressureStats.getLowWaterMarkSplits();
                highWaterMarkSplits += nodeStatIndexingPressureStats.getHighWaterMarkSplits();
            }
            this.indexingPressureStats = new IndexingPressureStats(totalCombinedCoordinatingAndPrimaryBytes, totalCoordinatingBytes, totalPrimaryBytes, totalReplicaBytes, currentCombinedCoordinatingAndPrimaryBytes, currentCoordinatingBytes, currentPrimaryBytes, currentReplicaBytes, coordinatingRejections, primaryRejections, replicaRejections, memoryLimit, totalCoordinatingOps, totalPrimaryOps, totalReplicaOps, currentCoordinatingOps, currentPrimaryOps, currentReplicaOps, primaryDocumentRejections, totalCoordinatingRequests, lowWaterMarkSplits, highWaterMarkSplits);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.indexingPressureStats.toXContent(builder, params);
        }
    }

    static final class Fields {
        static final String COUNT = "count";
        static final String VERSIONS = "versions";
        static final String OS = "os";
        static final String PROCESS = "process";
        static final String JVM = "jvm";
        static final String FS = "fs";
        static final String PLUGINS = "plugins";
        static final String NETWORK_TYPES = "network_types";

        Fields() {
        }
    }

    public static class JvmVersion {
        String version;
        String vmName;
        String vmVersion;
        String vmVendor;
        Boolean usingBundledJdk;

        JvmVersion(JvmInfo jvmInfo) {
            this.version = jvmInfo.version();
            this.vmName = jvmInfo.getVmName();
            this.vmVersion = jvmInfo.getVmVersion();
            this.vmVendor = jvmInfo.getVmVendor();
            this.usingBundledJdk = jvmInfo.getUsingBundledJdk();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JvmVersion jvm = (JvmVersion)o;
            return this.vmVersion.equals(jvm.vmVersion) && this.vmVendor.equals(jvm.vmVendor);
        }

        public int hashCode() {
            return this.vmVersion.hashCode();
        }
    }
}

