/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.filters.elasticintegration;

import co.elastic.logstash.api.Password;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class PluginConfiguration {
    private final String id;
    private final String cloudId;
    private final List<String> hosts;
    private final String proxy;
    private final Boolean sslEnabled;
    private final String sslVerificationMode;
    private final String sslTruststorePath;
    private final Password sslTruststorePassword;
    private final List<String> sslCertificateAuthorities;
    private final String sslKeystorePath;
    private final Password sslKeystorePassword;
    private final String sslCertificate;
    private final String sslKey;
    private final Password sslKeyPassphrase;
    private final String authBasicUsername;
    private final Password authBasicPassword;
    private final Password cloudAuth;
    private final Password apiKey;
    private final String pipelineNameTemplate;

    private PluginConfiguration(Builder builder) {
        this.id = builder.id;
        this.cloudId = builder.cloudId;
        this.hosts = PluginConfiguration.copyOfNullableList(builder.hosts);
        this.sslEnabled = builder.sslEnabled;
        this.sslVerificationMode = builder.sslVerificationMode;
        this.sslTruststorePath = builder.sslTruststorePath;
        this.sslTruststorePassword = builder.sslTruststorePassword;
        this.sslCertificateAuthorities = PluginConfiguration.copyOfNullableList(builder.sslCertificateAuthorities);
        this.sslKeystorePath = builder.sslKeystorePath;
        this.sslKeystorePassword = builder.sslKeystorePassword;
        this.sslCertificate = builder.sslCertificate;
        this.sslKey = builder.sslKey;
        this.sslKeyPassphrase = builder.sslKeyPassphrase;
        this.authBasicUsername = builder.authBasicUsername;
        this.authBasicPassword = builder.authBasicPassword;
        this.cloudAuth = builder.cloudAuth;
        this.apiKey = builder.apiKey;
        this.pipelineNameTemplate = builder.pipelineNameTemplate;
        this.proxy = builder.proxy;
    }

    private static <T> List<T> copyOfNullableList(List<T> source) {
        if (Objects.isNull(source)) {
            return null;
        }
        return List.copyOf(source);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<String> id() {
        return Optional.ofNullable(this.id);
    }

    public Optional<String> cloudId() {
        return Optional.ofNullable(this.cloudId);
    }

    public Optional<List<URL>> hosts() {
        return Optional.ofNullable(this.hosts).map(hosts -> hosts.stream().map(PluginConfiguration::uncheckedParseURL).toList());
    }

    public Optional<String> proxy() {
        return Optional.ofNullable(this.proxy);
    }

    public Optional<Boolean> sslEnabled() {
        return Optional.ofNullable(this.sslEnabled);
    }

    public Optional<String> sslVerificationMode() {
        return Optional.ofNullable(this.sslVerificationMode);
    }

    public Optional<Path> truststore() {
        return Optional.ofNullable(this.sslTruststorePath).map(x$0 -> Paths.get(x$0, new String[0]));
    }

    public Optional<Password> truststorePassword() {
        return Optional.ofNullable(this.sslTruststorePassword);
    }

    public Optional<List<Path>> sslCertificateAuthorities() {
        return Optional.ofNullable(this.sslCertificateAuthorities).map(cas -> cas.stream().map(x$0 -> Paths.get(x$0, new String[0])).toList());
    }

    public Optional<Path> keystore() {
        return Optional.ofNullable(this.sslKeystorePath).map(x$0 -> Paths.get(x$0, new String[0]));
    }

    public Optional<Password> keystorePassword() {
        return Optional.ofNullable(this.sslKeystorePassword);
    }

    public Optional<Path> sslCertificate() {
        return Optional.ofNullable(this.sslCertificate).map(x$0 -> Paths.get(x$0, new String[0]));
    }

    public Optional<Path> sslKey() {
        return Optional.ofNullable(this.sslKey).map(x$0 -> Paths.get(x$0, new String[0]));
    }

    public Optional<Password> sslKeyPassphrase() {
        return Optional.ofNullable(this.sslKeyPassphrase);
    }

    public Optional<String> authBasicUsername() {
        return Optional.ofNullable(this.authBasicUsername);
    }

    public Optional<Password> authBasicPassword() {
        return Optional.ofNullable(this.authBasicPassword);
    }

    public Optional<Password> cloudAuth() {
        return Optional.ofNullable(this.cloudAuth);
    }

    public Optional<Password> apiKey() {
        return Optional.ofNullable(this.apiKey);
    }

    public Optional<String> pipelineNameTemplate() {
        return Optional.ofNullable(this.pipelineNameTemplate);
    }

    public String toString() {
        ArrayList<String> config = new ArrayList<String>();
        if (Objects.nonNull(this.id)) {
            config.add(String.format("id=%s", this.id));
        }
        if (Objects.nonNull(this.cloudId)) {
            config.add(String.format("cloudId=%s", this.cloudId));
        }
        if (Objects.nonNull(this.hosts)) {
            config.add(String.format("hosts=%s", this.hosts));
        }
        if (Objects.nonNull(this.proxy)) {
            config.add(String.format("proxy=%s", this.proxy));
        }
        if (Objects.nonNull(this.sslEnabled)) {
            config.add(String.format("sslEnabled=%s", this.sslEnabled));
        }
        if (Objects.nonNull(this.sslVerificationMode)) {
            config.add(String.format("sslVerificationMode=%s", this.sslVerificationMode));
        }
        if (Objects.nonNull(this.sslTruststorePath)) {
            config.add(String.format("sslTruststorePath=%s", this.sslTruststorePath));
        }
        if (Objects.nonNull(this.sslTruststorePassword)) {
            config.add(String.format("sslTruststorePassword=%s", this.sslTruststorePassword));
        }
        if (Objects.nonNull(this.sslCertificateAuthorities)) {
            config.add(String.format("sslCertificateAuthorities=%s", this.sslCertificateAuthorities));
        }
        if (Objects.nonNull(this.sslKeystorePath)) {
            config.add(String.format("sslKeystorePath=%s", this.sslKeystorePath));
        }
        if (Objects.nonNull(this.sslKeystorePassword)) {
            config.add(String.format("sslKeystorePassword=%s", this.sslKeystorePassword));
        }
        if (Objects.nonNull(this.sslCertificate)) {
            config.add(String.format("sslCertificate=%s", this.sslCertificate));
        }
        if (Objects.nonNull(this.sslKey)) {
            config.add(String.format("sslKey=%s", this.sslKey));
        }
        if (Objects.nonNull(this.sslKeyPassphrase)) {
            config.add(String.format("sslKeyPassphrase=%s", this.sslKeyPassphrase));
        }
        if (Objects.nonNull(this.authBasicUsername)) {
            config.add(String.format("authBasicUsername=%s", this.authBasicUsername));
        }
        if (Objects.nonNull(this.authBasicPassword)) {
            config.add(String.format("authBasicPassword=%s", this.authBasicPassword));
        }
        if (Objects.nonNull(this.cloudAuth)) {
            config.add(String.format("cloudAuth=%s", this.cloudAuth));
        }
        if (Objects.nonNull(this.apiKey)) {
            config.add(String.format("sslKeyPassphrase=%s", this.apiKey));
        }
        if (Objects.nonNull(this.pipelineNameTemplate)) {
            config.add(String.format("pipelineNameTemplate=%s", this.pipelineNameTemplate));
        }
        return String.format("PluginConfiguration{%s}", String.join((CharSequence)", ", config));
    }

    private static URL uncheckedParseURL(String urlSpec) {
        try {
            return new URL(urlSpec);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Builder {
        String id;
        String cloudId;
        List<String> hosts;
        String proxy;
        Boolean sslEnabled;
        String sslVerificationMode;
        String sslTruststorePath;
        Password sslTruststorePassword;
        List<String> sslCertificateAuthorities;
        String sslKeystorePath;
        Password sslKeystorePassword;
        String sslCertificate;
        String sslKey;
        Password sslKeyPassphrase;
        String authBasicUsername;
        Password authBasicPassword;
        Password cloudAuth;
        Password apiKey;
        String pipelineNameTemplate;

        public PluginConfiguration build() {
            return new PluginConfiguration(this);
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setCloudId(String cloudId) {
            this.cloudId = cloudId;
            return this;
        }

        public Builder setHosts(List<String> hosts) {
            if (Objects.nonNull(hosts)) {
                this.hosts = List.copyOf(hosts);
            }
            return this;
        }

        public Builder setProxy(String proxy) {
            if (Objects.nonNull(proxy) && !proxy.isBlank()) {
                this.proxy = proxy;
            }
            return this;
        }

        public Builder setSslEnabled(Boolean sslEnabled) {
            this.sslEnabled = sslEnabled;
            return this;
        }

        public Builder setSslVerificationMode(String sslVerificationMode) {
            this.sslVerificationMode = sslVerificationMode;
            return this;
        }

        public Builder setSslTruststorePath(String sslTruststorePath) {
            this.sslTruststorePath = sslTruststorePath;
            return this;
        }

        public Builder setSslTruststorePassword(Password sslTruststorePassword) {
            this.sslTruststorePassword = sslTruststorePassword;
            return this;
        }

        public Builder setSslCertificateAuthorities(List<String> sslCertificateAuthorities) {
            if (Objects.nonNull(sslCertificateAuthorities)) {
                this.sslCertificateAuthorities = List.copyOf(sslCertificateAuthorities);
            }
            return this;
        }

        public Builder setSslKeystorePath(String sslKeystorePath) {
            this.sslKeystorePath = sslKeystorePath;
            return this;
        }

        public Builder setSslKeystorePassword(Password sslKeystorePassword) {
            this.sslKeystorePassword = sslKeystorePassword;
            return this;
        }

        public Builder setSslCertificate(String sslCertificate) {
            this.sslCertificate = sslCertificate;
            return this;
        }

        public Builder setSslKey(String sslKey) {
            this.sslKey = sslKey;
            return this;
        }

        public Builder setSslKeyPassphrase(Password sslKeyPassphrase) {
            this.sslKeyPassphrase = sslKeyPassphrase;
            return this;
        }

        public Builder setAuthBasicUsername(String authBasicUsername) {
            this.authBasicUsername = authBasicUsername;
            return this;
        }

        public Builder setAuthBasicPassword(Password authBasicPassword) {
            this.authBasicPassword = authBasicPassword;
            return this;
        }

        public Builder setCloudAuth(Password cloudAuth) {
            this.cloudAuth = cloudAuth;
            return this;
        }

        public Builder setApiKey(Password apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder setPipelineNameTemplate(String pipelineNameTemplate) {
            this.pipelineNameTemplate = pipelineNameTemplate;
            return this;
        }
    }
}

