/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.tasks;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.elasticsearch._types.TaskFailure;
import co.elastic.clients.elasticsearch.tasks.NodeTasks;
import co.elastic.clients.elasticsearch.tasks.TaskInfos;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class TaskListResponseBase
implements JsonpSerializable {
    private final List<ErrorCause> nodeFailures;
    private final List<TaskFailure> taskFailures;
    private final Map<String, NodeTasks> nodes;
    @Nullable
    private final TaskInfos tasks;

    protected TaskListResponseBase(AbstractBuilder<?> builder) {
        this.nodeFailures = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).nodeFailures);
        this.taskFailures = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).taskFailures);
        this.nodes = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).nodes);
        this.tasks = ((AbstractBuilder)builder).tasks;
    }

    public final List<ErrorCause> nodeFailures() {
        return this.nodeFailures;
    }

    public final List<TaskFailure> taskFailures() {
        return this.taskFailures;
    }

    public final Map<String, NodeTasks> nodes() {
        return this.nodes;
    }

    @Nullable
    public final TaskInfos tasks() {
        return this.tasks;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.nodeFailures)) {
            generator.writeKey("node_failures");
            generator.writeStartArray();
            for (ErrorCause errorCause : this.nodeFailures) {
                errorCause.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.taskFailures)) {
            generator.writeKey("task_failures");
            generator.writeStartArray();
            for (TaskFailure taskFailure : this.taskFailures) {
                taskFailure.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.nodes)) {
            generator.writeKey("nodes");
            generator.writeStartObject();
            for (Map.Entry entry : this.nodes.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((NodeTasks)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.tasks != null) {
            generator.writeKey("tasks");
            this.tasks.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupTaskListResponseBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::nodeFailures, JsonpDeserializer.arrayDeserializer(ErrorCause._DESERIALIZER), "node_failures");
        op.add(AbstractBuilder::taskFailures, JsonpDeserializer.arrayDeserializer(TaskFailure._DESERIALIZER), "task_failures");
        op.add(AbstractBuilder::nodes, JsonpDeserializer.stringMapDeserializer(NodeTasks._DESERIALIZER), "nodes");
        op.add(AbstractBuilder::tasks, TaskInfos._DESERIALIZER, "tasks");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        @Nullable
        private List<ErrorCause> nodeFailures;
        @Nullable
        private List<TaskFailure> taskFailures;
        @Nullable
        private Map<String, NodeTasks> nodes;
        @Nullable
        private TaskInfos tasks;

        public final BuilderT nodeFailures(List<ErrorCause> list) {
            this.nodeFailures = AbstractBuilder._listAddAll(this.nodeFailures, list);
            return (BuilderT)this.self();
        }

        public final BuilderT nodeFailures(ErrorCause value, ErrorCause ... values) {
            this.nodeFailures = AbstractBuilder._listAdd(this.nodeFailures, value, values);
            return (BuilderT)this.self();
        }

        public final BuilderT nodeFailures(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.nodeFailures(fn.apply(new ErrorCause.Builder()).build(), new ErrorCause[0]);
        }

        public final BuilderT taskFailures(List<TaskFailure> list) {
            this.taskFailures = AbstractBuilder._listAddAll(this.taskFailures, list);
            return (BuilderT)this.self();
        }

        public final BuilderT taskFailures(TaskFailure value, TaskFailure ... values) {
            this.taskFailures = AbstractBuilder._listAdd(this.taskFailures, value, values);
            return (BuilderT)this.self();
        }

        public final BuilderT taskFailures(Function<TaskFailure.Builder, ObjectBuilder<TaskFailure>> fn) {
            return this.taskFailures(fn.apply(new TaskFailure.Builder()).build(), new TaskFailure[0]);
        }

        public final BuilderT nodes(Map<String, NodeTasks> map) {
            this.nodes = AbstractBuilder._mapPutAll(this.nodes, map);
            return (BuilderT)this.self();
        }

        public final BuilderT nodes(String key, NodeTasks value) {
            this.nodes = AbstractBuilder._mapPut(this.nodes, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT nodes(String key, Function<NodeTasks.Builder, ObjectBuilder<NodeTasks>> fn) {
            return this.nodes(key, fn.apply(new NodeTasks.Builder()).build());
        }

        public final BuilderT tasks(@Nullable TaskInfos value) {
            this.tasks = value;
            return (BuilderT)this.self();
        }

        public final BuilderT tasks(Function<TaskInfos.Builder, ObjectBuilder<TaskInfos>> fn) {
            return this.tasks(fn.apply(new TaskInfos.Builder()).build());
        }

        @Override
        protected abstract BuilderT self();
    }
}

