/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.termsenum.action;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportResponse;

class NodeTermsEnumResponse
extends TransportResponse {
    private final String error;
    private final boolean complete;
    private final List<String> terms;
    private final String nodeId;

    NodeTermsEnumResponse(StreamInput in) throws IOException {
        super(in);
        this.terms = in.getTransportVersion().before(TransportVersions.V_8_2_0) ? in.readCollectionAsList(r -> {
            String term = r.readString();
            in.readLong();
            return term;
        }) : in.readStringCollectionAsList();
        this.error = in.readOptionalString();
        this.complete = in.readBoolean();
        this.nodeId = in.readString();
    }

    public static NodeTermsEnumResponse empty(String nodeId) {
        return new NodeTermsEnumResponse(nodeId, List.of(), null, true);
    }

    public static NodeTermsEnumResponse complete(String nodeId, List<String> terms) {
        return new NodeTermsEnumResponse(nodeId, terms, null, true);
    }

    public static NodeTermsEnumResponse partial(String nodeId, List<String> terms) {
        return new NodeTermsEnumResponse(nodeId, terms, null, false);
    }

    public static NodeTermsEnumResponse error(String nodeId, List<String> terms, Exception error) {
        return new NodeTermsEnumResponse(nodeId, terms, ExceptionsHelper.stackTrace(error), false);
    }

    private NodeTermsEnumResponse(String nodeId, List<String> terms, String error, boolean complete) {
        this.nodeId = nodeId;
        this.terms = terms;
        this.error = error;
        this.complete = complete;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().before(TransportVersions.V_8_2_0)) {
            out.writeCollection(this.terms.stream().map(term -> out1 -> {
                out1.writeString((String)term);
                out1.writeLong(1L);
            }).collect(Collectors.toList()));
        } else {
            out.writeStringCollection(this.terms);
        }
        out.writeOptionalString(this.error);
        out.writeBoolean(this.complete);
        out.writeString(this.nodeId);
    }

    public List<String> terms() {
        return this.terms;
    }

    public String getError() {
        return this.error;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public boolean isComplete() {
        return this.complete;
    }
}

