/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reservedstate.service;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.SimpleBatchedExecutor;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.reservedstate.service.ReservedStateUpdateTask;

public class ReservedStateUpdateTaskExecutor
extends SimpleBatchedExecutor<ReservedStateUpdateTask, Void> {
    private static final Logger logger = LogManager.getLogger(ReservedStateUpdateTaskExecutor.class);
    private final RerouteService rerouteService;

    public ReservedStateUpdateTaskExecutor(RerouteService rerouteService) {
        this.rerouteService = rerouteService;
    }

    @Override
    public Tuple<ClusterState, Void> executeTask(ReservedStateUpdateTask task, ClusterState clusterState) {
        return Tuple.tuple(task.execute(clusterState), null);
    }

    @Override
    public void taskSucceeded(ReservedStateUpdateTask task, Void unused) {
        task.listener().onResponse(ActionResponse.Empty.INSTANCE);
    }

    @Override
    public void clusterStatePublished() {
        this.rerouteService.reroute("reroute after saving and reserving part of the cluster state", Priority.NORMAL, ActionListener.wrap(r -> logger.trace("reroute after applying and reserving part of the cluster state succeeded"), e -> logger.debug("reroute after applying and reserving part of the cluster state failed", (Throwable)e)));
    }
}

