/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.List;
import java.util.Map;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.common.CsvParser;

public final class CsvProcessor
extends AbstractProcessor {
    public static final String TYPE = "csv";
    final String field;
    final String[] headers;
    final boolean trim;
    final char quote;
    final char separator;
    final boolean ignoreMissing;
    final Object emptyValue;

    CsvProcessor(String tag, String description, String field, String[] headers, boolean trim, char separator, char quote, boolean ignoreMissing, Object emptyValue) {
        super(tag, description);
        this.field = field;
        this.headers = headers;
        this.trim = trim;
        this.quote = quote;
        this.separator = separator;
        this.ignoreMissing = ignoreMissing;
        this.emptyValue = emptyValue;
    }

    @Override
    public IngestDocument execute(IngestDocument ingestDocument) {
        if (this.headers.length == 0) {
            return ingestDocument;
        }
        String line = ingestDocument.getFieldValue(this.field, String.class, this.ignoreMissing);
        if (line == null && this.ignoreMissing) {
            return ingestDocument;
        }
        if (line == null) {
            throw new IllegalArgumentException("field [" + this.field + "] is null, cannot process it.");
        }
        new CsvParser(ingestDocument, this.quote, this.separator, this.trim, this.headers, this.emptyValue).process(line);
        return ingestDocument;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        @Override
        public CsvProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) {
            String field = ConfigurationUtils.readStringProperty(CsvProcessor.TYPE, processorTag, config, "field");
            String quote = ConfigurationUtils.readStringProperty(CsvProcessor.TYPE, processorTag, config, "quote", "\"");
            if (quote.length() != 1) {
                throw ConfigurationUtils.newConfigurationException(CsvProcessor.TYPE, processorTag, "quote", "quote has to be single character like \" or '");
            }
            String separator = ConfigurationUtils.readStringProperty(CsvProcessor.TYPE, processorTag, config, "separator", ",");
            if (separator.length() != 1) {
                throw ConfigurationUtils.newConfigurationException(CsvProcessor.TYPE, processorTag, "separator", "separator has to be single character like , or ;");
            }
            boolean trim = ConfigurationUtils.readBooleanProperty(CsvProcessor.TYPE, processorTag, config, "trim", false);
            Object emptyValue = null;
            if (config.containsKey("empty_value")) {
                emptyValue = ConfigurationUtils.readObject(CsvProcessor.TYPE, processorTag, config, "empty_value");
            }
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty(CsvProcessor.TYPE, processorTag, config, "ignore_missing", false);
            List targetFields = ConfigurationUtils.readList(CsvProcessor.TYPE, processorTag, config, "target_fields");
            if (targetFields.isEmpty()) {
                throw ConfigurationUtils.newConfigurationException(CsvProcessor.TYPE, processorTag, "target_fields", "target fields list can't be empty");
            }
            return new CsvProcessor(processorTag, description, field, (String[])targetFields.toArray(String[]::new), trim, separator.charAt(0), quote.charAt(0), ignoreMissing, emptyValue);
        }
    }
}

