/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.es818;

import java.io.IOException;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.VectorUtil;
import org.apache.lucene.util.hnsw.RandomAccessVectorValues;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;
import org.elasticsearch.index.codec.vectors.BQSpaceUtils;
import org.elasticsearch.index.codec.vectors.OptimizedScalarQuantizer;
import org.elasticsearch.index.codec.vectors.es818.BinarizedByteVectorValues;
import org.elasticsearch.index.codec.vectors.es818.ES818BinaryQuantizedVectorsWriter;
import org.elasticsearch.index.codec.vectors.es818.RandomAccessBinarizedByteVectorValues;
import org.elasticsearch.simdvec.ESVectorUtil;

public class ES818BinaryFlatVectorsScorer
implements FlatVectorsScorer {
    private final FlatVectorsScorer nonQuantizedDelegate;
    private static final float FOUR_BIT_SCALE = 0.06666667f;

    public ES818BinaryFlatVectorsScorer(FlatVectorsScorer nonQuantizedDelegate) {
        this.nonQuantizedDelegate = nonQuantizedDelegate;
    }

    @Override
    public RandomVectorScorerSupplier getRandomVectorScorerSupplier(VectorSimilarityFunction similarityFunction, RandomAccessVectorValues vectorValues) throws IOException {
        if (vectorValues instanceof BinarizedByteVectorValues) {
            throw new UnsupportedOperationException("getRandomVectorScorerSupplier(VectorSimilarityFunction,RandomAccessVectorValues) not implemented for binarized format");
        }
        return this.nonQuantizedDelegate.getRandomVectorScorerSupplier(similarityFunction, vectorValues);
    }

    @Override
    public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction similarityFunction, RandomAccessVectorValues vectorValues, float[] target) throws IOException {
        if (vectorValues instanceof RandomAccessBinarizedByteVectorValues) {
            RandomAccessBinarizedByteVectorValues binarizedVectors = (RandomAccessBinarizedByteVectorValues)vectorValues;
            assert (binarizedVectors.getQuantizer() != null) : "BinarizedByteVectorValues must have a quantizer for ES816BinaryFlatVectorsScorer";
            assert (binarizedVectors.size() > 0) : "BinarizedByteVectorValues must have at least one vector for ES816BinaryFlatVectorsScorer";
            OptimizedScalarQuantizer quantizer = binarizedVectors.getQuantizer();
            float[] centroid = binarizedVectors.getCentroid();
            float[] copy = ArrayUtil.copyOfSubArray(target, 0, target.length);
            if (similarityFunction == VectorSimilarityFunction.COSINE) {
                VectorUtil.l2normalize(copy);
            }
            target = copy;
            byte[] initial = new byte[target.length];
            byte[] quantized = new byte[4 * binarizedVectors.discretizedDimensions() / 8];
            OptimizedScalarQuantizer.QuantizationResult queryCorrections = quantizer.scalarQuantize(target, initial, (byte)4, centroid);
            BQSpaceUtils.transposeHalfByte(initial, quantized);
            BinaryQueryVector queryVector = new BinaryQueryVector(quantized, queryCorrections);
            return new BinarizedRandomVectorScorer(queryVector, binarizedVectors, similarityFunction);
        }
        return this.nonQuantizedDelegate.getRandomVectorScorer(similarityFunction, vectorValues, target);
    }

    @Override
    public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction similarityFunction, RandomAccessVectorValues vectorValues, byte[] target) throws IOException {
        return this.nonQuantizedDelegate.getRandomVectorScorer(similarityFunction, vectorValues, target);
    }

    RandomVectorScorerSupplier getRandomVectorScorerSupplier(VectorSimilarityFunction similarityFunction, ES818BinaryQuantizedVectorsWriter.OffHeapBinarizedQueryVectorValues scoringVectors, RandomAccessBinarizedByteVectorValues targetVectors) {
        return new BinarizedRandomVectorScorerSupplier(scoringVectors, targetVectors, similarityFunction);
    }

    public String toString() {
        return "ES818BinaryFlatVectorsScorer(nonQuantizedDelegate=" + String.valueOf(this.nonQuantizedDelegate) + ")";
    }

    public record BinaryQueryVector(byte[] vector, OptimizedScalarQuantizer.QuantizationResult quantizationResult) {
    }

    public static class BinarizedRandomVectorScorer
    extends RandomVectorScorer.AbstractRandomVectorScorer {
        private final BinaryQueryVector queryVector;
        private final RandomAccessBinarizedByteVectorValues targetVectors;
        private final VectorSimilarityFunction similarityFunction;

        public BinarizedRandomVectorScorer(BinaryQueryVector queryVectors, RandomAccessBinarizedByteVectorValues targetVectors, VectorSimilarityFunction similarityFunction) {
            super(targetVectors);
            this.queryVector = queryVectors;
            this.targetVectors = targetVectors;
            this.similarityFunction = similarityFunction;
        }

        @Override
        public float score(int targetOrd) throws IOException {
            byte[] quantizedQuery = this.queryVector.vector();
            byte[] binaryCode = this.targetVectors.vectorValue(targetOrd);
            float qcDist = ESVectorUtil.ipByteBinByte((byte[])quantizedQuery, (byte[])binaryCode);
            OptimizedScalarQuantizer.QuantizationResult queryCorrections = this.queryVector.quantizationResult();
            OptimizedScalarQuantizer.QuantizationResult indexCorrections = this.targetVectors.getCorrectiveTerms(targetOrd);
            float x1 = indexCorrections.quantizedComponentSum();
            float ax = indexCorrections.lowerInterval();
            float lx = indexCorrections.upperInterval() - ax;
            float ay = queryCorrections.lowerInterval();
            float ly = (queryCorrections.upperInterval() - ay) * 0.06666667f;
            float y1 = queryCorrections.quantizedComponentSum();
            float score = ax * ay * (float)this.targetVectors.dimension() + ay * lx * x1 + ax * ly * y1 + lx * ly * qcDist;
            if (this.similarityFunction == VectorSimilarityFunction.EUCLIDEAN) {
                score = queryCorrections.additionalCorrection() + indexCorrections.additionalCorrection() - 2.0f * score;
                return Math.max(1.0f / (1.0f + score), 0.0f);
            }
            score += queryCorrections.additionalCorrection() + indexCorrections.additionalCorrection() - this.targetVectors.getCentroidDP();
            if (this.similarityFunction == VectorSimilarityFunction.MAXIMUM_INNER_PRODUCT) {
                return VectorUtil.scaleMaxInnerProductScore(score);
            }
            return Math.max((1.0f + score) / 2.0f, 0.0f);
        }
    }

    static class BinarizedRandomVectorScorerSupplier
    implements RandomVectorScorerSupplier {
        private final ES818BinaryQuantizedVectorsWriter.OffHeapBinarizedQueryVectorValues queryVectors;
        private final RandomAccessBinarizedByteVectorValues targetVectors;
        private final VectorSimilarityFunction similarityFunction;

        BinarizedRandomVectorScorerSupplier(ES818BinaryQuantizedVectorsWriter.OffHeapBinarizedQueryVectorValues queryVectors, RandomAccessBinarizedByteVectorValues targetVectors, VectorSimilarityFunction similarityFunction) {
            this.queryVectors = queryVectors;
            this.targetVectors = targetVectors;
            this.similarityFunction = similarityFunction;
        }

        @Override
        public RandomVectorScorer scorer(int ord) throws IOException {
            byte[] vector = this.queryVectors.vectorValue(ord);
            OptimizedScalarQuantizer.QuantizationResult correctiveTerms = this.queryVectors.getCorrectiveTerms(ord);
            BinaryQueryVector binaryQueryVector = new BinaryQueryVector(vector, correctiveTerms);
            return new BinarizedRandomVectorScorer(binaryQueryVector, this.targetVectors, this.similarityFunction);
        }

        @Override
        public RandomVectorScorerSupplier copy() throws IOException {
            return new BinarizedRandomVectorScorerSupplier(this.queryVectors.copy(), this.targetVectors.copy(), this.similarityFunction);
        }
    }
}

