/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.geometry.utils;

import java.util.Locale;
import java.util.Optional;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryCollection;
import org.elasticsearch.geometry.GeometryVisitor;
import org.elasticsearch.geometry.Line;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.MultiLine;
import org.elasticsearch.geometry.MultiPoint;
import org.elasticsearch.geometry.MultiPolygon;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Polygon;
import org.elasticsearch.geometry.Rectangle;

public class SpatialEnvelopeVisitor
implements GeometryVisitor<Boolean, RuntimeException> {
    private final PointVisitor pointVisitor;

    public SpatialEnvelopeVisitor(PointVisitor pointVisitor) {
        this.pointVisitor = pointVisitor;
    }

    public static Optional<Rectangle> visitCartesian(Geometry geometry) {
        SpatialEnvelopeVisitor visitor = new SpatialEnvelopeVisitor(new CartesianPointVisitor());
        if (geometry.visit(visitor).booleanValue()) {
            return Optional.of(visitor.getResult());
        }
        return Optional.empty();
    }

    public static Optional<Rectangle> visitGeo(Geometry geometry, WrapLongitude wrapLongitude) {
        SpatialEnvelopeVisitor visitor = new SpatialEnvelopeVisitor(new GeoPointVisitor(wrapLongitude));
        if (geometry.visit(visitor).booleanValue()) {
            return Optional.of(visitor.getResult());
        }
        return Optional.empty();
    }

    public Rectangle getResult() {
        return this.pointVisitor.getResult();
    }

    private boolean isValid() {
        return this.pointVisitor.isValid();
    }

    @Override
    public Boolean visit(Circle circle) throws RuntimeException {
        throw new UnsupportedOperationException("Circle is not supported");
    }

    @Override
    public Boolean visit(GeometryCollection<?> collection) throws RuntimeException {
        collection.forEach(geometry -> geometry.visit(this));
        return this.isValid();
    }

    @Override
    public Boolean visit(Line line) throws RuntimeException {
        for (int i = 0; i < line.length(); ++i) {
            this.pointVisitor.visitPoint(line.getX(i), line.getY(i));
        }
        return this.isValid();
    }

    @Override
    public Boolean visit(LinearRing ring) throws RuntimeException {
        for (int i = 0; i < ring.length(); ++i) {
            this.pointVisitor.visitPoint(ring.getX(i), ring.getY(i));
        }
        return this.isValid();
    }

    @Override
    public Boolean visit(MultiLine multiLine) throws RuntimeException {
        multiLine.forEach(line -> line.visit(this));
        return this.isValid();
    }

    @Override
    public Boolean visit(MultiPoint multiPoint) throws RuntimeException {
        for (int i = 0; i < multiPoint.size(); ++i) {
            this.visit((Point)multiPoint.get(i));
        }
        return this.isValid();
    }

    @Override
    public Boolean visit(MultiPolygon multiPolygon) throws RuntimeException {
        multiPolygon.forEach(polygon -> polygon.visit(this));
        return this.isValid();
    }

    @Override
    public Boolean visit(Point point) throws RuntimeException {
        this.pointVisitor.visitPoint(point.getX(), point.getY());
        return this.isValid();
    }

    @Override
    public Boolean visit(Polygon polygon) throws RuntimeException {
        this.visit(polygon.getPolygon());
        for (int i = 0; i < polygon.getNumberOfHoles(); ++i) {
            this.visit(polygon.getHole(i));
        }
        return this.isValid();
    }

    @Override
    public Boolean visit(Rectangle rectangle) throws RuntimeException {
        this.pointVisitor.visitRectangle(rectangle.getMinX(), rectangle.getMaxX(), rectangle.getMaxY(), rectangle.getMinY());
        return this.isValid();
    }

    public static interface PointVisitor {
        public void visitPoint(double var1, double var3);

        public void visitRectangle(double var1, double var3, double var5, double var7);

        public boolean isValid();

        public Rectangle getResult();

        public void reset();
    }

    public static class CartesianPointVisitor
    implements PointVisitor {
        private double minX = Double.POSITIVE_INFINITY;
        private double maxX = Double.NEGATIVE_INFINITY;
        private double maxY = Double.NEGATIVE_INFINITY;
        private double minY = Double.POSITIVE_INFINITY;

        public double getMinX() {
            return this.minX;
        }

        public double getMaxX() {
            return this.maxX;
        }

        public double getMaxY() {
            return this.maxY;
        }

        public double getMinY() {
            return this.minY;
        }

        @Override
        public void visitPoint(double x, double y) {
            this.minX = Math.min(this.minX, x);
            this.maxX = Math.max(this.maxX, x);
            this.maxY = Math.max(this.maxY, y);
            this.minY = Math.min(this.minY, y);
        }

        @Override
        public void visitRectangle(double minX, double maxX, double maxY, double minY) {
            if (minX > maxX) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid cartesian rectangle: minX (%s) > maxX (%s)", minX, maxX));
            }
            this.minX = Math.min(this.minX, minX);
            this.maxX = Math.max(this.maxX, maxX);
            this.maxY = Math.max(this.maxY, maxY);
            this.minY = Math.min(this.minY, minY);
        }

        @Override
        public boolean isValid() {
            return this.minY != Double.POSITIVE_INFINITY;
        }

        @Override
        public Rectangle getResult() {
            return new Rectangle(this.minX, this.maxX, this.maxY, this.minY);
        }

        @Override
        public void reset() {
            this.minX = Double.POSITIVE_INFINITY;
            this.maxX = Double.NEGATIVE_INFINITY;
            this.maxY = Double.NEGATIVE_INFINITY;
            this.minY = Double.POSITIVE_INFINITY;
        }
    }

    public static class GeoPointVisitor
    implements PointVisitor {
        protected double top = Double.NEGATIVE_INFINITY;
        protected double bottom = Double.POSITIVE_INFINITY;
        protected double negLeft = Double.POSITIVE_INFINITY;
        protected double negRight = Double.NEGATIVE_INFINITY;
        protected double posLeft = Double.POSITIVE_INFINITY;
        protected double posRight = Double.NEGATIVE_INFINITY;
        private final WrapLongitude wrapLongitude;

        public GeoPointVisitor(WrapLongitude wrapLongitude) {
            this.wrapLongitude = wrapLongitude;
        }

        public double getTop() {
            return this.top;
        }

        public double getBottom() {
            return this.bottom;
        }

        public double getNegLeft() {
            return this.negLeft;
        }

        public double getNegRight() {
            return this.negRight;
        }

        public double getPosLeft() {
            return this.posLeft;
        }

        public double getPosRight() {
            return this.posRight;
        }

        @Override
        public void visitPoint(double x, double y) {
            this.bottom = Math.min(this.bottom, y);
            this.top = Math.max(this.top, y);
            this.visitLongitude(x);
        }

        @Override
        public void visitRectangle(double minX, double maxX, double maxY, double minY) {
            this.bottom = Math.min(this.bottom, minY);
            this.top = Math.max(this.top, maxY);
            this.visitLongitude(minX);
            this.visitLongitude(maxX);
        }

        private void visitLongitude(double x) {
            if (x >= 0.0) {
                this.posLeft = Math.min(this.posLeft, x);
                this.posRight = Math.max(this.posRight, x);
            } else {
                this.negLeft = Math.min(this.negLeft, x);
                this.negRight = Math.max(this.negRight, x);
            }
        }

        @Override
        public boolean isValid() {
            return this.bottom != Double.POSITIVE_INFINITY;
        }

        @Override
        public Rectangle getResult() {
            return GeoPointVisitor.getResult(this.top, this.bottom, this.negLeft, this.negRight, this.posLeft, this.posRight, this.wrapLongitude);
        }

        @Override
        public void reset() {
            this.bottom = Double.POSITIVE_INFINITY;
            this.top = Double.NEGATIVE_INFINITY;
            this.negLeft = Double.POSITIVE_INFINITY;
            this.negRight = Double.NEGATIVE_INFINITY;
            this.posLeft = Double.POSITIVE_INFINITY;
            this.posRight = Double.NEGATIVE_INFINITY;
        }

        public static Rectangle getResult(double top, double bottom, double negLeft, double negRight, double posLeft, double posRight, WrapLongitude wrapLongitude) {
            assert (Double.isFinite(top));
            if (posRight == Double.NEGATIVE_INFINITY) {
                return new Rectangle(negLeft, negRight, top, bottom);
            }
            if (negLeft == Double.POSITIVE_INFINITY) {
                return new Rectangle(posLeft, posRight, top, bottom);
            }
            return switch (wrapLongitude) {
                default -> throw new IncompatibleClassChangeError();
                case WrapLongitude.NO_WRAP -> new Rectangle(negLeft, posRight, top, bottom);
                case WrapLongitude.WRAP -> GeoPointVisitor.maybeWrap(top, bottom, negLeft, negRight, posLeft, posRight);
            };
        }

        private static Rectangle maybeWrap(double top, double bottom, double negLeft, double negRight, double posLeft, double posRight) {
            double unwrappedWidth = posRight - negLeft;
            double wrappedWidth = 360.0 + negRight - posLeft;
            return unwrappedWidth <= wrappedWidth ? new Rectangle(negLeft, posRight, top, bottom) : new Rectangle(posLeft, negRight, top, bottom);
        }
    }

    public static enum WrapLongitude {
        NO_WRAP,
        WRAP;

    }
}

