/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentSubParser;

public abstract class GenericPointParser<T> {
    private static final String X_FIELD = "x";
    private static final String Y_FIELD = "y";
    private static final String Z_FIELD = "z";
    private static final String TYPE = "type";
    private static final String COORDINATES = "coordinates";
    private final Map<String, FieldParser<?>> fields;
    private final String mapType;
    private final String xField;
    private final String yField;

    public GenericPointParser(String mapType, String xField, String yField) {
        this.mapType = mapType;
        this.xField = xField;
        this.yField = yField;
        this.fields = new LinkedHashMap();
        this.fields.put(xField, new DoubleFieldParser(X_FIELD, xField));
        this.fields.put(yField, new DoubleFieldParser(Y_FIELD, yField));
        this.fields.put(Z_FIELD, new DoubleFieldParser(Z_FIELD, Z_FIELD));
        this.fields.put(TYPE, new StringFieldParser(TYPE));
        this.fields.put(COORDINATES, new DoubleArrayFieldParser(COORDINATES));
    }

    public abstract void assertZValue(boolean var1, double var2);

    public abstract T createPoint(double var1, double var3);

    public abstract String fieldError();

    public T parsePoint(XContentParser parser, boolean ignoreZValue, Function<String, T> fromString) throws IOException, ElasticsearchParseException {
        double x = Double.NaN;
        double y = Double.NaN;
        String geojsonType = null;
        Object coordinates = null;
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            try (XContentSubParser subParser = new XContentSubParser(parser);){
                while (subParser.nextToken() != XContentParser.Token.END_OBJECT) {
                    if (subParser.currentToken() == XContentParser.Token.FIELD_NAME) {
                        String field = subParser.currentName();
                        subParser.nextToken();
                        FieldParser<?> fieldParser = this.fields.get(field);
                        if (fieldParser != null) {
                            switch (fieldParser.name) {
                                case "x": {
                                    x = (Double)fieldParser.parseField(subParser);
                                    break;
                                }
                                case "y": {
                                    y = (Double)fieldParser.parseField(subParser);
                                    break;
                                }
                                case "z": {
                                    this.assertZValue(ignoreZValue, (Double)fieldParser.parseField(subParser));
                                    break;
                                }
                                case "type": {
                                    geojsonType = (String)fieldParser.parseField(subParser);
                                    break;
                                }
                                case "coordinates": {
                                    coordinates = ((DoubleArrayFieldParser)fieldParser).parseField(subParser);
                                }
                            }
                            continue;
                        }
                        String fieldKeys = Strings.collectionToDelimitedString(this.fields.keySet(), ", ");
                        throw new ElasticsearchParseException("field [{}] not supported - must be one of: {}", field, fieldKeys);
                    }
                    throw new ElasticsearchParseException("token [{}] not allowed", new Object[]{subParser.currentToken()});
                }
            }
            this.assertOnlyOneFormat(!Double.isNaN(x), !Double.isNaN(y), coordinates != null, geojsonType != null);
            if (coordinates != null) {
                if (geojsonType == null || !geojsonType.toLowerCase(Locale.ROOT).equals("point")) {
                    throw new ElasticsearchParseException("[type] for {} can only be 'Point'", this.mapType);
                }
                if (coordinates.size() < 2) {
                    throw new ElasticsearchParseException("[coordinates] must contain at least two values", new Object[0]);
                }
                if (coordinates.size() == 3) {
                    this.assertZValue(ignoreZValue, (Double)coordinates.get(2));
                }
                if (coordinates.size() > 3) {
                    throw new ElasticsearchParseException("[{}] field type does not accept > 3 dimensions", this.mapType);
                }
                return this.createPoint((Double)coordinates.get(0), (Double)coordinates.get(1));
            }
            return this.createPoint(x, y);
        }
        if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
            try (XContentSubParser subParser = new XContentSubParser(parser);){
                int element = 0;
                while (subParser.nextToken() != XContentParser.Token.END_ARRAY) {
                    if (subParser.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                        if (++element == 1) {
                            x = subParser.doubleValue();
                            continue;
                        }
                        if (element == 2) {
                            y = subParser.doubleValue();
                            continue;
                        }
                        if (element == 3) {
                            this.assertZValue(ignoreZValue, subParser.doubleValue());
                            continue;
                        }
                        throw new ElasticsearchParseException("[{}] field type does not accept > 3 dimensions", this.mapType);
                    }
                    throw new ElasticsearchParseException("numeric value expected", new Object[0]);
                }
            }
            return this.createPoint(x, y);
        }
        if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
            return fromString.apply(parser.text());
        }
        throw new ElasticsearchParseException("{} expected", this.mapType);
    }

    private static double parseValidDouble(XContentSubParser subParser, String field) throws IOException {
        try {
            switch (subParser.currentToken()) {
                case VALUE_NUMBER: 
                case VALUE_STRING: {
                    break;
                }
                default: {
                    throw new ElasticsearchParseException("{} must be a number", field);
                }
            }
            return subParser.doubleValue(true);
        }
        catch (NumberFormatException e) {
            throw new ElasticsearchParseException("[{}] must be a valid double value", (Throwable)e, field);
        }
    }

    private void assertOnlyOneFormat(boolean x, boolean y, boolean coordinates, boolean type) {
        boolean geojson;
        boolean xy = x && y;
        boolean bl = geojson = coordinates && type;
        if (xy && geojson) {
            throw new ElasticsearchParseException("fields matching more than one point format", new Object[0]);
        }
        if (!(xy || geojson)) {
            if (x) {
                throw new ElasticsearchParseException("Required [{}]", this.yField);
            }
            if (y) {
                throw new ElasticsearchParseException("Required [{}]", this.xField);
            }
            if (coordinates) {
                throw new ElasticsearchParseException("Required [{}]", TYPE);
            }
            if (type) {
                throw new ElasticsearchParseException("Required [{}]", COORDINATES);
            }
            throw new ElasticsearchParseException(this.fieldError(), new Object[0]);
        }
    }

    private static class DoubleFieldParser
    extends FieldParser<Double> {
        final String description;

        private DoubleFieldParser(String name, String description) {
            super(name);
            this.description = switch (description) {
                case "lon" -> "longitude";
                case "lat" -> "latitude";
                default -> description;
            };
        }

        @Override
        Double parseField(XContentSubParser subParser) throws IOException {
            return GenericPointParser.parseValidDouble(subParser, this.description);
        }
    }

    private static class StringFieldParser
    extends FieldParser<String> {
        private StringFieldParser(String name) {
            super(name);
        }

        @Override
        String parseField(XContentSubParser subParser) throws IOException {
            if (subParser.currentToken() == XContentParser.Token.VALUE_STRING) {
                return subParser.text();
            }
            throw new ElasticsearchParseException("[{}] must be a string", this.name);
        }
    }

    private static class DoubleArrayFieldParser
    extends FieldParser<List<Double>> {
        private DoubleArrayFieldParser(String name) {
            super(name);
        }

        @Override
        List<Double> parseField(XContentSubParser subParser) throws IOException {
            if (subParser.currentToken() == XContentParser.Token.START_ARRAY) {
                ArrayList<Double> coordinates = new ArrayList<Double>();
                while (subParser.nextToken() != XContentParser.Token.END_ARRAY) {
                    coordinates.add(GenericPointParser.parseValidDouble(subParser, this.name));
                }
                return coordinates;
            }
            throw new ElasticsearchParseException("[{}] must be an array", this.name);
        }
    }

    private static abstract class FieldParser<T> {
        final String name;

        abstract T parseField(XContentSubParser var1) throws IOException;

        private FieldParser(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

