/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.health_report;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RepositoryIntegrityIndicatorDetails
implements JsonpSerializable {
    @Nullable
    private final Long totalRepositories;
    @Nullable
    private final Long corruptedRepositories;
    private final List<String> corrupted;
    public static final JsonpDeserializer<RepositoryIntegrityIndicatorDetails> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RepositoryIntegrityIndicatorDetails::setupRepositoryIntegrityIndicatorDetailsDeserializer);

    private RepositoryIntegrityIndicatorDetails(Builder builder) {
        this.totalRepositories = builder.totalRepositories;
        this.corruptedRepositories = builder.corruptedRepositories;
        this.corrupted = ApiTypeHelper.unmodifiable(builder.corrupted);
    }

    public static RepositoryIntegrityIndicatorDetails of(Function<Builder, ObjectBuilder<RepositoryIntegrityIndicatorDetails>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long totalRepositories() {
        return this.totalRepositories;
    }

    @Nullable
    public final Long corruptedRepositories() {
        return this.corruptedRepositories;
    }

    public final List<String> corrupted() {
        return this.corrupted;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.totalRepositories != null) {
            generator.writeKey("total_repositories");
            generator.write(this.totalRepositories);
        }
        if (this.corruptedRepositories != null) {
            generator.writeKey("corrupted_repositories");
            generator.write(this.corruptedRepositories);
        }
        if (ApiTypeHelper.isDefined(this.corrupted)) {
            generator.writeKey("corrupted");
            generator.writeStartArray();
            for (String item0 : this.corrupted) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRepositoryIntegrityIndicatorDetailsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::totalRepositories, JsonpDeserializer.longDeserializer(), "total_repositories");
        op.add(Builder::corruptedRepositories, JsonpDeserializer.longDeserializer(), "corrupted_repositories");
        op.add(Builder::corrupted, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "corrupted");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RepositoryIntegrityIndicatorDetails> {
        @Nullable
        private Long totalRepositories;
        @Nullable
        private Long corruptedRepositories;
        @Nullable
        private List<String> corrupted;

        public final Builder totalRepositories(@Nullable Long value) {
            this.totalRepositories = value;
            return this;
        }

        public final Builder corruptedRepositories(@Nullable Long value) {
            this.corruptedRepositories = value;
            return this;
        }

        public final Builder corrupted(List<String> list) {
            this.corrupted = Builder._listAddAll(this.corrupted, list);
            return this;
        }

        public final Builder corrupted(String value, String ... values) {
            this.corrupted = Builder._listAdd(this.corrupted, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RepositoryIntegrityIndicatorDetails build() {
            this._checkSingleUse();
            return new RepositoryIntegrityIndicatorDetails(this);
        }
    }
}

