/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PatternReplaceTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    @Nullable
    private final Boolean all;
    private final String pattern;
    @Nullable
    private final String replacement;
    public static final JsonpDeserializer<PatternReplaceTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PatternReplaceTokenFilter::setupPatternReplaceTokenFilterDeserializer);

    private PatternReplaceTokenFilter(Builder builder) {
        super(builder);
        this.all = builder.all;
        this.pattern = ApiTypeHelper.requireNonNull(builder.pattern, this, "pattern");
        this.replacement = builder.replacement;
    }

    public static PatternReplaceTokenFilter of(Function<Builder, ObjectBuilder<PatternReplaceTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.PatternReplace;
    }

    @Nullable
    public final Boolean all() {
        return this.all;
    }

    public final String pattern() {
        return this.pattern;
    }

    @Nullable
    public final String replacement() {
        return this.replacement;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "pattern_replace");
        super.serializeInternal(generator, mapper);
        if (this.all != null) {
            generator.writeKey("all");
            generator.write(this.all);
        }
        generator.writeKey("pattern");
        generator.write(this.pattern);
        if (this.replacement != null) {
            generator.writeKey("replacement");
            generator.write(this.replacement);
        }
    }

    protected static void setupPatternReplaceTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::all, JsonpDeserializer.booleanDeserializer(), "all");
        op.add(Builder::pattern, JsonpDeserializer.stringDeserializer(), "pattern");
        op.add(Builder::replacement, JsonpDeserializer.stringDeserializer(), "replacement");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PatternReplaceTokenFilter> {
        @Nullable
        private Boolean all;
        private String pattern;
        @Nullable
        private String replacement;

        public final Builder all(@Nullable Boolean value) {
            this.all = value;
            return this;
        }

        public final Builder pattern(String value) {
            this.pattern = value;
            return this;
        }

        public final Builder replacement(@Nullable String value) {
            this.replacement = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PatternReplaceTokenFilter build() {
            this._checkSingleUse();
            return new PatternReplaceTokenFilter(this);
        }
    }
}

