/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.DefaultInfo;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class ColumnDescriptor
extends TupleDescriptor {
    private DefaultInfo columnDefaultInfo;
    private TableDescriptor table;
    private String columnName;
    private int columnPosition;
    private DataTypeDescriptor columnType;
    private DataValueDescriptor columnDefault;
    private UUID uuid;
    private UUID defaultUUID;
    private long autoincStart;
    private long autoincInc;
    private long autoincValue;
    private boolean autoincCycle;
    long autoinc_create_or_modify_Start_Increment = -1L;

    public ColumnDescriptor(String columnName, int columnPosition, DataTypeDescriptor columnType, DataValueDescriptor columnDefault, DefaultInfo columnDefaultInfo, TableDescriptor table, UUID defaultUUID, long autoincStart, long autoincInc, long userChangedWhat, boolean autoincCycle) {
        this(columnName, columnPosition, columnType, columnDefault, columnDefaultInfo, table, defaultUUID, autoincStart, autoincInc, autoincCycle);
        this.autoinc_create_or_modify_Start_Increment = userChangedWhat;
    }

    public ColumnDescriptor(String columnName, int columnPosition, DataTypeDescriptor columnType, DataValueDescriptor columnDefault, DefaultInfo columnDefaultInfo, TableDescriptor table, UUID defaultUUID, long autoincStart, long autoincInc, boolean autoincCycle) {
        this.columnName = columnName;
        this.columnPosition = columnPosition;
        this.columnType = columnType;
        this.columnDefault = columnDefault;
        this.columnDefaultInfo = columnDefaultInfo;
        this.defaultUUID = defaultUUID;
        if (table != null) {
            this.table = table;
            this.uuid = table.getUUID();
        }
        ColumnDescriptor.assertAutoinc(autoincInc != 0L, autoincInc, columnDefaultInfo);
        this.autoincStart = autoincStart;
        this.autoincValue = autoincStart;
        this.autoincInc = autoincInc;
        this.autoincCycle = autoincCycle;
    }

    public ColumnDescriptor(String columnName, int columnPosition, DataTypeDescriptor columnType, DataValueDescriptor columnDefault, DefaultInfo columnDefaultInfo, UUID uuid, UUID defaultUUID, long autoincStart, long autoincInc, long autoincValue, boolean autoincCycle) {
        this.columnName = columnName;
        this.columnPosition = columnPosition;
        this.columnType = columnType;
        this.columnDefault = columnDefault;
        this.columnDefaultInfo = columnDefaultInfo;
        this.uuid = uuid;
        this.defaultUUID = defaultUUID;
        ColumnDescriptor.assertAutoinc(autoincInc != 0L, autoincInc, columnDefaultInfo);
        this.autoincStart = autoincStart;
        this.autoincValue = autoincValue;
        this.autoincInc = autoincInc;
        this.autoincCycle = autoincCycle;
    }

    public UUID getReferencingUUID() {
        return this.uuid;
    }

    public TableDescriptor getTableDescriptor() {
        return this.table;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String newColumnName) {
        this.columnName = newColumnName;
    }

    public void setTableDescriptor(TableDescriptor tableDescriptor) {
        this.table = tableDescriptor;
    }

    public int getPosition() {
        return this.columnPosition;
    }

    public DataTypeDescriptor getType() {
        return this.columnType;
    }

    public boolean hasNonNullDefault() {
        if (this.columnDefault != null && !this.columnDefault.isNull()) {
            return true;
        }
        return this.columnDefaultInfo != null;
    }

    public DataValueDescriptor getDefaultValue() {
        return this.columnDefault;
    }

    public DefaultInfo getDefaultInfo() {
        return this.columnDefaultInfo;
    }

    public UUID getDefaultUUID() {
        return this.defaultUUID;
    }

    public DefaultDescriptor getDefaultDescriptor(DataDictionary dd) {
        DefaultDescriptor defaultDescriptor = null;
        if (this.defaultUUID != null) {
            defaultDescriptor = new DefaultDescriptor(dd, this.defaultUUID, this.uuid, this.columnPosition);
        }
        return defaultDescriptor;
    }

    public boolean isAutoincrement() {
        return this.autoincInc != 0L;
    }

    public boolean updatableByCursor() {
        return false;
    }

    public boolean hasGenerationClause() {
        if (this.columnDefaultInfo == null) {
            return false;
        }
        return this.columnDefaultInfo.isGeneratedColumn();
    }

    public boolean isAutoincAlways() {
        return this.columnDefaultInfo == null && this.isAutoincrement();
    }

    public long getAutoincStart() {
        return this.autoincStart;
    }

    public boolean getAutoincCycle() {
        return this.autoincCycle;
    }

    public long getAutoincInc() {
        return this.autoincInc;
    }

    public long getAutoincValue() {
        return this.autoincValue;
    }

    public long getAutoinc_create_or_modify_Start_Increment() {
        return this.autoinc_create_or_modify_Start_Increment;
    }

    public void setAutoinc_create_or_modify_Start_Increment(int c_or_m) {
        this.autoinc_create_or_modify_Start_Increment = c_or_m;
    }

    public void setPosition(int columnPosition) {
        this.columnPosition = columnPosition;
    }

    public String toString() {
        return "columnName: " + this.columnName + "\ncolumnPosition: " + this.columnPosition + "\ncolumnType: " + String.valueOf(this.columnType) + "\ncolumnDefault: " + String.valueOf(this.columnDefault) + "\nuuid: " + String.valueOf(this.uuid) + "\ndefaultUUID: " + String.valueOf(this.defaultUUID);
    }

    @Override
    public String getDescriptorName() {
        return this.columnName;
    }

    @Override
    public String getDescriptorType() {
        return "Column";
    }

    private static void assertAutoinc(boolean autoinc, long autoincInc, DefaultInfo defaultInfo) {
        if (autoinc) {
            SanityManager.ASSERT((autoincInc != 0L ? 1 : 0) != 0, (String)"increment is zero for  autoincrement column");
            SanityManager.ASSERT((defaultInfo == null || defaultInfo.isDefaultValueAutoinc() ? 1 : 0) != 0, (String)"If column is autoinc and have defaultInfo, isDefaultValueAutoinc must be true.");
        } else {
            SanityManager.ASSERT((autoincInc == 0L ? 1 : 0) != 0, (String)"increment is non-zero for non-autoincrement column");
            SanityManager.ASSERT((defaultInfo == null || !defaultInfo.isDefaultValueAutoinc() ? 1 : 0) != 0, (String)"If column is not autoinc and have defaultInfo, isDefaultValueAutoinc can not be true");
        }
    }
}

