/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.filters;

import co.elastic.logstash.api.Configuration;
import co.elastic.logstash.api.Context;
import co.elastic.logstash.api.Event;
import co.elastic.logstash.api.Filter;
import co.elastic.logstash.api.FilterMatchListener;
import co.elastic.logstash.api.LogstashPlugin;
import co.elastic.logstash.api.PluginConfigSpec;
import co.elastic.logstash.api.PluginHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;

@LogstashPlugin(name="java_uuid")
public class Uuid
implements Filter {
    public static final PluginConfigSpec<String> TARGET_CONFIG = PluginConfigSpec.requiredStringSetting("target");
    public static final PluginConfigSpec<Boolean> OVERWRITE_CONFIG = PluginConfigSpec.booleanSetting("overwrite", false);
    private String id;
    private String target;
    private boolean overwrite;

    public Uuid(String id, Configuration configuration, Context context) {
        this.id = id;
        this.target = configuration.get(TARGET_CONFIG);
        this.overwrite = configuration.get(OVERWRITE_CONFIG);
    }

    @Override
    public Collection<Event> filter(Collection<Event> events, FilterMatchListener filterMatchListener) {
        for (Event e : events) {
            if (this.overwrite || e.getField(this.target) == null) {
                e.setField(this.target, UUID.randomUUID().toString());
            }
            filterMatchListener.filterMatched(e);
        }
        return events;
    }

    @Override
    public Collection<PluginConfigSpec<?>> configSchema() {
        return PluginHelper.commonFilterSettings(Arrays.asList(TARGET_CONFIG, OVERWRITE_CONFIG));
    }

    @Override
    public String getId() {
        return this.id;
    }
}

