# frozen_string_literal: true

class Views::SharedTogo::AcceptInvite < ::Views::Base
  needs(:invitation)
  needs(:invitation_code_param)

  def content
    h2(:class => 'euiTitle euiTitle--medium auth-container__title') do
      text 'Create an account to accept your invitation.'
    end
    div(:class => 'euiSpacer euiSpacer--l')
    div(:class => 'auth-container__error', :style => 'display: none;', :'data-type' => 'inline') do
      div(:class => 'euiCallOut euiCallOut--danger') do
        div(:class => 'euiCallOutHeader') do
          eui_icon(:close, :class => 'uiIcon euiIcon--medium euiCallOutHeader__icon')
          span('Authentication has failed', :class => 'euiCallOutHeader__title')
        end
        div(:class => 'euiText euiText--small') do
          p('Please try connecting again', :class => 'auth_failed_description')
        end
      end
      div(:class => 'euiSpacer euiSpacer--l')
    end
    div(:class => 'euiForm') do
      form_tag({}, :method => :post, :class => 'auth-container__form') do
        div(:class => 'euiFormRow euiFormRow--fullWidth') do
          label('Username', :class => 'euiFormLabel', :for => 'username')
          div(:class => 'euiFormControlLayout euiFormControlLayout--fullWidth') do
            div(:class => 'euiFormControlLayout__childrenWrapper') do
              text_field_tag(:username, invitation.invitee_username, :id => 'username', :class => 'euiFieldText euiFieldText--fullWidth', :disabled => true)
            end
          end
        end
        div(:class => 'euiFormRow euiFormRow--fullWidth') do
          label('Password', :class => 'euiFormLabel', :for => 'password')
          div(:class => 'euiFormControlLayout euiFormControlLayout--fullWidth') do
            div(:class => 'euiFormControlLayout__childrenWrapper') do
              password_field_tag(:password, '', :'data-test-subj' => 'AcceptInvitationPasswordInput', :id => 'password', :class => 'euiFieldPassword euiFieldPassword--fullWidth', :autofocus => true)
              div(:class => 'euiFormControlLayoutIcons') do
                span(:class => 'euiFormControlLayoutCustomIcon') do
                  eui_icon(:lock, :class => 'euiIcon euiIcon--medium euiFormControlLayoutCustomIcon__icon')
                end
              end
            end
          end
        end
        div(:class => 'euiSpacer euiSpacer--xxl')
        div(:class => 'euiFlexGroup') do
          div(:class => 'euiFlexItem') do
            button(:type => 'submit', :'data-test-subj' => 'AcceptInvitationSubmitButton', :id => 'auth_submit', :class => 'euiButton euiButton--primary euiButton--fill') do
              span(:class => 'euiButtonContent euiButton__content') do
                span('Accept Invitation', :class => 'euiButton__text')
              end
            end
          end
        end
      end
    end

    javascript <<-JAVASCRIPT
    document.addEventListener('DOMContentLoaded', () => {
      const form = document.getElementsByClassName('auth-container__form')[0];
      const submitBtn = document.getElementById('auth_submit');
      const successRedirectUrl = '/';

      const toggleErrorVisiblity = (show) => document.querySelectorAll('.auth-container__error')[0].style.display = show ? 'block' : 'none'

      form.addEventListener('submit', async (event) => {
        event.preventDefault();
        event.stopPropagation();

        const baseParams = {
          user: {
            password: document.getElementById('password').value
          }
        };

        const originalSubmitBtnHtml = submitBtn.innerHTML;
        const params = { ...baseParams, ...#{safe_javascript_literal(invitation_code_param => invitation.code)} }

        toggleErrorVisiblity(false);
        submitBtn.classList.add('auth-button--loading');
        submitBtn.getElementsByClassName('euiButton__text')[0].innerText = 'Signing in...';

        const handleError = (error) => {
          document.getElementsByClassName('auth_failed_description')[0].innerText = error ? error : 'Please try connecting again';
          toggleErrorVisiblity(true);
          submitBtn.classList.remove('auth-button--loading');
          submitBtn.innerHTML = originalSubmitBtnHtml;
        }

        try {
          const config = {
            method: 'POST',
            body: JSON.stringify(params),
            headers: {
              'Accept': '*/*',
              'Content-Type': 'application/json',
              'X-CSRF-Token': document.querySelector('meta[name="csrf-token"]').content
            }
          }
          const response = await fetch(#{safe_javascript_literal(authenticate_accept_invitation_url)}, config)
          const formattedResponse = response.ok ? await response.json() : await response.text()

          if (response.ok) {
            window.location = formattedResponse.redirect_url || successRedirectUrl;
          } else {
            handleError(formattedResponse)
          }
        } catch (error) {
          handleError(error)
        }
      });
    });
    JAVASCRIPT
  end
end
