# frozen_string_literal: true

module Actastic
  module Diagnostics
    extend ActiveSupport::Concern

    included do
      class_attribute :diagnostic_fields
    end

    class_methods do
      def include_fields_in_diagnostics(*fields)
        self.diagnostic_fields = fields.flatten.compact.map(&:to_sym)
      end
    end

    def to_diagnostics
      HashWithIndifferentAccess.new.tap do |res|
        diagnostic_fields&.each do |field|
          value = public_send(field)
          res[field] = to_diagnostics_value(value)
        end
      end
    end

    def to_diagnostics_value(value)
      if value.respond_to?(:to_diagnostics)
        value.to_diagnostics
      elsif value.kind_of?(Array) || value.kind_of?(Relation)
        value.map { |v| to_diagnostics_value(v) }
      elsif value.kind_of?(Hash)
        {}.tap do |result|
          value.each do |key, val|
            result[key.to_s] = to_diagnostics_value(val)
          end
        end
      elsif value.nil? || value.is_a?(Boolean) || value.kind_of?(Numeric)
        value
      else
        value.to_s
      end
    end
  end
end
