/*
 * Decompiled with CFR 0.152.
 */
package com.fortituderuby.ext.fortitude;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyNil;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;

public class FortitudeNativeLibrary
implements Library {
    public static final int BUFFER_SIZE = 256;
    static Ruby runtime;

    public void load(Ruby theRuntime, boolean wrap) throws IOException {
        runtime = theRuntime;
        RubyClass stringClass = runtime.getClass("String");
        stringClass.defineAnnotatedMethod(FortitudeStringExtensions.class, "fortitude_append_escaped_string");
        RubyClass hashClass = runtime.getClass("Hash");
        hashClass.defineAnnotatedMethod(FortitudeHashExtensions.class, "fortitude_append_as_attributes");
    }

    public static class FortitudeHashExtensions {
        public static final byte SPACE = 32;

        public static void fortitude_append_to(IRubyObject object, RubyString rbOutput, boolean forAttributeValue) {
            if (object instanceof RubyString) {
                FortitudeStringExtensions.fortitude_escaped_strcpy(rbOutput, ((RubyString)object).getBytes(), forAttributeValue);
            } else if (object instanceof RubySymbol) {
                FortitudeStringExtensions.fortitude_escaped_strcpy(rbOutput, ((RubyString)((RubySymbol)object).to_s()).getBytes(), forAttributeValue);
            } else if (object instanceof RubyArray) {
                RubyArray array = (RubyArray)object;
                for (int i = 0; i < array.getLength(); ++i) {
                    IRubyObject element = array.entry(i);
                    if (i > 0) {
                        rbOutput.cat((byte)32);
                    }
                    FortitudeHashExtensions.fortitude_append_to(element, rbOutput, forAttributeValue);
                }
            } else if (!(object instanceof RubyNil)) {
                if (object instanceof RubyFixnum) {
                    RubyString asString = ((RubyFixnum)object).to_s();
                    FortitudeStringExtensions.fortitude_escaped_strcpy(rbOutput, asString.getBytes(), forAttributeValue);
                } else {
                    RubyString asString = (RubyString)((RubyBasicObject)object).callMethod("to_s");
                    FortitudeStringExtensions.fortitude_escaped_strcpy(rbOutput, asString.getBytes(), forAttributeValue);
                }
            }
        }

        @JRubyMethod(name={"fortitude_append_as_attributes"})
        public static IRubyObject fortitude_append_as_attributes(ThreadContext context, IRubyObject self, IRubyObject output, IRubyObject prefix, IRubyObject allowsBareAttributes) {
            if (!(output instanceof RubyString)) {
                RaiseException exception = runtime.newArgumentError("You can only append to a String (this is a native (Java) method)");
                throw exception;
            }
            if (prefix instanceof RubyNil) {
                prefix = null;
            }
            if (prefix != null && !(prefix instanceof RubyString)) {
                RaiseException exception = runtime.newArgumentError("You can only use a prefix that is a String (this is a native (Java) method)");
                throw exception;
            }
            AppendKeyAndValueVisitor visitor = new AppendKeyAndValueVisitor(context, (RubyString)prefix, (RubyString)output, (RubyBoolean)allowsBareAttributes);
            ((RubyHash)self).visitAll((RubyHash.Visitor)visitor);
            return runtime.getNil();
        }

        public static class AppendKeyAndValueVisitor
        extends RubyHash.Visitor {
            public final ThreadContext threadContext;
            public final RubyString prefix;
            public final RubyString output;
            public final RubyBoolean allowsBareAttributes;
            public static final byte[] EQUALS_QUOTE = new byte[]{61, 34};

            public AppendKeyAndValueVisitor(ThreadContext threadContext, RubyString prefix, RubyString output, RubyBoolean allowsBareAttributes) {
                this.threadContext = threadContext;
                this.prefix = prefix;
                this.output = output;
                this.allowsBareAttributes = allowsBareAttributes;
            }

            public void visit(IRubyObject key, IRubyObject value) {
                if (value instanceof RubyHash) {
                    RubyString newPrefix;
                    if (this.prefix != null) {
                        newPrefix = (RubyString)this.prefix.dup();
                        FortitudeHashExtensions.fortitude_append_to(key, newPrefix, false);
                    } else {
                        newPrefix = RubyString.newEmptyString((Ruby)runtime);
                        FortitudeHashExtensions.fortitude_append_to(key, newPrefix, false);
                    }
                    newPrefix.cat(45);
                    FortitudeHashExtensions.fortitude_append_as_attributes(this.threadContext, value, (IRubyObject)this.output, (IRubyObject)newPrefix, (IRubyObject)this.allowsBareAttributes);
                } else if (!(value instanceof RubyNil || value instanceof RubyBoolean && !value.isTrue())) {
                    this.output.cat(32);
                    if (this.prefix != null) {
                        this.output.cat(this.prefix);
                    }
                    FortitudeHashExtensions.fortitude_append_to(key, this.output, false);
                    if (value instanceof RubyBoolean && value.isTrue()) {
                        if (!this.allowsBareAttributes.isTrue()) {
                            this.output.cat(EQUALS_QUOTE);
                            FortitudeHashExtensions.fortitude_append_to(key, this.output, false);
                            this.output.cat(34);
                        }
                    } else {
                        this.output.cat(EQUALS_QUOTE);
                        FortitudeHashExtensions.fortitude_append_to(value, this.output, true);
                        this.output.cat(34);
                    }
                }
            }
        }
    }

    public static class FortitudeStringExtensions {
        public static final int MAX_SUBSTITUTION_LENGTH = 6;
        public static final byte AMPERSAND_BYTE = 38;
        public static final byte LESS_THAN_BYTE = 60;
        public static final byte GREATER_THAN_BYTE = 62;
        public static final byte SINGLE_QUOTE_BYTE = 39;
        public static final byte DOUBLE_QUOTE_BYTE = 34;

        @JRubyMethod(name={"fortitude_append_escaped_string"})
        public static IRubyObject fortitude_append_escaped_string(ThreadContext context, IRubyObject self, IRubyObject output) {
            if (!(output instanceof RubyString)) {
                RaiseException exception = runtime.newArgumentError("You can only append to a String (this is a native (Java) method)");
                throw exception;
            }
            RubyString selfString = (RubyString)self;
            RubyString outputString = (RubyString)output;
            IRubyObject htmlSafe = selfString.getInstanceVariable("@html_safe");
            if (htmlSafe != null && htmlSafe.isTrue()) {
                outputString.cat(selfString);
            } else {
                byte[] selfBytes = selfString.getBytes();
                FortitudeStringExtensions.fortitude_escaped_strcpy(outputString, selfBytes, false);
            }
            return runtime.getNil();
        }

        public static void fortitude_escaped_strcpy(RubyString output, byte[] source, boolean forAttributeValue) {
            byte[] buffer = new byte[256];
            int bufferPos = 0;
            block7: for (int i = 0; i < source.length; ++i) {
                if (bufferPos > 250) {
                    output.cat(buffer, 0, bufferPos);
                    bufferPos = 0;
                }
                byte sourceByte = source[i];
                switch (sourceByte) {
                    case 38: {
                        buffer[bufferPos++] = 38;
                        buffer[bufferPos++] = 97;
                        buffer[bufferPos++] = 109;
                        buffer[bufferPos++] = 112;
                        buffer[bufferPos++] = 59;
                        continue block7;
                    }
                    case 34: {
                        buffer[bufferPos++] = 38;
                        buffer[bufferPos++] = 113;
                        buffer[bufferPos++] = 117;
                        buffer[bufferPos++] = 111;
                        buffer[bufferPos++] = 116;
                        buffer[bufferPos++] = 59;
                        continue block7;
                    }
                    case 60: {
                        if (forAttributeValue) {
                            buffer[bufferPos++] = 60;
                            continue block7;
                        }
                        buffer[bufferPos++] = 38;
                        buffer[bufferPos++] = 108;
                        buffer[bufferPos++] = 116;
                        buffer[bufferPos++] = 59;
                        continue block7;
                    }
                    case 62: {
                        if (forAttributeValue) {
                            buffer[bufferPos++] = 62;
                            continue block7;
                        }
                        buffer[bufferPos++] = 38;
                        buffer[bufferPos++] = 103;
                        buffer[bufferPos++] = 116;
                        buffer[bufferPos++] = 59;
                        continue block7;
                    }
                    case 39: {
                        if (forAttributeValue) {
                            buffer[bufferPos++] = 39;
                            continue block7;
                        }
                        buffer[bufferPos++] = 38;
                        buffer[bufferPos++] = 35;
                        buffer[bufferPos++] = 51;
                        buffer[bufferPos++] = 57;
                        buffer[bufferPos++] = 59;
                        continue block7;
                    }
                    default: {
                        buffer[bufferPos++] = sourceByte;
                    }
                }
            }
            if (bufferPos > 0) {
                output.cat(buffer, 0, bufferPos);
            }
        }
    }
}

