/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.converters;

import jnr.ffi.mapper.ToNativeContext;
import jnr.ffi.mapper.ToNativeConverter;
import jnr.ffi.provider.ParameterFlags;

@ToNativeConverter.NoContext
@ToNativeConverter.Cacheable
public class Long32ArrayParameterConverter
implements ToNativeConverter<long[], int[]> {
    private static final Long32ArrayParameterConverter IN = new Long32ArrayParameterConverter(2);
    private static final Long32ArrayParameterConverter OUT = new Out(1);
    private static final Long32ArrayParameterConverter INOUT = new Out(3);
    private final int parameterFlags;

    public static ToNativeConverter<long[], int[]> getInstance(ToNativeContext toNativeContext) {
        int parameterFlags = ParameterFlags.parse(toNativeContext.getAnnotations());
        return ParameterFlags.isOut(parameterFlags) ? (ParameterFlags.isIn(parameterFlags) ? INOUT : OUT) : IN;
    }

    private Long32ArrayParameterConverter(int parameterFlags) {
        this.parameterFlags = parameterFlags;
    }

    @Override
    public int[] toNative(long[] array2, ToNativeContext context) {
        if (array2 == null) {
            return null;
        }
        int[] primitive = new int[array2.length];
        if (ParameterFlags.isIn(this.parameterFlags)) {
            for (int i2 = 0; i2 < array2.length; ++i2) {
                primitive[i2] = (int)array2[i2];
            }
        }
        return primitive;
    }

    @Override
    public Class<int[]> nativeType() {
        return int[].class;
    }

    public static final class Out
    extends Long32ArrayParameterConverter
    implements ToNativeConverter.PostInvocation<long[], int[]> {
        Out(int parameterFlags) {
            super(parameterFlags);
        }

        @Override
        public void postInvoke(long[] array2, int[] primitive, ToNativeContext context) {
            if (array2 != null && primitive != null) {
                for (int i2 = 0; i2 < array2.length; ++i2) {
                    array2[i2] = primitive[i2];
                }
            }
        }
    }
}

