/*
 * Decompiled with CFR 0.152.
 */
package gson_ext;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.AbstractCollection;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.stringio.RubyStringIO;
import org.jruby.java.addons.IOJavaAddons;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Gson::Decoder"})
public class Decoder
extends RubyObject {
    static final long serialVersionUID = 2328444027137249699L;
    private boolean lenient = true;
    private boolean symbolizeKeys = false;
    private static Pattern floatPattern = Pattern.compile("[.eE]");

    public Decoder(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @JRubyMethod(name={"lenient?"})
    public IRubyObject isLenient(ThreadContext threadContext) {
        return RubyBoolean.newBoolean((Ruby)threadContext.getRuntime(), (boolean)this.lenient);
    }

    @JRubyMethod(name={"symbolize_keys?"})
    public IRubyObject isSymbolizeKeys(ThreadContext threadContext) {
        return RubyBoolean.newBoolean((Ruby)threadContext.getRuntime(), (boolean)this.symbolizeKeys);
    }

    @JRubyMethod(optional=1)
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        Ruby ruby = threadContext.getRuntime();
        if (iRubyObjectArray.length < 1) {
            return threadContext.nil;
        }
        if (!(iRubyObjectArray[0] instanceof RubyHash)) {
            throw ruby.newArgumentError("expected Hash for options argument");
        }
        RubyHash rubyHash = (RubyHash)iRubyObjectArray[0];
        RubySymbol rubySymbol = ruby.newSymbol("lenient");
        if (rubyHash.containsKey((Object)rubySymbol)) {
            this.lenient = rubyHash.op_aref(threadContext, (IRubyObject)rubySymbol).isTrue();
        }
        if (rubyHash.containsKey((Object)(rubySymbol = ruby.newSymbol("symbolize_keys")))) {
            this.symbolizeKeys = rubyHash.op_aref(threadContext, (IRubyObject)rubySymbol).isTrue();
        }
        return threadContext.nil;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JRubyMethod
    public IRubyObject decode(ThreadContext threadContext, IRubyObject iRubyObject) {
        Object object;
        Reader reader;
        Ruby ruby = threadContext.getRuntime();
        if (iRubyObject instanceof RubyString) {
            reader = new StringReader(iRubyObject.toString());
        } else {
            if (!(iRubyObject instanceof RubyIO) && !(iRubyObject instanceof RubyStringIO)) {
                throw ruby.newArgumentError("Unsupported source. This method accepts String or IO");
            }
            object = IOJavaAddons.AnyIO.any_to_inputstream((ThreadContext)threadContext, (IRubyObject)iRubyObject);
            reader = new InputStreamReader((InputStream)object.toJava(InputStream.class));
        }
        object = new LinkedList();
        LinkedList<IRubyObject> linkedList = new LinkedList<IRubyObject>();
        JsonReader jsonReader = new JsonReader(reader);
        jsonReader.setLenient(this.lenient);
        try {
            JsonToken jsonToken;
            block24: while (true) {
                jsonToken = jsonReader.peek();
                switch (jsonToken) {
                    case END_ARRAY: {
                        jsonReader.endArray();
                        Object object2 = (IRubyObject)((LinkedList)object).pop();
                        if (!((AbstractCollection)object).isEmpty()) continue block24;
                        linkedList.add((IRubyObject)object2);
                        continue block24;
                    }
                    case END_OBJECT: {
                        jsonReader.endObject();
                        Object object2 = (IRubyObject)((LinkedList)object).pop();
                        if (!((AbstractCollection)object).isEmpty()) continue block24;
                        linkedList.add((IRubyObject)object2);
                        continue block24;
                    }
                    case NAME: {
                        Object object2 = this.symbolizeKeys ? RubySymbol.newSymbol((Ruby)ruby, (String)jsonReader.nextName()) : RubyString.newString((Ruby)ruby, (String)jsonReader.nextName());
                        ((LinkedList)object).push(object2);
                        continue block24;
                    }
                    case BEGIN_ARRAY: 
                    case BEGIN_OBJECT: 
                    case STRING: 
                    case NUMBER: 
                    case BOOLEAN: 
                    case NULL: {
                        Object object2;
                        IRubyObject iRubyObject2 = (IRubyObject)((LinkedList)object).peek();
                        switch (jsonToken) {
                            case BEGIN_ARRAY: {
                                jsonReader.beginArray();
                                object2 = RubyArray.newArray((Ruby)ruby);
                                break;
                            }
                            case BEGIN_OBJECT: {
                                jsonReader.beginObject();
                                object2 = RubyHash.newHash((Ruby)ruby);
                                break;
                            }
                            case STRING: {
                                object2 = RubyString.newString((Ruby)ruby, (String)jsonReader.nextString());
                                break;
                            }
                            case NUMBER: {
                                String string = jsonReader.nextString();
                                if (floatPattern.matcher(string).find()) {
                                    object2 = RubyNumeric.str2fnum((Ruby)ruby, (RubyString)RubyString.newString((Ruby)ruby, (String)string));
                                    break;
                                }
                                object2 = RubyNumeric.str2inum((Ruby)ruby, (RubyString)RubyString.newString((Ruby)ruby, (String)string), (int)10);
                                break;
                            }
                            case BOOLEAN: {
                                object2 = RubyBoolean.newBoolean((Ruby)ruby, (boolean)jsonReader.nextBoolean());
                                break;
                            }
                            case NULL: {
                                jsonReader.nextNull();
                                object2 = threadContext.nil;
                                break;
                            }
                            default: {
                                throw DecodeError.newDecodeError(ruby, String.format("Unknown token: %s", jsonToken.toString()));
                            }
                        }
                        if (iRubyObject2 instanceof RubyString || iRubyObject2 instanceof RubySymbol) {
                            IRubyObject iRubyObject3 = (IRubyObject)((LinkedList)object).pop();
                            RubyHash rubyHash = (RubyHash)((LinkedList)object).peek();
                            rubyHash.op_aset(threadContext, iRubyObject3, object2);
                        } else if (iRubyObject2 instanceof RubyArray) {
                            RubyArray rubyArray = (RubyArray)((LinkedList)object).peek();
                            rubyArray.append(object2);
                        }
                        switch (jsonToken) {
                            case BEGIN_ARRAY: 
                            case BEGIN_OBJECT: {
                                ((LinkedList)object).push(object2);
                                continue block24;
                            }
                        }
                        if (iRubyObject2 != null) continue block24;
                        linkedList.add((IRubyObject)object2);
                        continue block24;
                    }
                    case END_DOCUMENT: {
                        switch (linkedList.size()) {
                            case 0: {
                                return threadContext.nil;
                            }
                            case 1: {
                                return (IRubyObject)linkedList.pop();
                            }
                        }
                        return ruby.newArray(linkedList);
                    }
                }
                break;
            }
            throw DecodeError.newDecodeError(ruby, String.format("Unknown token: %s", jsonToken.toString()));
        }
        catch (Exception exception) {
            throw DecodeError.newDecodeError(ruby, exception.getMessage());
        }
    }

    @JRubyClass(name={"Gson::DecodeError"}, parent="StandardError")
    public static class DecodeError {
        public static RaiseException newDecodeError(Ruby ruby, String string) {
            RubyClass rubyClass = ruby.getModule("Gson").getClass("DecodeError");
            return new RaiseException(RubyException.newException((Ruby)ruby, (RubyClass)rubyClass, (String)string), true);
        }
    }
}

