/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack.util;

import java.io.IOException;
import org.jruby.NativeException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class ExceptionUtils {
    public static RaiseException wrapException(Ruby runtime, Exception cause) {
        if (cause instanceof RaiseException) {
            return (RaiseException)cause;
        }
        NativeException nativeException = new NativeException(runtime, runtime.getNativeException(), (Throwable)cause);
        return new RaiseException((Throwable)cause, nativeException);
    }

    public static RaiseException newRuntimeError(Ruby runtime, Throwable cause) {
        return ExceptionUtils.newRaiseException(runtime, runtime.getRuntimeError(), cause);
    }

    public static RaiseException newArgumentError(Ruby runtime, RuntimeException cause) {
        return ExceptionUtils.newRaiseException(runtime, runtime.getArgumentError(), cause);
    }

    public static RaiseException newIOError(Ruby runtime, IOException cause) {
        RaiseException raise = runtime.newIOErrorFromException(cause);
        raise.initCause((Throwable)cause);
        return raise;
    }

    static RaiseException newRaiseException(Ruby runtime, RubyClass errorClass, String message) {
        return new RaiseException(runtime, errorClass, message, true);
    }

    private static RaiseException newRaiseException(Ruby runtime, RubyClass errorClass, Throwable cause) {
        String message = cause.getMessage();
        RaiseException raise = new RaiseException(runtime, errorClass, message, true);
        raise.initCause(cause);
        return raise;
    }

    public static CharSequence formatError(RubyException error) {
        StringBuilder out = new StringBuilder(128);
        ExceptionUtils.appendError(error, out);
        return out;
    }

    private static void appendInspect(RubyException error, StringBuilder out) {
        RubyClass errorClass = error.getMetaClass().getRealClass();
        if (error.getMessage() != null && !error.getMessage().isNil()) {
            out.append("#<").append(errorClass.getName()).append(": ");
            out.append((CharSequence)error.getMessage().asString()).append('>');
        } else {
            out.append(errorClass.getName());
        }
    }

    public static void appendError(RubyException error, StringBuilder out) {
        ExceptionUtils.appendInspect(error, out);
        ExceptionUtils.appendBacktrace(error, out.append('\n'));
    }

    public static void appendBacktrace(RubyException error, StringBuilder out) {
        ExceptionUtils.appendBacktrace(error, 0, out);
    }

    public static void appendBacktrace(RubyException error, int skip, StringBuilder out) {
        ThreadContext context = error.getRuntime().getCurrentContext();
        IRubyObject backtrace = error.callMethod(context, "backtrace");
        if (!backtrace.isNil()) {
            RubyArray trace = backtrace.convertToArray();
            out.ensureCapacity(out.length() + 24 * trace.getLength());
            for (int i = skip; i < trace.getLength(); ++i) {
                IRubyObject stackTraceLine = trace.eltInternal(i);
                if (!(stackTraceLine instanceof RubyString)) continue;
                out.append("\tfrom ").append(stackTraceLine).append('\n');
            }
        }
    }
}

