/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack.logging;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jruby.rack.RackLogger;

public class JulLogger
extends RackLogger.Base {
    private Logger logger;

    public JulLogger() {
        this.setLoggerName("");
    }

    public JulLogger(String loggerName) {
        this.setLoggerName(loggerName);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setLoggerName(String loggerName) {
        this.logger = Logger.getLogger(loggerName);
    }

    @Override
    public boolean isEnabled(RackLogger.Level level) {
        if (level == null) {
            return this.logger.isLoggable(Level.INFO);
        }
        return this.logger.isLoggable(JulLogger.mapLevel(level, Level.ALL));
    }

    @Override
    public void log(RackLogger.Level level, String message) {
        this.logger.log(JulLogger.mapLevel(level, Level.INFO), message);
    }

    @Override
    public void log(RackLogger.Level level, String message, Throwable e) {
        this.logger.log(JulLogger.mapLevel(level, Level.SEVERE), message, e);
    }

    private static Level mapLevel(RackLogger.Level level, Level defaultLevel) {
        if (level == null) {
            return defaultLevel;
        }
        switch (level) {
            case DEBUG: {
                return Level.FINE;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARN: {
                return Level.WARNING;
            }
            case ERROR: {
                return Level.SEVERE;
            }
            case FATAL: {
                return Level.SEVERE;
            }
        }
        return defaultLevel;
    }

    @Override
    public RackLogger.Level getLevel() {
        if (this.logger.isLoggable(Level.FINE)) {
            return RackLogger.Level.DEBUG;
        }
        if (this.logger.isLoggable(Level.INFO)) {
            return RackLogger.Level.INFO;
        }
        if (this.logger.isLoggable(Level.WARNING)) {
            return RackLogger.Level.WARN;
        }
        if (this.logger.isLoggable(Level.SEVERE)) {
            return RackLogger.Level.ERROR;
        }
        if (this.logger.isLoggable(Level.SEVERE)) {
            return RackLogger.Level.FATAL;
        }
        return null;
    }
}

