/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.bson.MachineId;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.builtin.IRubyObject;

public class GeneratorExtension {
    private static final String OBJECT_ID = "ObjectId".intern();
    private static final String GENERATOR = "Generator".intern();
    private static AtomicInteger counter = new AtomicInteger(new Random().nextInt());
    private static int machineId = new MachineId().value();

    public static void extend(RubyModule rubyModule) {
        RubyClass rubyClass = rubyModule.fastGetClass(OBJECT_ID);
        RubyClass rubyClass2 = rubyClass.fastGetClass(GENERATOR);
        rubyClass2.defineAnnotatedMethods(GeneratorExtension.class);
    }

    @JRubyMethod(name={"next"})
    public static IRubyObject next(IRubyObject iRubyObject) {
        return GeneratorExtension.nextObjectId(iRubyObject, (int)System.currentTimeMillis() / 1000);
    }

    @JRubyMethod(name={"next"})
    public static IRubyObject next(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return GeneratorExtension.nextObjectId(iRubyObject, (int)((RubyInteger)iRubyObject2).getLongValue() / 1000);
    }

    private static IRubyObject nextObjectId(IRubyObject iRubyObject, int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(12).order(ByteOrder.BIG_ENDIAN);
        byteBuffer.putInt(n).putInt(machineId).putInt(counter.getAndIncrement());
        return RubyString.newString((Ruby)iRubyObject.getRuntime(), (byte[])byteBuffer.array());
    }
}

