# frozen_string_literal: true
class Views::Doorkeeper::Authorizations::Error < ::Views::Base
  needs(:pre_auth)

  def content
    widget(Views::FritoPie::Head::Login, :view_title => 'Workplace Search', :no_referrer => true)
    widget(Views::FritoPie::AuthBody, :view_title => 'Workplace Search') do
      div(:class => 'euiCallOut euiCallOut--danger') do
        div(:class => 'euiCallOutHeader') do
          eui_icon(:close, :class => 'euiIcon euiIcon--medium euiCallOutHeader__icon')
          span(t('doorkeeper.authorizations.error.title'), :class => 'euiCallOutHeader__title')
        end
        div(:class => 'euiText euiText--small') do
          p(pre_auth.error_response.body[:error_description], :class => 'auth_failed_description')
        end
      end
    end
  end
end
