# frozen_string_literal: true

class Views::FritoPie::Components::OnboardingCarousel < ::Views::Base
  def content
    div(:class => 'onboarding-carousel-container') do
      div(:class => 'onboarding-carousel-captions') do
        # Commented out by Kellen Aug 14, 2019 until we have said features. :)
        # div(:class => 'onboarding-carousel-caption') do
        #   div('Swiftype for Google Chrome', :class => 'onboarding-carousel-caption__title')
        #   p('Highly relevant, contextual content right alongside the tools you used most for improved efficiency and discoverability', :class => 'onboarding-carousel-caption__description')
        # end
        #
        # div(:class => 'onboarding-carousel-caption') do
        #   div('Swiftype for Mobile', :class => 'onboarding-carousel-caption__title')
        #   p('Find the right content on the go with Swiftype's iOS and Android mobile apps.', :class => 'onboarding-carousel-caption__description')
        # end
        #
        # div(:class => 'onboarding-carousel-caption') do
        #   div('Predictive and intuitive', :class => 'onboarding-carousel-caption__title')
        #   p('Swiftype's AI technolgy predicts and presents relevant information right on time.', :class => 'onboarding-carousel-caption__description')
        # end
      end

      div(:class => 'onboarding-carousel-content') do
        div(:class => 'onboarding-carousel-content__slide onboarding-carousel-content__slide--browser-extension') do
          div(:class => 'slide') do
            div(:class => 'slide__layer slide__layer--0') do
              image_tag('frito_pie/account-onboarding/browser-extension__layer-0.jpg')
            end
            div(:class => 'slide__layer slide__layer--1') do
              image_tag('frito_pie/account-onboarding/browser-extension__layer-1.jpg')
            end
            div(:class => 'slide__layer slide__layer--2') do
              image_tag('frito_pie/account-onboarding/browser-extension__layer-2.jpg')
            end
          end
        end

        div(:class => 'onboarding-carousel-content__slide onboarding-carousel-content__slide--mobile') do
          div(:class => 'slide') do
            div(:class => 'slide__layer slide__layer--0') do
              image_tag('frito_pie/account-onboarding/mobile__layer-0.png')
            end
            div(:class => 'slide__layer slide__layer--1') do
              image_tag('frito_pie/account-onboarding/mobile__layer-1.png')
            end
            div(:class => 'slide__layer slide__layer--2') do
              image_tag('frito_pie/account-onboarding/mobile__layer-2.png')
            end
          end
        end

        div(:class => 'onboarding-carousel-content__slide onboarding-carousel-content__slide--predictive-cards') do
          div(:class => 'slide') do
            div(:class => 'slide__layer slide__layer--0') do
              image_tag('frito_pie/account-onboarding/predictive-card__0.png')
            end
            div(:class => 'slide__layer slide__layer--1') do
              image_tag('frito_pie/account-onboarding/predictive-card__1.png')
            end
            div(:class => 'slide__layer slide__layer--2') do
              image_tag('frito_pie/account-onboarding/predictive-card__2.png')
            end
            div(:class => 'slide__layer slide__layer--3') do
              image_tag('frito_pie/account-onboarding/predictive-card__3.png')
            end
            div(:class => 'slide__layer slide__layer--4') do
              image_tag('frito_pie/account-onboarding/predictive-card__4.png')
            end
            div(:class => 'slide__layer slide__layer--5') do
              image_tag('frito_pie/account-onboarding/predictive-card__5.png')
            end
          end
        end
      end
    end

    content_for :page_javascript do
      javascript <<-JAVASCRIPT
        $(function() {
          $('.onboarding-carousel-container').each(function() {
            var captions = $('.onboarding-carousel-caption', this);
            var slides = $('.onboarding-carousel-content__slide', this);
            var currentSlide = 0;
            var totalSlides = slides.length - 1;
            var speed = 8000;

            function showSlide(number) {
              if(!$(slides[number]).hasClass('.onboarding-carousel-content__slide--visible')) {
                slides.removeClass('onboarding-carousel-content__slide--visible');
                $(slides[number]).addClass('onboarding-carousel-content__slide--visible');

                captions.removeClass('onboarding-carousel-caption--visible');
                $(captions[number]).addClass('onboarding-carousel-caption--visible');
              }

              setTimeout(function() {
                if (currentSlide < totalSlides) {
                  currentSlide++;
                } else {
                  currentSlide = 0;
                }

                showSlide(currentSlide);
              }, speed);
            }

            showSlide(currentSlide);
          });
        })
      JAVASCRIPT
    end
  end
end
