#!/bin/bash

set -e

if type -p java >/dev/null; then
    echo "Found java executable in PATH"
    export _JAVA=java
else
    echo "Could not find java in PATH"
    sleep 1  # ensure the echo above is captured by journald: https://unix.stackexchange.com/a/291524
    exit 1
fi
export JAVA_VERSION=$("$_JAVA" -version 2>&1 | awk -F '"' '/version/ {print $2}')
export MAJOR_JAVA_VERSION=$(echo "$JAVA_VERSION" | awk -F. '{print(($1 == '1') ? $2 : $1)}')

echo "Java version detected: $JAVA_VERSION (major version: $MAJOR_JAVA_VERSION)"

if [ "$MAJOR_JAVA_VERSION" -lt "11" ] ; then
    echo "Elastic Enterprise Search requires Java version 11, current version is $JAVA_VERSION"
    sleep 1  # ensure the echo above is captured by journald: https://unix.stackexchange.com/a/291524
    exit 1
fi

if [ "$MAJOR_JAVA_VERSION" -gt "11" ] ; then
    echo "WARNING: Elastic Enterprise Search does not officially support Java versions higher than 11, current version is $JAVA_VERSION"
    echo "         We will continue the startup procedure, but no support requests for this deployment will be accepted by Elastic."
fi
