# frozen_string_literal: true
class Views::FritoPie::Eweb2::Index < ::Views::Base
  def custom_org_icon
    FritoPie::Organization.frito_togo_default_org.icon
  end

  def content
    doctype!
    html(:lang => 'en') do
      head do
        title('Elastic Workplace Search')
        common_meta_tags
        if custom_org_icon
          widget Views::Eweb::CustomFavicon, :icon => custom_org_icon
        else
          widget Views::Shared::Favicon, :product => 'workplace-search'
        end
        stylesheet_packs_with_chunks_tag('eweb2')
      end
      body do
        div(:id => 'app')

        javascript_packs_with_chunks_tag('eweb2')
      end
    end
  end
end
