/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;

public class WarMain
extends JarMain {
    static final String MAIN = '/' + WarMain.class.getName().replace('.', '/') + ".class";
    static final String WEBSERVER_PROPERTIES = "/WEB-INF/webserver.properties";
    static final String WEBSERVER_JAR = "/WEB-INF/webserver.jar";
    static final String WEBSERVER_CONFIG = "/WEB-INF/webserver.xml";
    private final String[] arguments;
    private final String executable;
    private final String[] executableArgv;
    private File webroot;

    WarMain(String[] args) {
        super(args);
        List<String> argsList = Arrays.asList(args);
        int sIndex = argsList.indexOf("-S");
        if (sIndex == -1) {
            this.executable = null;
            this.executableArgv = null;
            this.arguments = null;
        } else {
            if (args.length == sIndex + 1 || args[sIndex + 1].isEmpty()) {
                throw new IllegalArgumentException("missing executable after -S");
            }
            this.arguments = argsList.subList(0, sIndex).toArray(new String[0]);
            String execArg = argsList.get(sIndex + 1);
            this.executableArgv = argsList.subList(sIndex + 2, argsList.size()).toArray(new String[0]);
            if (execArg.equals("rails")) {
                execArg = "./META-INF/rails.rb";
            } else if (execArg.equals("bundle") && this.executableArgv.length > 0 && this.executableArgv[0].equals("exec")) {
                this.warn("`bundle exec' may drop out of the Warbler environment and into the system environment");
            }
            this.executable = execArg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL extractWebserver() throws Exception {
        this.webroot = File.createTempFile("warbler", "webroot");
        this.webroot.delete();
        this.webroot.mkdirs();
        this.webroot = new File(this.webroot, new File(this.archive).getName());
        this.debug("webroot directory is " + this.webroot.getPath());
        InputStream jarStream = new URI("jar", this.entryPath(WEBSERVER_JAR), null).toURL().openStream();
        File jarFile = File.createTempFile("webserver", ".jar");
        jarFile.deleteOnExit();
        FileOutputStream outStream = new FileOutputStream(jarFile);
        try {
            int bytesRead;
            byte[] buf = new byte[4096];
            while ((bytesRead = jarStream.read(buf)) != -1) {
                outStream.write(buf, 0, bytesRead);
            }
        }
        finally {
            jarStream.close();
            outStream.close();
        }
        this.debug("webserver.jar extracted to " + jarFile.getPath());
        return jarFile.toURI().toURL();
    }

    private Properties getWebserverProperties() throws Exception {
        Properties props = new Properties();
        try {
            InputStream is = this.getClass().getResourceAsStream(WEBSERVER_PROPERTIES);
            if (is != null) {
                props.load(is);
            }
        }
        catch (Exception is) {
            // empty catch block
        }
        String port = WarMain.getSystemProperty("warbler.port", WarMain.getENV("PORT"));
        port = port == null ? "8080" : port;
        String host = WarMain.getSystemProperty("warbler.host", "0.0.0.0");
        String webserverConfig = WarMain.getSystemProperty("warbler.webserver_config", WarMain.getENV("WARBLER_WEBSERVER_CONFIG"));
        String embeddedWebserverConfig = new URI("jar", this.entryPath(WEBSERVER_CONFIG), null).toURL().toString();
        webserverConfig = webserverConfig == null ? embeddedWebserverConfig : webserverConfig;
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String val = (String)entry.getValue();
            val = val.replace("{{warfile}}", this.archive).replace("{{port}}", port).replace("{{host}}", host).replace("{{config}}", webserverConfig).replace("{{webroot}}", this.webroot.getAbsolutePath());
            entry.setValue(val);
        }
        if (props.getProperty("props") != null) {
            String[] propsToSet;
            for (String key : propsToSet = props.getProperty("props").split(",")) {
                WarMain.setSystemProperty(key, props.getProperty(key));
            }
        }
        return props;
    }

    private void launchWebServer(URL jar) throws Exception {
        URLClassLoader loader = new URLClassLoader(new URL[]{jar});
        Thread.currentThread().setContextClassLoader(loader);
        Properties props = this.getWebserverProperties();
        String mainClass = props.getProperty("mainclass");
        if (mainClass == null) {
            throw new IllegalArgumentException("unknown webserver main class (/WEB-INF/webserver.properties is missing 'mainclass' property)");
        }
        Class<?> klass = Class.forName(mainClass, true, loader);
        Method main = klass.getDeclaredMethod("main", String[].class);
        Object[] newArgs = this.launchWebServerArguments(props);
        this.debug("invoking webserver with: " + Arrays.deepToString(newArgs));
        main.invoke(null, new Object[]{newArgs});
    }

    private String[] launchWebServerArguments(Properties props) {
        String[] newArgs = this.args;
        if (props.getProperty("args") != null) {
            String[] insertArgs = props.getProperty("args").split(",");
            newArgs = new String[this.args.length + insertArgs.length];
            for (int i = 0; i < insertArgs.length; ++i) {
                newArgs[i] = props.getProperty(insertArgs[i], "");
            }
            System.arraycopy(this.args, 0, newArgs, insertArgs.length, this.args.length);
        }
        return newArgs;
    }

    protected String getExtractEntryPath(JarEntry entry) {
        String name = entry.getName();
        String start = "WEB-INF";
        if (name.startsWith("WEB-INF")) {
            return name.substring("WEB-INF".length());
        }
        if (name.indexOf(47) == -1) {
            return "/public/" + name;
        }
        return '/' + name;
    }

    protected URL extractEntry(JarEntry entry, String path) throws Exception {
        URL entryURL = super.extractEntry(entry, path);
        return path.endsWith(".jar") && path.startsWith("/lib/") ? entryURL : null;
    }

    protected int launchJRuby(URL[] jars) throws Exception {
        Object scriptingContainer = this.newScriptingContainer(jars);
        WarMain.invokeMethod(scriptingContainer, "setArgv", new Object[]{this.executableArgv});
        WarMain.invokeMethod(scriptingContainer, "setCurrentDirectory", this.extractRoot.getAbsolutePath());
        this.initJRubyScriptingEnv(scriptingContainer);
        Object provider = WarMain.invokeMethod(scriptingContainer, "getProvider", new Object[0]);
        Object rubyInstanceConfig = WarMain.invokeMethod(provider, "getRubyInstanceConfig", new Object[0]);
        WarMain.invokeMethod(rubyInstanceConfig, "setUpdateNativeENVEnabled", new Class[]{Boolean.TYPE}, new Object[]{false});
        CharSequence execScriptEnvPre = this.executableScriptEnvPrefix();
        String executablePath = this.locateExecutable(scriptingContainer, execScriptEnvPre);
        if (executablePath == null) {
            throw new IllegalStateException("failed to locate gem executable: '" + this.executable + "'");
        }
        WarMain.invokeMethod(scriptingContainer, "setScriptFilename", executablePath);
        WarMain.invokeMethod(rubyInstanceConfig, "processArguments", new Object[]{this.arguments});
        Object runtime = WarMain.invokeMethod(scriptingContainer, "getRuntime", new Object[0]);
        this.debug("loading resource: " + executablePath);
        SequenceInputStream executableInput = new SequenceInputStream(new ByteArrayInputStream(execScriptEnvPre.toString().getBytes()), (InputStream)WarMain.invokeMethod(rubyInstanceConfig, "getScriptSource", new Object[0]));
        this.debug("invoking " + executablePath + " with: " + Arrays.toString(this.executableArgv));
        Object outcome = WarMain.invokeMethod(runtime, "runFromMain", new Class[]{InputStream.class, String.class}, new Object[]{executableInput, executablePath});
        return outcome instanceof Number ? ((Number)outcome).intValue() : 0;
    }

    @Deprecated
    protected String locateExecutable(Object scriptingContainer) throws Exception {
        if (this.executable == null) {
            throw new IllegalStateException("no executable");
        }
        File exec = new File(this.extractRoot, this.executable);
        if (exec.exists()) {
            return exec.getAbsolutePath();
        }
        String script = this.locateExecutableScript(this.executable, this.executableScriptEnvPrefix());
        return (String)WarMain.invokeMethod(scriptingContainer, "runScriptlet", script);
    }

    protected String locateExecutable(Object scriptingContainer, CharSequence envPreScript) throws Exception {
        if (this.executable == null) {
            throw new IllegalStateException("no executable");
        }
        File exec = new File(this.extractRoot, this.executable);
        if (exec.exists()) {
            return exec.getAbsolutePath();
        }
        String script = this.locateExecutableScript(this.executable, envPreScript);
        return (String)WarMain.invokeMethod(scriptingContainer, "runScriptlet", script);
    }

    protected CharSequence executableScriptEnvPrefix() {
        String gemsDir = new File(this.extractRoot, "gems").getAbsolutePath();
        String gemfile = new File(this.extractRoot, "Gemfile").getAbsolutePath();
        this.debug("setting GEM_HOME to " + gemsDir);
        this.debug("... and BUNDLE_GEMFILE to " + gemfile);
        return "ENV['GEM_HOME'] = ENV['GEM_PATH'] = '" + gemsDir + "' \n" + "ENV['BUNDLE_GEMFILE'] ||= '" + gemfile + "' \n" + "require 'uri:classloader:/META-INF/init.rb'";
    }

    protected String locateExecutableScript(String executable, CharSequence envPreScript) {
        return (envPreScript == null ? "" : envPreScript + " \n") + "begin\n" + "  require 'rubygems' unless defined?(Gem) \n" + "  begin\n" + "    require 'bundler' \n" + "  rescue LoadError\n" + "  else\n" + "    env = ENV['RAILS_ENV'] || ENV['RACK_ENV'] \n" + "    env ? Bundler.setup(:default, env) : Bundler.setup(:default) \n" + "  end if ENV_JAVA['warbler.bundler.setup'] != 'false' \n" + "  exec = '" + executable + "' \n" + "  spec = Gem::Specification.find { |s| s.executables.include?(exec) } \n" + "  spec ? spec.bin_file(exec) : nil \n" + "rescue SystemExit => e\n" + "  e.status\n" + "end";
    }

    protected void initJRubyScriptingEnv(Object scriptingContainer) throws Exception {
        WarMain.invokeMethod(scriptingContainer, "runScriptlet", "SCRIPTING_CONTAINER_INITIALIZED=true");
        WarMain.invokeMethod(scriptingContainer, "setHomeDirectory", "uri:classloader:/META-INF/jruby.home");
    }

    protected int start() throws Exception {
        if (this.executable == null) {
            try {
                URL server = this.extractWebserver();
                this.launchWebServer(server);
            }
            catch (FileNotFoundException e) {
                String msg = e.getMessage();
                if (msg != null && msg.contains("WEB-INF/webserver.jar")) {
                    System.out.println("specify the -S argument followed by the bin file to run e.g. `java -jar rails.war -S rake -T` ...");
                    System.out.println("(or if you'd like your .war file to start a web server package it using `warbler executable war`)");
                }
                throw e;
            }
            return 0;
        }
        return super.start();
    }

    public void run() {
        super.run();
        if (this.webroot != null) {
            this.delete(this.webroot.getParentFile());
        }
    }

    public static void main(String[] args) {
        WarMain.doStart(new WarMain(args));
    }
}

