/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack;

import java.util.Queue;
import org.jruby.rack.PoolingRackApplicationFactory;
import org.jruby.rack.RackApplication;
import org.jruby.rack.RackApplicationFactory;
import org.jruby.rack.RackInitializationException;
import org.jruby.rack.RackLogger;

public class SerialPoolingRackApplicationFactory
extends PoolingRackApplicationFactory {
    public SerialPoolingRackApplicationFactory(RackApplicationFactory factory) {
        super(factory);
    }

    @Override
    protected void launchInitialization(Queue<RackApplication> apps) {
        while (!apps.isEmpty()) {
            RackApplication app = apps.remove();
            try {
                app.init();
                this.applicationPool.add(app);
                this.log(RackLogger.Level.INFO, "added application to pool, size now = " + this.applicationPool.size());
            }
            catch (RackInitializationException e) {
                this.log(RackLogger.Level.ERROR, "unable to initialize application", (Exception)e);
            }
        }
    }

    @Override
    protected void waitTillPoolReady() {
    }
}

