/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.thumbnails4j.xls;

import co.elastic.thumbnails4j.core.Dimensions;
import co.elastic.thumbnails4j.core.ThumbnailUtils;
import co.elastic.thumbnails4j.core.Thumbnailer;
import co.elastic.thumbnails4j.core.ThumbnailingException;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.poi.hssf.converter.ExcelToHtmlConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class XLSThumbnailer
implements Thumbnailer {
    Logger logger = LoggerFactory.getLogger(XLSThumbnailer.class);

    public List<BufferedImage> getThumbnails(File input, List<Dimensions> dimensions) throws ThumbnailingException {
        try {
            return this.getThumbnails(ExcelToHtmlConverter.process((File)input), dimensions);
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            this.logger.error("Failed to parse XLS: ", (Throwable)e);
            throw new ThumbnailingException(e);
        }
    }

    public List<BufferedImage> getThumbnails(InputStream input, List<Dimensions> dimensions) throws ThumbnailingException {
        try {
            return this.getThumbnails(ExcelToHtmlConverter.process((InputStream)input), dimensions);
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            this.logger.error("Failed to parse XLS: ", (Throwable)e);
            throw new ThumbnailingException(e);
        }
    }

    private List<BufferedImage> getThumbnails(Document xhtml_dom, List<Dimensions> dimensions) throws TransformerException {
        DOMSource domSource = new DOMSource(xhtml_dom);
        ByteArrayOutputStream html = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(html);
        ThumbnailUtils.getTransformerForXhtmlDOM().transform(domSource, streamResult);
        BufferedImage image = ThumbnailUtils.clipHtmlToImage((byte[])html.toByteArray(), (Dimensions)ThumbnailUtils.getMaxInMemoryBuffer());
        ArrayList<BufferedImage> results = new ArrayList<BufferedImage>();
        for (Dimensions singleDimension : dimensions) {
            results.add(ThumbnailUtils.scaleImage((BufferedImage)image, (Dimensions)singleDimension));
        }
        return results;
    }
}

