"use strict";
/*
 * ELASTICSEARCH CONFIDENTIAL
 * __________________
 *
 *  Copyright Elasticsearch B.V. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Elasticsearch B.V. and its suppliers, if any.
 * The intellectual and technical concepts contained herein
 * are proprietary to Elasticsearch B.V. and its suppliers and
 * may be covered by U.S. and Foreign Patents, patents in
 * process, and are protected by trade secret or copyright
 * law.  Dissemination of this information or reproduction of
 * this material is strictly forbidden unless prior written
 * permission is obtained from Elasticsearch B.V.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElasticsearchConfig = exports.elasticsearchSchema = void 0;
var joi_1 = __importDefault(require("joi"));
var ssl_config_1 = require("./ssl_config");
var preValidatedCheck = {
    is: joi_1.default.boolean().valid(false),
    then: joi_1.default.required(),
};
exports.elasticsearchSchema = joi_1.default.object({
    preValidated: joi_1.default.boolean().default(false),
    host: joi_1.default.string().uri().when('preValidated', preValidatedCheck),
    username: joi_1.default.string().when('preValidated', preValidatedCheck),
    password: joi_1.default.string().when('preValidated', preValidatedCheck),
    ssl: ssl_config_1.baseSslSchema.keys({
        verificationMode: joi_1.default.string()
            .valid('full', 'certificate', 'none')
            .default('full'),
    }),
});
var ElasticsearchConfig = /** @class */ (function () {
    function ElasticsearchConfig(_a) {
        var host = _a.host, username = _a.username, password = _a.password, ssl = _a.ssl, preValidated = _a.preValidated;
        this.host = host;
        this.username = username;
        this.password = password;
        this.preValidated = preValidated;
        if (ssl) {
            var _b = new ssl_config_1.BaseSslConfig({
                certificate: ssl.certificate,
                certificateAuthorities: ssl.certificateAuthorities,
                key: ssl.key,
                keyPassphrase: ssl.keyPassphrase,
            }), key = _b.key, certificate = _b.certificate, certificateAuthorities = _b.certificateAuthorities, keyPassphrase = _b.keyPassphrase;
            var verificationMode = ssl.verificationMode;
            this.ssl = {
                key: key,
                certificate: certificate,
                certificateAuthorities: certificateAuthorities,
                keyPassphrase: keyPassphrase,
                verificationMode: verificationMode,
            };
        }
    }
    return ElasticsearchConfig;
}());
exports.ElasticsearchConfig = ElasticsearchConfig;
//# sourceMappingURL=elasticsearch_config.js.map