"use strict";
/*
 * ELASTICSEARCH CONFIDENTIAL
 * __________________
 *
 *  Copyright Elasticsearch B.V. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Elasticsearch B.V. and its suppliers, if any.
 * The intellectual and technical concepts contained herein
 * are proprietary to Elasticsearch B.V. and its suppliers and
 * may be covered by U.S. and Foreign Patents, patents in
 * process, and are protected by trade secret or copyright
 * law.  Dissemination of this information or reproduction of
 * this material is strictly forbidden unless prior written
 * permission is obtained from Elasticsearch B.V.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getInstalledPackages = getInstalledPackages;
// from https://github.com/elastic/kibana/blob/master/src/dev/npm/installed_packages.ts
var path_1 = require("path");
var fs_1 = require("fs");
var util_1 = require("util");
var license_checker_1 = require("license-checker");
var toArray = function (input) { return [].concat(input); };
function resolveLicenses(isPrivate, realPath, licenses) {
    // `license-checker` marks all packages that have `private: true`
    // in their `package.json` as "UNLICENSED", so we try to lookup the
    // actual license by reading the license field from their package.json
    if (isPrivate && licenses === 'UNLICENSED') {
        try {
            var pkg = JSON.parse((0, fs_1.readFileSync)((0, path_1.resolve)(realPath, 'package.json'), 'utf8'));
            if (!pkg.license) {
                throw new Error('no license field');
            }
            return [pkg.license];
        }
        catch (error) {
            throw new Error("Unable to detect license for `\"private\": true` package at ".concat(realPath, ": ").concat(error.message));
        }
    }
    return toArray(licenses || []);
}
function readModuleInfo(pkgAndVersion, moduleInfo, dev, options) {
    var directory = moduleInfo.realPath;
    if (directory === options.directory) {
        return;
    }
    var isPrivate = !!moduleInfo.private;
    var keyParts = pkgAndVersion.split('@');
    var name = keyParts.slice(0, -1).join('@');
    var version = keyParts[keyParts.length - 1];
    var override = options.licenseOverrides && options.licenseOverrides[pkgAndVersion];
    return {
        name: name,
        version: version,
        isDevOnly: dev,
        repository: moduleInfo.repository,
        directory: directory,
        relative: (0, path_1.relative)(options.directory, directory),
        licenses: toArray(override
            ? override
            : resolveLicenses(isPrivate, directory, moduleInfo.licenses)),
    };
}
function _getInstalledPackages(dev, options) {
    return __awaiter(this, void 0, void 0, function () {
        var lcResult, result, _a, _b, _c, pkgAndVersion, moduleInfo, installedPackage;
        var e_1, _d;
        return __generator(this, function (_e) {
            switch (_e.label) {
                case 0: return [4 /*yield*/, (0, util_1.promisify)(license_checker_1.init)({
                        start: options.directory,
                        development: dev,
                        production: !dev,
                        json: true,
                        customFormat: {
                            realPath: true,
                            licenseText: false,
                            licenseFile: false,
                        },
                    })];
                case 1:
                    lcResult = _e.sent();
                    result = [];
                    try {
                        for (_a = __values(Object.entries(lcResult)), _b = _a.next(); !_b.done; _b = _a.next()) {
                            _c = __read(_b.value, 2), pkgAndVersion = _c[0], moduleInfo = _c[1];
                            installedPackage = readModuleInfo(pkgAndVersion, moduleInfo, dev, options);
                            if (installedPackage) {
                                result.push(installedPackage);
                            }
                        }
                    }
                    catch (e_1_1) { e_1 = { error: e_1_1 }; }
                    finally {
                        try {
                            if (_b && !_b.done && (_d = _a.return)) _d.call(_a);
                        }
                        finally { if (e_1) throw e_1.error; }
                    }
                    return [2 /*return*/, result];
            }
        });
    });
}
/**
 *  Get a list of objects with details about each installed
 *  NPM package.
 */
function getInstalledPackages(options) {
    return __awaiter(this, void 0, void 0, function () {
        var _a, _b, _c;
        return __generator(this, function (_d) {
            switch (_d.label) {
                case 0:
                    _a = [[]];
                    return [4 /*yield*/, _getInstalledPackages(false, options)];
                case 1:
                    _b = [__spreadArray.apply(void 0, _a.concat([__read.apply(void 0, [(_d.sent())]), false]))];
                    if (!options.includeDev) return [3 /*break*/, 3];
                    return [4 /*yield*/, _getInstalledPackages(true, options)];
                case 2:
                    _c = _d.sent();
                    return [3 /*break*/, 4];
                case 3:
                    _c = [];
                    _d.label = 4;
                case 4: return [2 /*return*/, __spreadArray.apply(void 0, _b.concat([__read.apply(void 0, [(_c)]), false]))];
            }
        });
    });
}
//# sourceMappingURL=installed_packages.js.map