"use strict";
/*
 * ELASTICSEARCH CONFIDENTIAL
 * __________________
 *
 *  Copyright Elasticsearch B.V. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Elasticsearch B.V. and its suppliers, if any.
 * The intellectual and technical concepts contained herein
 * are proprietary to Elasticsearch B.V. and its suppliers and
 * may be covered by U.S. and Foreign Patents, patents in
 * process, and are protected by trade secret or copyright
 * law.  Dissemination of this information or reproduction of
 * this material is strictly forbidden unless prior written
 * permission is obtained from Elasticsearch B.V.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getClusterDetails = getClusterDetails;
var compare_1 = __importDefault(require("semver/functions/compare"));
var axios_1 = __importDefault(require("axios"));
var axios_retry_1 = __importDefault(require("axios-retry"));
var https_1 = require("https");
var config_service_1 = require("./config/config_service");
(0, axios_retry_1.default)(axios_1.default, {
    retries: config_service_1.Constants.ELASTIC_CONNECT_RETRIES,
    retryDelay: function (retryCount) {
        return retryCount * config_service_1.Constants.ELASTIC_CONNECT_RETRY_MULTIPLY;
    },
});
var generateSslConfig = function (_a) {
    var key = _a.key, certificate = _a.certificate, certificateAuthorities = _a.certificateAuthorities, keyPassphrase = _a.keyPassphrase, verificationMode = _a.verificationMode;
    var ssl = {
        ca: certificateAuthorities,
    };
    switch (verificationMode) {
        case 'none':
            ssl.rejectUnauthorized = false;
            break;
        case 'certificate':
            ssl.rejectUnauthorized = true;
            // by default, NodeJS is checking the server identify
            ssl.checkServerIdentity = function () { return undefined; };
            break;
        case 'full':
            ssl.rejectUnauthorized = true;
            break;
        default:
            throw new Error("Unknown ssl verificationMode: ".concat(verificationMode));
    }
    // Add client certificate and key if required by elasticsearch
    if (certificate && key) {
        ssl.cert = certificate;
        ssl.key = key;
        ssl.passphrase = keyPassphrase;
    }
    return ssl;
};
var getInfoDetails = function (_a, httpsAgent_1) {
    return __awaiter(this, arguments, void 0, function (_b, httpsAgent) {
        var response, _c, cluster_name, version, error_1;
        var host = _b.host, username = _b.username, password = _b.password;
        return __generator(this, function (_d) {
            switch (_d.label) {
                case 0:
                    _d.trys.push([0, 2, , 3]);
                    return [4 /*yield*/, axios_1.default.get(host, {
                            auth: { username: username, password: password },
                            httpsAgent: httpsAgent,
                        })];
                case 1:
                    response = _d.sent();
                    _c = response.data, cluster_name = _c.cluster_name, version = _c.version;
                    return [2 /*return*/, {
                            name: cluster_name,
                            version: version.number,
                        }];
                case 2:
                    error_1 = _d.sent();
                    if (axios_1.default.isAxiosError(error_1) || error_1 instanceof Error) {
                        throw new Error(error_1.message);
                    }
                    else {
                        throw new Error("Unknown error getting cluster details");
                    }
                    return [3 /*break*/, 3];
                case 3: return [2 /*return*/];
            }
        });
    });
};
function getClusterDetails(clientOptions) {
    return __awaiter(this, void 0, void 0, function () {
        var httpsAgent, ssl, _a, name, version, canBeEnterprise, params, host, username, password, response, license, status, type, uid;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    ssl = clientOptions.ssl;
                    if (ssl)
                        httpsAgent = new https_1.Agent(generateSslConfig(ssl));
                    return [4 /*yield*/, getInfoDetails(clientOptions, httpsAgent)];
                case 1:
                    _a = _b.sent(), name = _a.name, version = _a.version;
                    canBeEnterprise = (0, compare_1.default)(version, '7.6.0') >= 0;
                    params = canBeEnterprise ? { accept_enterprise: true } : {};
                    host = clientOptions.host, username = clientOptions.username, password = clientOptions.password;
                    return [4 /*yield*/, axios_1.default.get(host + '/_license', {
                            auth: { username: username, password: password },
                            params: params,
                            httpsAgent: httpsAgent,
                        })];
                case 2:
                    response = _b.sent();
                    license = response.data.license;
                    status = license.status, type = license.type, uid = license.uid;
                    // Return all cluster gathered data
                    return [2 /*return*/, {
                            cluster: { name: name, version: version },
                            license: { status: status, type: type, uid: uid },
                        }];
            }
        });
    });
}
//# sourceMappingURL=elasticsearch.js.map