"use strict";
/*
 * ELASTICSEARCH CONFIDENTIAL
 * __________________
 *
 *  Copyright Elasticsearch B.V. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Elasticsearch B.V. and its suppliers, if any.
 * The intellectual and technical concepts contained herein
 * are proprietary to Elasticsearch B.V. and its suppliers and
 * may be covered by U.S. and Foreign Patents, patents in
 * process, and are protected by trade secret or copyright
 * law.  Dissemination of this information or reproduction of
 * this material is strictly forbidden unless prior written
 * permission is obtained from Elasticsearch B.V.
 */
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getFileServiceStatus = exports.getTileServiceStatus = exports.getLicenseStatus = exports.ServiceStatusLevel = exports.emsPlatforms = void 0;
exports.getServerStatus = getServerStatus;
var path_1 = __importDefault(require("path"));
var fs_1 = require("fs");
var licensecheck_1 = require("./licensecheck");
var config_service_1 = require("./config/config_service");
var tileservice_1 = require("./tileservice");
var emsPlatforms;
(function (emsPlatforms) {
    emsPlatforms["ubi"] = "ubi";
    emsPlatforms["wolfi"] = "wolfi";
})(emsPlatforms || (exports.emsPlatforms = emsPlatforms = {}));
var ServiceStatusLevel;
(function (ServiceStatusLevel) {
    ServiceStatusLevel[ServiceStatusLevel["available"] = 0] = "available";
    ServiceStatusLevel[ServiceStatusLevel["degraded"] = 1] = "degraded";
    ServiceStatusLevel[ServiceStatusLevel["unavailable"] = 2] = "unavailable";
    ServiceStatusLevel[ServiceStatusLevel["critical"] = 3] = "critical";
})(ServiceStatusLevel || (exports.ServiceStatusLevel = ServiceStatusLevel = {}));
var getDownloadUrl = function (zoomLevel, license) {
    var url = new URL("".concat(zoomLevel.zoom, "-").concat(config_service_1.Constants.BASEMAPS_OMT_VERSION, ".zip"), config_service_1.Constants.BASEMAPS_DOWNLOAD_BASE);
    if (license) {
        var uid = license.uid, type = license.type;
        var params = new URLSearchParams(url.searchParams);
        params.set('license', uid);
        params.set('license_type', type);
        url.search = params.toString();
    }
    var downloadUrl = url.toString();
    return __assign(__assign({}, zoomLevel), { downloadUrl: downloadUrl });
};
function getSummaryStatus(statuses) {
    var grouped = groupByLevel(Object.entries(statuses));
    var highestSeverityLevel = getHighestSeverityLevel(grouped.keys());
    var highestSeverityGroup = grouped.get(highestSeverityLevel);
    if (highestSeverityLevel === ServiceStatusLevel.available) {
        return {
            level: ServiceStatusLevel.available,
            state: ServiceStatusLevel[ServiceStatusLevel.available],
            title: "All services are available",
        };
    }
    else {
        return {
            level: highestSeverityLevel,
            state: ServiceStatusLevel[highestSeverityLevel],
            title: "[".concat(highestSeverityGroup === null || highestSeverityGroup === void 0 ? void 0 : highestSeverityGroup.size, "] services are ").concat(ServiceStatusLevel[highestSeverityLevel]),
            message: "See the individual statuses for more information",
        };
    }
}
function getServerStatus(statuses, version, metadata) {
    return {
        version: version,
        metadata: metadata,
        overall: getSummaryStatus(statuses),
        services: statuses,
    };
}
var groupByLevel = function (statuses) {
    var e_1, _a;
    var byLevel = new Map();
    try {
        for (var statuses_1 = __values(statuses), statuses_1_1 = statuses_1.next(); !statuses_1_1.done; statuses_1_1 = statuses_1.next()) {
            var _b = __read(statuses_1_1.value, 2), serviceName = _b[0], status_1 = _b[1];
            var levelMap = byLevel.get(status_1.level);
            if (!levelMap) {
                levelMap = new Map();
                byLevel.set(status_1.level, levelMap);
            }
            levelMap.set(serviceName, status_1);
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (statuses_1_1 && !statuses_1_1.done && (_a = statuses_1.return)) _a.call(statuses_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return byLevel;
};
var getHighestSeverityLevel = function (levels) {
    var _a;
    var sorted = __spreadArray([], __read(levels), false).sort(function (a, b) {
        if (a < b) {
            return -1;
        }
        else if (a > b) {
            return 1;
        }
        else {
            return 0;
        }
    });
    return (_a = sorted[sorted.length - 1]) !== null && _a !== void 0 ? _a : ServiceStatusLevel.available;
};
var getLicenseStatus = function (_a) {
    var licenseIsValid = _a.licenseIsValid, licenseError = _a.licenseError, license = _a.license;
    try {
        if ([licensecheck_1.LicenseStatus.OK, licensecheck_1.LicenseStatus.PREVALIDATED].includes(licenseIsValid)) {
            return {
                level: ServiceStatusLevel.available,
                state: ServiceStatusLevel[ServiceStatusLevel.available],
                title: licenseIsValid === licensecheck_1.LicenseStatus.OK ? 'Success' : 'Prevalidated',
                meta: {
                    basemapsDownloadUrl: config_service_1.Constants.BASEMAPS_ZOOM_LEVELS.map(function (zoomLevel) {
                        return getDownloadUrl(zoomLevel, license);
                    }),
                },
            };
        }
        else {
            return {
                level: ServiceStatusLevel.critical,
                state: ServiceStatusLevel[ServiceStatusLevel.critical],
                title: 'License error',
                message: licenseError === null || licenseError === void 0 ? void 0 : licenseError.message,
            };
        }
    }
    catch (error) {
        return {
            level: ServiceStatusLevel.critical,
            state: ServiceStatusLevel[ServiceStatusLevel.unavailable],
            title: 'License error',
            message: error.message,
        };
    }
};
exports.getLicenseStatus = getLicenseStatus;
var getTileServiceStatus = function (_a) {
    var tsIsValid = _a.tsIsValid, tsMetadata = _a.tsMetadata, tsError = _a.tsError;
    try {
        if (tsIsValid === tileservice_1.TileServiceStatus.OK) {
            var _b = tsMetadata !== null && tsMetadata !== void 0 ? tsMetadata : {
                maxzoom: 0,
                filesize: '0',
                version: '0.0',
            }, maxzoom = _b.maxzoom, filesize = _b.filesize, version = _b.version;
            var message = maxzoom < config_service_1.Constants.PLANET_MAX_ZOOM
                ? "Map resolution is limited to zoom level ".concat(maxzoom, ". If you require higher resolution basemaps, please follow the instructions to download and install tile service databases.")
                : '';
            return {
                level: ServiceStatusLevel.available,
                state: ServiceStatusLevel[ServiceStatusLevel.available],
                title: 'Success',
                message: message,
                meta: {
                    maxzoom: maxzoom,
                    size: parseInt(filesize),
                    versionTile: version,
                },
            };
        }
        else {
            return {
                level: ServiceStatusLevel.unavailable,
                state: ServiceStatusLevel[ServiceStatusLevel.unavailable],
                title: 'Tile Service is not available',
                message: tsError === null || tsError === void 0 ? void 0 : tsError.message,
            };
        }
    }
    catch (error) {
        return {
            level: ServiceStatusLevel.unavailable,
            state: ServiceStatusLevel[ServiceStatusLevel.unavailable],
            title: 'Tile Service error',
            message: error.message,
        };
    }
};
exports.getTileServiceStatus = getTileServiceStatus;
var getFileServiceStatus = function (emsDir) { return __awaiter(void 0, void 0, void 0, function () {
    var emsFilePath, emsFileVersionEntries, emsDataFilesPath_1, emsFileDataEntriesSize, error_1;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                _a.trys.push([0, 3, , 4]);
                emsFilePath = path_1.default.join(emsDir, 'file');
                return [4 /*yield*/, fs_1.promises.readdir(emsFilePath)];
            case 1:
                emsFileVersionEntries = (_a.sent()).filter(function (d) { return d.startsWith('v'); });
                emsDataFilesPath_1 = path_1.default.join(emsFilePath, 'files');
                return [4 /*yield*/, fs_1.promises.readdir(emsDataFilesPath_1)];
            case 2:
                emsFileDataEntriesSize = (_a.sent())
                    .map(function (f) { return (0, fs_1.statSync)(path_1.default.join(emsDataFilesPath_1, f)).size; })
                    .reduce(function (prev, curr) { return prev + curr; });
                return [2 /*return*/, {
                        level: ServiceStatusLevel.available,
                        state: ServiceStatusLevel[ServiceStatusLevel.available],
                        title: 'Success',
                        meta: {
                            versions: emsFileVersionEntries,
                            size: emsFileDataEntriesSize,
                        },
                    }];
            case 3:
                error_1 = _a.sent();
                return [2 /*return*/, {
                        level: ServiceStatusLevel.unavailable,
                        state: ServiceStatusLevel[ServiceStatusLevel.unavailable],
                        title: 'File Service error',
                        message: error_1.message,
                    }];
            case 4: return [2 /*return*/];
        }
    });
}); };
exports.getFileServiceStatus = getFileServiceStatus;
//# sourceMappingURL=status.js.map