"use strict";
/*
 * ELASTICSEARCH CONFIDENTIAL
 * __________________
 *
 *  Copyright Elasticsearch B.V. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Elasticsearch B.V. and its suppliers, if any.
 * The intellectual and technical concepts contained herein
 * are proprietary to Elasticsearch B.V. and its suppliers and
 * may be covered by U.S. and Foreign Patents, patents in
 * process, and are protected by trade secret or copyright
 * law.  Dissemination of this information or reproduction of
 * this material is strictly forbidden unless prior written
 * permission is obtained from Elasticsearch B.V.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.licenseCheckPre = licenseCheckPre;
var boom_1 = __importDefault(require("@hapi/boom"));
var utils_1 = require("../utils");
var licensecheck_1 = require("../licensecheck");
/* Function to pass to routes "pre" options object for license check*/
function licenseCheckPre(request, h) {
    var _a, _b;
    var valid = (_b = (_a = h === null || h === void 0 ? void 0 : h.context) === null || _a === void 0 ? void 0 : _a.licenseChecker) === null || _b === void 0 ? void 0 : _b.isValid;
    if (utils_1.isDev ||
        valid === licensecheck_1.LicenseStatus.OK ||
        valid === licensecheck_1.LicenseStatus.PREVALIDATED) {
        return true;
    }
    else {
        var message = 'Elasticsearch check: invalid license or unreachable cluster';
        request.server.log(['error', 'license', 'health'], { message: message });
        throw boom_1.default.forbidden(message);
    }
}
//# sourceMappingURL=index.js.map