/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.compute.lucene.DataPartitioning;
import org.elasticsearch.compute.operator.Driver;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;

public final class QueryPragmas
implements Writeable {
    public static final Setting<Integer> EXCHANGE_BUFFER_SIZE = Setting.intSetting((String)"exchange_buffer_size", (int)10, (Setting.Property[])new Setting.Property[0]);
    public static final Setting<Integer> EXCHANGE_CONCURRENT_CLIENTS = Setting.intSetting((String)"exchange_concurrent_clients", (int)2, (Setting.Property[])new Setting.Property[0]);
    public static final Setting<Integer> ENRICH_MAX_WORKERS = Setting.intSetting((String)"enrich_max_workers", (int)1, (Setting.Property[])new Setting.Property[0]);
    public static final Setting<Integer> TASK_CONCURRENCY = Setting.intSetting((String)"task_concurrency", (int)ThreadPool.searchOrGetThreadPoolSize((int)EsExecutors.allocatedProcessors((Settings)Settings.EMPTY)), (Setting.Property[])new Setting.Property[0]);
    public static final Setting<String> DATA_PARTITIONING = Setting.simpleString((String)"data_partitioning", (Setting.Property[])new Setting.Property[0]);
    public static final Setting<Integer> PAGE_SIZE = Setting.intSetting((String)"page_size", (int)0, (int)0, (Setting.Property[])new Setting.Property[0]);
    public static final Setting<TimeValue> STATUS_INTERVAL = Setting.timeSetting((String)"status_interval", (TimeValue)Driver.DEFAULT_STATUS_INTERVAL, (Setting.Property[])new Setting.Property[0]);
    public static final Setting<Integer> MAX_CONCURRENT_NODES_PER_CLUSTER = Setting.intSetting((String)"max_concurrent_nodes_per_cluster", (int)-1, (int)-1, (Setting.Property[])new Setting.Property[0]);
    public static final Setting<Integer> MAX_CONCURRENT_SHARDS_PER_NODE = Setting.intSetting((String)"max_concurrent_shards_per_node", (int)10, (int)1, (int)100, (Setting.Property[])new Setting.Property[0]);
    public static final Setting<Integer> UNAVAILABLE_SHARD_RESOLUTION_ATTEMPTS = Setting.intSetting((String)"unavailable_shard_resolution_attempts", (int)10, (int)-1, (Setting.Property[])new Setting.Property[0]);
    public static final Setting<Boolean> NODE_LEVEL_REDUCTION = Setting.boolSetting((String)"node_level_reduction", (boolean)true, (Setting.Property[])new Setting.Property[0]);
    public static final Setting<ByteSizeValue> FOLD_LIMIT = Setting.memorySizeSetting((String)"fold_limit", (String)"5%", (Setting.Property[])new Setting.Property[0]);
    public static final QueryPragmas EMPTY = new QueryPragmas(Settings.EMPTY);
    private final Settings settings;

    public QueryPragmas(Settings settings) {
        this.settings = settings;
    }

    public QueryPragmas(StreamInput in) throws IOException {
        this.settings = Settings.readSettingsFromStream((StreamInput)in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.settings.writeTo(out);
    }

    public Settings getSettings() {
        return this.settings;
    }

    public int exchangeBufferSize() {
        return (Integer)EXCHANGE_BUFFER_SIZE.get(this.settings);
    }

    public int concurrentExchangeClients() {
        return (Integer)EXCHANGE_CONCURRENT_CLIENTS.get(this.settings);
    }

    public DataPartitioning dataPartitioning(DataPartitioning defaultDataPartitioning) {
        String partitioning = (String)DATA_PARTITIONING.get(this.settings);
        if (partitioning.isEmpty()) {
            return defaultDataPartitioning;
        }
        return DataPartitioning.valueOf((String)partitioning.toUpperCase(Locale.ROOT));
    }

    public int taskConcurrency() {
        return (Integer)TASK_CONCURRENCY.get(this.settings);
    }

    public int pageSize() {
        return (Integer)PAGE_SIZE.get(this.settings);
    }

    public TimeValue statusInterval() {
        return (TimeValue)STATUS_INTERVAL.get(this.settings);
    }

    public int enrichMaxWorkers() {
        return (Integer)ENRICH_MAX_WORKERS.get(this.settings);
    }

    public int maxConcurrentNodesPerCluster() {
        return (Integer)MAX_CONCURRENT_NODES_PER_CLUSTER.get(this.settings);
    }

    public int maxConcurrentShardsPerNode() {
        return (Integer)MAX_CONCURRENT_SHARDS_PER_NODE.get(this.settings);
    }

    public int unavailableShardResolutionAttempts() {
        return (Integer)UNAVAILABLE_SHARD_RESOLUTION_ATTEMPTS.get(this.settings);
    }

    public boolean nodeLevelReduction() {
        return (Boolean)NODE_LEVEL_REDUCTION.get(this.settings);
    }

    public ByteSizeValue foldLimit() {
        return (ByteSizeValue)FOLD_LIMIT.get(this.settings);
    }

    public boolean isEmpty() {
        return this.settings.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryPragmas pragmas = (QueryPragmas)o;
        return this.settings.equals((Object)pragmas.settings);
    }

    public int hashCode() {
        return Objects.hash(this.settings);
    }

    public String toString() {
        return this.settings.toString();
    }
}

