/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.DriverCompletionInfo;
import org.elasticsearch.compute.operator.DriverProfile;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.xpack.esql.plugin.ComputeResponse;
import org.elasticsearch.xpack.esql.plugin.DataNodeComputeHandler;

final class DataNodeComputeResponse
extends TransportResponse {
    private static final TransportVersion ESQL_DOCUMENTS_FOUND_AND_VALUES_LOADED = TransportVersion.fromName((String)"esql_documents_found_and_values_loaded");
    private final DriverCompletionInfo completionInfo;
    private final Map<ShardId, Exception> shardLevelFailures;

    DataNodeComputeResponse(DriverCompletionInfo completionInfo, Map<ShardId, Exception> shardLevelFailures) {
        this.completionInfo = completionInfo;
        this.shardLevelFailures = shardLevelFailures;
    }

    DataNodeComputeResponse(StreamInput in) throws IOException {
        if (in.getTransportVersion().supports(ESQL_DOCUMENTS_FOUND_AND_VALUES_LOADED)) {
            this.completionInfo = DriverCompletionInfo.readFrom((StreamInput)in);
            this.shardLevelFailures = in.readMap(ShardId::new, StreamInput::readException);
            return;
        }
        if (DataNodeComputeHandler.supportShardLevelRetryFailure(in.getTransportVersion())) {
            this.completionInfo = new DriverCompletionInfo(0L, 0L, in.readCollectionAsImmutableList(DriverProfile::new), List.of());
            this.shardLevelFailures = in.readMap(ShardId::new, StreamInput::readException);
            return;
        }
        this.completionInfo = new ComputeResponse(in).getCompletionInfo();
        this.shardLevelFailures = Map.of();
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().supports(ESQL_DOCUMENTS_FOUND_AND_VALUES_LOADED)) {
            this.completionInfo.writeTo(out);
            out.writeMap(this.shardLevelFailures, (o, v) -> v.writeTo(o), StreamOutput::writeException);
            return;
        }
        if (DataNodeComputeHandler.supportShardLevelRetryFailure(out.getTransportVersion())) {
            out.writeCollection((Collection)this.completionInfo.driverProfiles());
            out.writeMap(this.shardLevelFailures, (o, v) -> v.writeTo(o), StreamOutput::writeException);
            return;
        }
        if (!this.shardLevelFailures.isEmpty()) {
            throw new IllegalStateException("shard level failures are not supported in old versions");
        }
        new ComputeResponse(this.completionInfo).writeTo(out);
    }

    public DriverCompletionInfo completionInfo() {
        return this.completionInfo;
    }

    Map<ShardId, Exception> shardLevelFailures() {
        return this.shardLevelFailures;
    }
}

