/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.inference.bulk;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.compute.operator.FailureCollector;
import org.elasticsearch.index.seqno.LocalCheckpointTracker;
import org.elasticsearch.xpack.core.inference.action.InferenceAction;

public class BulkInferenceExecutionState {
    private final LocalCheckpointTracker checkpoint = new LocalCheckpointTracker(-1L, -1L);
    private final FailureCollector failureCollector = new FailureCollector();
    private final Map<Long, InferenceAction.Response> bufferedResponses;
    private final AtomicBoolean finished = new AtomicBoolean(false);

    public BulkInferenceExecutionState() {
        this.bufferedResponses = new ConcurrentHashMap<Long, InferenceAction.Response>();
    }

    public long generateSeqNo() {
        return this.checkpoint.generateSeqNo();
    }

    public long getPersistedCheckpoint() {
        return this.checkpoint.getPersistedCheckpoint();
    }

    public long getProcessedCheckpoint() {
        return this.checkpoint.getProcessedCheckpoint();
    }

    public long getMaxSeqNo() {
        return this.checkpoint.getMaxSeqNo();
    }

    public void markSeqNoAsPersisted(long seqNo) {
        this.checkpoint.markSeqNoAsPersisted(seqNo);
    }

    public synchronized void onInferenceResponse(long seqNo, InferenceAction.Response response) {
        if (response != null && !this.failureCollector.hasFailure()) {
            this.bufferedResponses.put(seqNo, response);
        }
        this.checkpoint.markSeqNoAsProcessed(seqNo);
    }

    public synchronized void onInferenceException(long seqNo, Exception e) {
        this.failureCollector.unwrapAndCollect(e);
        this.checkpoint.markSeqNoAsProcessed(seqNo);
        this.bufferedResponses.clear();
    }

    public synchronized InferenceAction.Response fetchBufferedResponse(long seqNo) {
        return this.bufferedResponses.remove(seqNo);
    }

    public boolean hasFailure() {
        return this.failureCollector.hasFailure();
    }

    public Exception getFailure() {
        return this.failureCollector.getFailure();
    }

    public void addFailure(Exception e) {
        this.failureCollector.unwrapAndCollect(e);
    }

    public boolean finished() {
        return this.hasFailure() || this.finished.get() && this.getMaxSeqNo() == this.getPersistedCheckpoint();
    }

    public void finish() {
        this.finished.set(true);
    }
}

