/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.vector;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.vectors.KnnVectorQueryBuilder;
import org.elasticsearch.xpack.esql.capabilities.PostAnalysisPlanVerificationAware;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.MapExpression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.Check;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.MapParam;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.fulltext.FullTextFunction;
import org.elasticsearch.xpack.esql.expression.function.vector.VectorFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;
import org.elasticsearch.xpack.esql.querydsl.query.KnnQuery;

public class Knn
extends FullTextFunction
implements OptionalArgument,
VectorFunction,
PostAnalysisPlanVerificationAware {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Knn", Knn::readFrom);
    private final Expression field;
    private final Expression options;
    public static final Map<String, DataType> ALLOWED_OPTIONS = Map.ofEntries(Map.entry(KnnVectorQueryBuilder.K_FIELD.getPreferredName(), DataType.INTEGER), Map.entry(KnnVectorQueryBuilder.NUM_CANDS_FIELD.getPreferredName(), DataType.INTEGER), Map.entry(KnnVectorQueryBuilder.VECTOR_SIMILARITY_FIELD.getPreferredName(), DataType.FLOAT), Map.entry(AbstractQueryBuilder.BOOST_FIELD.getPreferredName(), DataType.FLOAT), Map.entry("rescore_oversample", DataType.FLOAT));

    @FunctionInfo(returnType={"boolean"}, preview=true, description="Finds the k nearest vectors to a query vector, as measured by a similarity metric. knn function finds nearest vectors through approximate search on indexed dense_vectors.", examples={@Example(file="knn-function", tag="knn-function"), @Example(file="knn-function", tag="knn-function-options")})
    public Knn(Source source, @Param(name="field", type={"dense_vector"}, description="Field that the query will target.") Expression field, @Param(name="query", type={"dense_vector"}, description="Vector value to find top nearest neighbours for.") Expression query, @MapParam(name="options", params={@MapParam.MapParamEntry(name="boost", type={"float"}, valueHint={"2.5"}, description="Floating point number used to decrease or increase the relevance scores of the query.Defaults to 1.0."), @MapParam.MapParamEntry(name="k", type={"integer"}, valueHint={"10"}, description="The number of nearest neighbors to return from each shard. Elasticsearch collects k results from each shard, then merges them to find the global top results. This value must be less than or equal to num_candidates. Defaults to 10."), @MapParam.MapParamEntry(name="num_candidates", type={"integer"}, valueHint={"10"}, description="The number of nearest neighbor candidates to consider per shard while doing knn search. Cannot exceed 10,000. Increasing num_candidates tends to improve the accuracy of the final results. Defaults to 1.5 * k"), @MapParam.MapParamEntry(name="similarity", type={"double"}, valueHint={"0.01"}, description="The minimum similarity required for a document to be considered a match. The similarity value calculated relates to the raw similarity used, not the document score."), @MapParam.MapParamEntry(name="rescore_oversample", type={"double"}, valueHint={"3.5"}, description="Applies the specified oversampling for rescoring quantized vectors. See [oversampling and rescoring quantized vectors](docs-content://solutions/search/vector/knn.md#dense-vector-knn-search-rescoring) for details.")}, description="(Optional) kNN additional options as <<esql-function-named-params,function named parameters>>. See <<query-dsl-knn-query,knn query>> for more information.", optional=true) Expression options) {
        this(source, field, query, options, null);
    }

    private Knn(Source source, Expression field, Expression query, Expression options, QueryBuilder queryBuilder) {
        super(source, query, options == null ? List.of(field, query) : List.of(field, query, options), queryBuilder);
        this.field = field;
        this.options = options;
    }

    public Expression field() {
        return this.field;
    }

    public Expression options() {
        return this.options;
    }

    @Override
    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    @Override
    protected Expression.TypeResolution resolveParams() {
        return this.resolveField().and(this.resolveQuery()).and(this.resolveOptions());
    }

    private Expression.TypeResolution resolveField() {
        return TypeResolutions.isNotNull((Expression)this.field(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST).and(TypeResolutions.isType((Expression)this.field(), dt -> dt == DataType.DENSE_VECTOR, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])new String[]{"dense_vector"}));
    }

    private Expression.TypeResolution resolveQuery() {
        return TypeResolutions.isType((Expression)this.query(), dt -> dt == DataType.DENSE_VECTOR, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{"dense_vector"}).and(TypeResolutions.isNotNullAndFoldable((Expression)this.query(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND));
    }

    private Expression.TypeResolution resolveOptions() {
        if (this.options() != null) {
            Expression.TypeResolution resolution = TypeResolutions.isNotNull((Expression)this.options(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.THIRD);
            if (resolution.unresolved()) {
                return resolution;
            }
            resolution = TypeResolutions.isMapExpression((Expression)this.options(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.THIRD);
            if (resolution.unresolved()) {
                return resolution;
            }
            try {
                this.knnQueryOptions();
            }
            catch (InvalidArgumentException e) {
                return new Expression.TypeResolution(e.getMessage());
            }
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    private Map<String, Object> knnQueryOptions() throws InvalidArgumentException {
        if (this.options() == null) {
            return Map.of();
        }
        HashMap<String, Object> matchOptions = new HashMap<String, Object>();
        Knn.populateOptionsMap((MapExpression)this.options(), matchOptions, TypeResolutions.ParamOrdinal.THIRD, this.sourceText(), ALLOWED_OPTIONS);
        return matchOptions;
    }

    @Override
    protected Query translate(TranslatorHandler handler) {
        FieldAttribute fieldAttribute = Knn.fieldAsFieldAttribute(this.field());
        Check.notNull((Object)fieldAttribute, (String)"Match must have a field attribute as the first argument");
        String fieldName = Knn.getNameFromFieldAttribute(fieldAttribute);
        List queryFolded = (List)this.query().fold(FoldContext.small());
        float[] queryAsFloats = new float[queryFolded.size()];
        for (int i = 0; i < queryFolded.size(); ++i) {
            queryAsFloats[i] = ((Number)queryFolded.get(i)).floatValue();
        }
        return new KnnQuery(this.source(), fieldName, queryAsFloats, this.queryOptions());
    }

    @Override
    public Expression replaceQueryBuilder(QueryBuilder queryBuilder) {
        return new Knn(this.source(), this.field(), this.query(), this.options(), queryBuilder);
    }

    private Map<String, Object> queryOptions() throws InvalidArgumentException {
        if (this.options() == null) {
            return Map.of();
        }
        HashMap<String, Object> options = new HashMap<String, Object>();
        Knn.populateOptionsMap((MapExpression)this.options(), options, TypeResolutions.ParamOrdinal.THIRD, this.sourceText(), ALLOWED_OPTIONS);
        return options;
    }

    @Override
    public BiConsumer<LogicalPlan, Failures> postAnalysisPlanVerification() {
        return (plan, failures) -> {
            super.postAnalysisPlanVerification().accept((LogicalPlan)((Object)plan), (Failures)failures);
            Knn.fieldVerifier(plan, this, this.field, failures);
        };
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Knn(this.source(), newChildren.get(0), newChildren.get(1), newChildren.size() > 2 ? newChildren.get(2) : null, this.queryBuilder());
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Knn::new, (Object)this.field(), (Object)this.query(), (Object)this.options());
    }

    public String getWriteableName() {
        return Knn.ENTRY.name;
    }

    private static Knn readFrom(StreamInput in) throws IOException {
        Source source = Source.readFrom((StreamInput)((PlanStreamInput)in));
        Expression field = (Expression)in.readNamedWriteable(Expression.class);
        Expression query = (Expression)in.readNamedWriteable(Expression.class);
        QueryBuilder queryBuilder = (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class);
        return new Knn(source, field, query, null, queryBuilder);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.field());
        out.writeNamedWriteable((NamedWriteable)this.query());
        out.writeOptionalNamedWriteable((NamedWriteable)this.queryBuilder());
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Knn knn = (Knn)o;
        return Objects.equals(this.field(), knn.field()) && Objects.equals(this.query(), knn.query()) && Objects.equals(this.queryBuilder(), knn.queryBuilder());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field(), this.query(), this.queryBuilder());
    }
}

