/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.DataTypeConverter;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLongFromBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLongFromDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLongFromIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLongFromStringEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLongFromUnsignedLongEvaluator;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class ToLong
extends AbstractConvertFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "ToLong", ToLong::new);
    private static final Map<DataType, AbstractConvertFunction.BuildFactory> EVALUATORS = Map.ofEntries(Map.entry(DataType.LONG, (source, fieldEval) -> fieldEval), Map.entry(DataType.DATETIME, (source, fieldEval) -> fieldEval), Map.entry(DataType.DATE_NANOS, (source, fieldEval) -> fieldEval), Map.entry(DataType.BOOLEAN, ToLongFromBooleanEvaluator.Factory::new), Map.entry(DataType.KEYWORD, ToLongFromStringEvaluator.Factory::new), Map.entry(DataType.TEXT, ToLongFromStringEvaluator.Factory::new), Map.entry(DataType.DOUBLE, ToLongFromDoubleEvaluator.Factory::new), Map.entry(DataType.UNSIGNED_LONG, ToLongFromUnsignedLongEvaluator.Factory::new), Map.entry(DataType.INTEGER, ToLongFromIntEvaluator.Factory::new), Map.entry(DataType.COUNTER_LONG, (source, field) -> field), Map.entry(DataType.COUNTER_INTEGER, ToLongFromIntEvaluator.Factory::new));

    @FunctionInfo(returnType={"long"}, description="Converts an input value to a long value. If the input parameter is of a date type,\nits value will be interpreted as milliseconds since the {wikipedia}/Unix_time[Unix epoch], converted to long.\nBoolean *true* will be converted to long *1*, *false* to *0*.", examples={@Example(file="ints", tag="to_long-str", explanation="Note that in this example, the last conversion of the string isn't possible.\nWhen this happens, the result is a *null* value. In this case a _Warning_ header is added to the response.\nThe header will provide information on the source of the failure:\n\n`\"Line 1:113: evaluation of [TO_LONG(str3)] failed, treating result as null. Only first 20 failures recorded.\"`\n\nA following header will contain the failure reason and the offending value:\n\n`\"java.lang.NumberFormatException: For input string: \"foo\"\"`")})
    public ToLong(Source source, @Param(name="field", type={"boolean", "date", "date_nanos", "keyword", "text", "double", "long", "unsigned_long", "integer", "counter_integer", "counter_long"}, description="Input value. The input can be a single- or multi-valued column or an expression.") Expression field) {
        super(source, field);
    }

    private ToLong(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return ToLong.ENTRY.name;
    }

    @Override
    protected Map<DataType, AbstractConvertFunction.BuildFactory> factories() {
        return EVALUATORS;
    }

    @Override
    public DataType dataType() {
        return DataType.LONG;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToLong(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToLong::new, (Object)this.field());
    }

    static long fromBoolean(boolean bool) {
        return bool ? 1L : 0L;
    }

    static long fromKeyword(BytesRef in) {
        return EsqlDataTypeConverter.stringToLong(in.utf8ToString());
    }

    static long fromDouble(double dbl) {
        return DataTypeConverter.safeDoubleToLong((double)dbl);
    }

    static long fromUnsignedLong(long ul) {
        return EsqlDataTypeConverter.unsignedLongToLong(ul);
    }

    static long fromInt(int i) {
        return i;
    }
}

